<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

$back = Tools::getValue('back');
$id_address = Tools::getValue('id_address');
$errors = array();

if (!$cookie->isLogged())
    Tools::redirect('authentication.php');

if ($back)
	$smarty->assign('back', Tools::safeOutput($back));
	
if ($id_address)
{
    $address = new Address(intval($id_address));
    if (Validate::isLoadedObject($address) AND Customer::customerHasAddress(intval($cookie->id_customer), intval($id_address)))
    {
		if (isset($_GET['delete']))
		{
			if ($cart->id_address_invoice == $address->id)
				unset($cart->id_address_invoice);
			if ($cart->id_address_delivery == $address->id)
				unset($cart->id_address_delivery);
			if ($address->delete())
				Tools::redirect('addresses.php');
			$errors[] = Tools::displayError('this address cannot be deleted');
		}
		if (!Tools::isSubmit('submitAddress'))
		{
			$fields = $address->getFields();
			foreach ($fields AS $key => $value)
				$_POST[$key] = $value;
		}
		$smarty->assign('id_address', $id_address);
	}
	else
		Tools::redirect('addresses.php');
}

if (Tools::isSubmit('submitAddress'))
{
	$address = new Address();
	$address->id_customer = intval($cookie->id_customer);
	$errors = $address->validateControler();
	
	if (!sizeof($errors))
    {
		if (isset($id_address))
		{
			$address_old = new Address(intval($id_address));
			if (Validate::isLoadedObject($address_old) AND Customer::customerHasAddress(intval($cookie->id_customer), intval($address_old->id)))
			{
				if ($cart->id_address_invoice == $address_old->id)
					unset($cart->id_address_invoice);
				if ($cart->id_address_delivery == $address_old->id)
					unset($cart->id_address_delivery);
						
				if ($address_old->isUsed())					
					$address_old->delete();
				else
				{
					$address->id = intval($address_old->id);
					$address->date_add = $address_old->date_add;
				}
			}
		}

		$result = $address->id ? $address->update() : $address->add();
		if ($result)
			Tools::redirect($back ? $back : 'addresses.php');
		$errors[] = Tools::displayError('an error occurred while updating your address');
    }
}
elseif (!$id_address)
{
	$customer = new Customer(intval($cookie->id_customer));
	$_POST['surname'] = $customer->surname;
	$_POST['name'] = $customer->name;
}


if (isset($_POST['id_country']) AND !empty($_POST['id_country']) AND is_numeric($_POST['id_country']))
	$selectedCountry = intval($_POST['id_country']);
elseif (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
{
	$array = preg_split('/,|-/', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	
	if (!Validate::isLanguageIsoCode($array[0]) OR !($selectedCountry = Country::getByIso($array[0])))
		$selectedCountry = Configuration::get('PS_COUNTRY_DEFAULT');
}
else
	$selectedCountry = Configuration::get('PS_COUNTRY_DEFAULT');

$countries = Country::getCountries($cookie->id_lang, true);
$countriesList = '';
foreach ($countries as $country)
    $countriesList .= '<option value="'.$country['id_country'].'" '.($country['id_country'] == $selectedCountry ? 'selected="selected"' : '').'>'.$country['name'].'</option>';
$smarty->assign('countries_list', $countriesList);

$smarty->assign('errors', $errors);
$smarty->display(_PS_THEME_DIR_.'address.tpl');

include(dirname(__FILE__).'/footer.php');

?>
