<?php

/**
  * Admin panel header, header.inc.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

$timerStart = microtime(true);
ob_start();

$url_redirect = '?redirect='.$_SERVER['REQUEST_URI'];

/* Getting cookie or logout */
if (!class_exists('Cookie'))
	exit();
	
$cookie = new Cookie('psAdmin', substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__), -10));
if (isset($_GET['logout'])) {
	$url_redirect = '';
	$cookie->logout();
 }

/* logged or not */
if (!$cookie->isLoggedBack())
	Tools::redirectLink('login.php'.$url_redirect);

/* Current tab and current URL */
$tab = Tools::getValue('tab');
$currentIndex = __PS_BASE_URI__.substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__)).($tab ? '?tab='.$tab : '');
if ($back = Tools::getValue('back'))
	$currentIndex .= '&back='.urlencode($back);

/* Include appropriate language file */
if (isset($_GET['adminlang']))
{
	Tools::setCookieLanguage();
	if ($id_lang = Tools::getValue('id_lang'))
		$cookie->id_lang = $id_lang;
}
$iso = strtolower(Language::getIsoById((isset($cookie->id_lang)) ? $cookie->id_lang : 1));
@include(_PS_TRANSLATIONS_DIR_.$iso.'/errors.php');
@include(_PS_TRANSLATIONS_DIR_.$iso.'/fields.php');
@include(_PS_TRANSLATIONS_DIR_.$iso.'/admin.php');

/* Database connection (singleton) */
Db::getInstance();


switch (strtolower(Language::getIsoById(intval($cookie->id_lang))))
{
	case 'fr':
		$lheader = array(
		'Administration panel' => 'Panneau d\'administration', 
		'product, category...' => 'produit, categorie...', 
		'customer id, name, e-mail...' => 'id client, nom, e-mail...', 
		'order id' => 'id de la commande', 
		'in' => 'dans', 
		'catalog' => 'catalogue', 
		'customers' => 'clients', 
		'orders' => 'commandes',
		'Search' => 'Rechercher', 
		'home' => 'accueil',
		'user' => 'utilisateur', 
		'My Shop' => 'Ma Boutique', 
		'Home' => 'Accueil', 
		'logout' => 'D&eacute;connexion',
		'Quick access' => 'Acc&egrave;s rapide'
		);
	break;
	case 'en':
	default:
		$lheader = array(
		'Administration panel' => 'Back Office',
		'product, category...' => 'product, category...', 
		'customer id, name, e-mail...' => 'customer id, name, e-mail...', 
		'order id' => 'order id',
		'in' => 'in', 
		'catalog' => 'catalog', 
		'customers' => 'customers', 
		'orders' => 'orders',
		'Search' => 'Search', 
		'home' => 'home',
		'user' => 'user', 
		'My Shop' => 'My Shop', 
		'Home' => 'Home', 
		'logout' => 'logout',
		'Quick access' => 'Quick access'
		);
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<link type="text/css" rel="stylesheet" href="../css/admin.css" />
		<title>PrestaShop&trade; - <?php echo $lheader['Administration panel'] ?></title>
		<script language="javascript">
			var search_texts = Array('<?php echo addslashes($lheader['product, category...']); ?>', '<?php echo addslashes($lheader['customer id, name, e-mail...']); ?>', '<?php echo addslashes($lheader['order id']); ?>');
			var helpboxes = <?php echo Configuration::get('PS_HELPBOX'); ?>;
		</script>
		<script type="text/javascript" src="../js/admin.js"></script>
		<script type="text/javascript" src="../js/toggle.js"></script>
		<script type="text/javascript" src="../js/tools.js"></script>
		<script type="text/javascript" src="../js/ajax.js"></script>
	</head>
	<body>
		<div id="container">
			<div style="float: left; margin-top: 11px;">
				<form action="search.php" method="post">
					<input type="text" name="bo_query" id="bo_query" style="width: 120px;" onfocus="this.value = '';"  onclick="this.value = '';" 
					value="<?php echo (isset($_POST['bo_query']) ? stripslashes($_POST['bo_query']) : ''); ?>" /> <?php $lheader['in'] ?>
					<select name="bo_search_type" id="bo_search_type" onchange="queryType();" style="font-size: 1em;">
						<option value="1"<?php echo (isset($_POST['bo_search_type']) AND 
						($_POST['bo_search_type'] == 1)) ? ' selected="selected"' : '' ?>><?php echo $lheader['catalog'] ?></option>
						<option value="2"<?php echo (isset($_POST['bo_search_type']) AND 
						($_POST['bo_search_type'] == 2)) ? ' selected="selected"' : '' ?>><?php echo $lheader['customers'] ?></option>
						<option value="3"<?php echo (isset($_POST['bo_search_type']) AND (
						$_POST['bo_search_type'] == 3)) ? ' selected="selected"' : '' ?>><?php echo $lheader['orders'] ?></option>	
					</select>&nbsp;
					<input type="submit" name="bo_search" value="<?php echo $lheader['Search'] ?>" class="button" />
					<script language="javascript">queryType();</script>
				</form>
			</div>
			<ul id="nav" style="float: right;">
				<li>
					<?php
					$link = new Link();
					$languages = Language::getLanguages();
					if (sizeof($languages) != 1)
						foreach ($languages AS $language)
							echo '<a href="'.$link->getLanguageLink($language['id_lang'], $language['name']).'&adminlang=1"><img src="'._PS_IMG_.'l/'.$language['id_lang'].'.jpg" alt="'.strtoupper($language['iso_code']).'" title="'.$language['name'].'" '.($language['id_lang'] == $cookie->id_lang ? 'class="selected_language"' : '').' /></a> ';
					?>
				</li>
				<li>
					<?php echo $lheader['Quick access'].' '; ?>
					<select onchange="if (this.value) document.location = this.value;" style="font-size: 1em;">
						<?php
							global $cookie;
							$quicks = QuickAccess::getQuickAccesses(intval($cookie->id_lang));
							echo '<option>--</option>';
							foreach ($quicks AS $quick)
								echo '<option value="'.$quick['link'].'">'.$quick['name'].'</option>';
						?>
					</select>
				</li>
				<li><img src="../img/admin/nav-user.gif" alt="<?php echo $lheader['user'] ?>" />&nbsp;
				<a href="index.php?logout" title="<?php echo $lheader['logout'] ?>">
					<?php echo substr($cookie->surname, 0, 1).'.&nbsp;'.htmlentities(strtoupper(utf8_decode($cookie->name))); ?>
					<img src="../img/admin/nav-logout.gif" alt="<?php echo $lheader['logout'] ?>" />
				</a></li>
			</ul>
			<ul id="menu">
				<?php
					global $cookie;
					
					/* Get current tab informations */
					$id_parent_tab_current = intval(Tab::getCurrentParentId());

					$tabs = Tab::getTabs($cookie->id_lang, 0);
					foreach ($tabs AS $t)
					{
						if ($t['class_name'] == $tab)
						{
							$id_parent = $t['id_tab'];
							$tabName = stripslashes($t['name']);
						}

						echo '
						<li'.((($t['class_name'] == $tab) OR ($id_parent_tab_current == $t['id_tab'])) ? ' class="active"' : '').'>
							<a href="index.php?tab='.$t['class_name'].'"><img src="../img/t/'.$t['id_tab'].'.gif" alt="" title="" />'.stripslashes($t['name']).'</a>
						</li>';
					}

				?>
			</ul>
			<div id="main">
				<ul id="submenu">
				<?php
					global $cookie;
					
					/* Display tabs belonging to opened tab */
					$id_parent = isset($id_parent) ? $id_parent : $id_parent_tab_current;
					if (isset($id_parent) AND $id_parent != -1)
					{
					 	$subTabs = Tab::getTabs($cookie->id_lang, intval($id_parent));
						foreach ($subTabs AS $t)
						{
						 	if ($t['class_name'] == $tab)
								$tabName = stripslashes($t['name']);
						
							echo '
							<li>
								<img src="../img/t/'.$t['id_tab'].'.gif" alt="" title="" /> 
								<a href="index.php?tab='.$t['class_name'].'">'.stripslashes($t['name']).'</a>
							</li>';
						}
					}

				?>
				</ul>
				<div id="content">