<?php

/**
  * Homepage and main page for admin panel, index.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include(dirname(__FILE__).'/../config/config.inc.php');
include(dirname(__FILE__).'/functions.php');
include(dirname(__FILE__).'/toolbar.php');
include(dirname(__FILE__).'/header.inc.php');
global $tabName;

function lindex($string)
{
	global $lindex;
	return (is_array($lindex) AND key_exists($string, $lindex)) ? $lindex[$string] : $string;
}

switch (strtolower(Language::getIsoById(intval($cookie->id_lang))))
{
	case 'fr':
		$lindex = array(
		'Welcome to your admin panel !' => 'Bienvenue sur votre panneau d\'administration !',
		'More graphics and news are coming soon on this page ;-)' => 'D\'avantages de graphiques et d\'informations sont pr&eacute;vus pour cette page ;-)',
		'Your shop' => 'Votre boutique',
		'Total categories' => 'Nombre de cat&eacute;gories',
		'Total products' => 'Nombre de produits',
		'Total customers' => 'Nombre de clients',
		'Total orders' => 'Nombre de commandes',
		'PrestaShop live !' => 'PrestaShop en direct !',
		'RSS stream inaccessible' => 'RSS stream inaccessible',
		'http://www.php.net/manual/en/ref.filesystem.php' => 'http://fr.php.net/manual/fr/ref.filesystem.php',
		'more infos' => 'plus d\'infos',
		'To read the PrestaShop news, you need to activate the <b>allow_url_fopen</b> directive in your <b>php.ini</b> conf file.' => 'Pour lire l\'actualit&eacute; de PrestaShop, vous devez activer la directive <b>allow_url_fopen</b> dans votre fichier de conf <b>php.ini</b>.',
		'If you don\'t know how to do that, please contact your host administrator !' => 'Si vous ne savez pas comment proc&eacute;der, merci de contacter l\'administrateur de votre h&eacute;bergeur !',
		'Administration panel' => 'Panneau d\'administration',
		);
	break;
	case 'en':
	default:
		$lindex = array(
		'Welcome to your admin panel !' => 'Welcome to your Back Office !',
	);
}

if ($tab)
{
	if ($id_tab = checkingTab($tab))
	{
		$tabs = array();
		recursiveTab($id_tab);
		$tabs = array_reverse($tabs);
		echo '<div class="path_bar"><img src="../img/admin/prefs.gif" style="margin-right:10px" /><a href="?">'.lindex('Back Office').'</a>';
		foreach ($tabs AS $key => $item)
			echo ' >> <img src="../img/t/'.$item['id_tab'].'.gif" style="margin-right:5px">'.((sizeof($tabs) - 1 > $key) ? '<a href="?tab='.$item['class_name'].'">' : '').$item['name'].((sizeof($tabs) - 1 > $key) ? '</a>' : '');
		echo '</div>';
		$adminObj->displayConf();
		$adminObj->postProcess();
		$adminObj->displayErrors();
		$adminObj->display();
	}
}
else /* Else display homepage */
{ 	
	echo '
	<img src="../img/logo.jpg" alt="Logo" title="Logo" /><br /><br />
	<h2>'.lindex('Welcome to your admin panel !').'</h2>
	'.lindex('More graphics and news are coming soon on this page ;-)').'
	<br /><br /><br />
	
	<fieldset style="width: 200px;">
		<legend><img src="../img/admin/tab-stats.gif" alt="Your shop" title="" /> '.lindex('Your shop').'</legend>
		<p>'.lindex('Total categories').': <b>'.intval(Tools::getCategoriesTotal()).'</b></p>
		<p>'.lindex('Total products').': <b>'.intval(Tools::getProductsTotal()).'</b></p>
		<p>'.lindex('Total customers').': <b>'.intval(Tools::getCustomersTotal()).'</b></p>
		<p>'.lindex('Total orders').': <b>'.intval(Tools::getOrdersTotal()).'</b></p>
	</fieldset>

	<br /><br />';

	/* News from PrestaShop website */
	echo '<h2>'.lindex('PrestaShop live !').'</h2>';
	$isoDefault = Language::getIsoById(intval(Configuration::get('PS_LANG_DEFAULT')));
	$isoUser = Language::getIsoById(intval($cookie->id_lang));
	$fd = @fopen('http://www.prestashop.com/rss/news.xml?v='._PS_VERSION_.'&lang='.$iso, 'r');
	if ($fd)
	{
		$flow = stream_get_contents($fd);
		if (isset($flow))
		{
			$rss = simplexml_load_string($flow); 
			$flag = 0;
			echo '
			<div id="news" class="margin">';
			foreach($rss->channel AS $channel)
				if($channel->language == $isoUser AND ++$flag)
					foreach($channel->item as $news)
						echo '<h3 class="title row"><p class="infos">'.$news->pubDate.'</p>'.$news->title.'</h3>
							  <div class="content">'.$news->description.'</div>';
			if (!$flag)
				foreach($rss->channel->item as $news)
					echo '<h3 class="title row"><p class="infos">'.$news->pubDate.'</p>'.$news->title.'</h3>
						  <div class="content">'.$news->description.'</div>';
			echo '</div>';
		}
	}
	else {
		echo '<p>'.lindex('RSS stream inaccessible').'</p>';
		echo '<p>&nbsp;</p>';
		echo '<p>'.lindex('To read the PrestaShop news, you need to activate the <b>allow_url_fopen</b> directive in your <b>php.ini</b> conf file.').' [<a href="'.lindex('http://www.php.net/manual/en/ref.filesystem.php').'">'.lindex('more infos').'</a>]</p>';
		echo '<p>'.lindex('If you don\'t know how to do that, please contact your host administrator !').'</p>';
	}
}

include(dirname(__FILE__).'/footer.inc.php');

?>