<?php

/**
  * Login for admin panel, login.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include(dirname(__FILE__).'/../config/config.inc.php');
include(dirname(__FILE__).'/functions.php');

$errors = array();

$cookie = new Cookie('psAdmin', substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__), -10));

switch (strtolower(Tools::setCookieLanguage()))
{
	case 'fr':
		$l = array(
		'Administration panel' => 'Panneau d\'administration',
		'For security reasons, you cannot connect to the Back Office until after you have:' => 'Pour des raisons de sécurité, vous ne pouvez pas vous identifier dans l\'interface d\'administration tant que vous n\'avez pas :',
		'deleted the /install folder' => 'supprimé le dossier /install',
		'renamed the /admin folder (eg. /admin784)' => 'renommé le dossier /admin (ex : /admin784)',
		'Please then access this page by the new url (eg. http://www.domain.tld/admin784)' => 'Merci d\'accéder à cette page par la nouvelle adresse (ex: http://www.domain.tld/admin784)',
		'There are' => 'Il y a', 
		'There is' => 'Il y a',
		'errors' => 'erreurs', 
		'error' => 'erreur', 
		'e-mail address:' => 'Adresse e-mail :',
		'Password:' => 'Mot de passe : ', 
		'Connection' => 'Connexion',
		'Lost password?' => 'Mot de passe oubli&eacute; ?'
		);
	break;
	case 'en':
	default:
		$l = array(
		'Administration panel' => 'Back Office',
		'For security reasons, you cannot connect to the Back Office until after you have:' => 'For security reasons, you cannot connect to the Back Office until after you have:',
		'deleted the /install folder' => 'deleted the /install folder',
		'renamed the /admin folder (eg. /admin784)' => 'renamed the /admin folder (eg. /admin784)',
		'Please then access this page by the new url (eg. http://www.domain.tld/admin784)' => 'Please then access this page by the new url (eg. http://www.domain.tld/admin784)',
		'There are' => 'There are', 
		'There is' => 'There is',
		'errors' => 'errors',
		'error'	=> 'error', 
		'e-mail address:' => 'e-mail address:',
		'Password:' => 'Password:', 
		'Connection' => 'Connection', 
		'Lost password?' => 'Lost password?'
		);
}


/* These errors are fatal */
if (sizeof($errors))
	die(displayErrors($errors));

/* Cookie creation and redirection */
if (Tools::isSubmit('Submit'))
{
 	/* Check fields validity */
	$passwd = trim(Tools::getValue('passwd'));
	$email = trim(Tools::getValue('email'));
	if (empty($email))
		$errors[] = Tools::displayError('e-mail is empty');
	elseif (!Validate::isemail($email))
		$errors[] = Tools::displayError('invalid e-mail address');
	elseif (empty($passwd))
		$errors[] = Tools::displayError('password is blank');
	elseif (!Validate::isPasswd($passwd))
		$errors[] = Tools::displayError('invalid password');
	else
	{
	 	/* Seeking for employee */
		$employee = new Employee();
		$employee = $employee->getByemail($email, $passwd);
		if (!$employee)
		{
			$errors[] = Tools::displayError('employee does not exist, or bad password');
			$cookie->logout();
		}
		else
		{
		 	/* Creating cookie */
			$cookie->id_employee = $employee->id;
			$cookie->name = $employee->name;
			$cookie->surname = $employee->surname;
			$cookie->email = $employee->email;
			$cookie->profile = $employee->id_profile;
			$cookie->passwd = $employee->passwd;
			$cookie->write();
			/* Redirect to admin panel */
			if (isset($_GET['redirect']))
				$url = strval ($_GET['redirect']);
			else
				$url = dirname ($_SERVER['PHP_SELF']).'/index.php';
			Tools::redirect($url, '');
		}
	}
}

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<link type="text/css" rel="stylesheet" href="../css/login.css" />
		<title>PrestaShop&trade; - '.$l['Administration panel'].'</title>
	</head>
	<body>
		<div id="container">';

if ($nbErrors = sizeof($errors))
{
	echo '
	<div id="error">
		<h3>'.($nbErrors > 1 ? $l['There are'] : $l['There is']).' '.$nbErrors.' '.($nbErrors > 1 ? $l['errors'] : $l['error']).'</h3>
		<ol style="margin: 0 0 0 20px;">';
		foreach ($errors AS $error)
			echo '<li>'.$error.'</li>';
		echo '
		</ol>
	</div>
	<br />';
}

echo '
			<div id="login">
				<form action="'.$_SERVER['REQUEST_URI'].'" method="post">';

if(file_exists(dirname(__FILE__).'/../install') || file_exists(dirname(__FILE__).'/../admin'))
{
	echo '				<span>'.$l['For security reasons, you cannot connect to the Back Office until after you have:'].'<br /><br />
		- '.$l['deleted the /install folder'].'<br />
		- '.$l['renamed the /admin folder (eg. /admin784)'].'<br />
		<br />'.$l['Please then access this page by the new url (eg. http://www.domain.tld/admin784)'].'</span>';
}
else
{
	echo '			<label>'.$l['e-mail address:'].'</label><br />
					<input type="text" id="email" name="email" value="'.Tools::safeOutput(Tools::getValue('email')).'" class="input" />
					<div style="margin: 0.5em 0 0 0;">
						<label>'.$l['Password:'].'</label><br />
						<input type="password" name="passwd" class="input" />
					</div>
					<div>
						<div id="submit"><input type="submit" name="Submit" value="'.$l['Connection'].'" class="button" /></div>
						<div id="lost"><a href="password.php">'.$l['Lost password?'].'</a></div>
					</div>
	';
}
?>
<script type="text/javascript">
<!--
if (document.getElementById('email')) document.getElementById('email').focus();
-->
</script>
<?php
echo '
				</form>
			</div>
		</div>
	</body>
</html>';

?>