<?php

/**
  * PDF generation for admin, pdf.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include(dirname(__FILE__).'/../config/config.inc.php');

/* Header can't be included, so cookie must be created here */
$cookie = new Cookie('psAdmin');
if (!isset($cookie->id_employee))
	Tools::redirect('login.php');

if (isset($_GET['pdf']))
{
	if (!isset($_GET['id_order']))
		die (Tools::displayError('order id is missing'));
	$order = new Order(intval($_GET['id_order']));
	if (!Validate::isLoadedObject($order))
		die(Tools::displayError('cannot find order in database'));
	PDF::invoice($order);
}

?>