<?php

/**
  * Search functionnalities for admin, search.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include(dirname(__FILE__).'/../config/config.inc.php');
include(dirname(__FILE__).'/functions.php');
include(dirname(__FILE__).'/header.inc.php');
$errors = array();

function lsearch($string)
{
	global $lsearch;
	return (is_array($lsearch) AND key_exists($string, $lsearch)) ? $lsearch[$string] : $string;
}

switch (strtolower(Language::getIsoById(intval($cookie->id_lang))))
{
	case 'fr':
		$lsearch = array(
		'There are' => 'Il y a', 
		'There is' => 'Il y a',
		'errors' => 'erreurs', 
		'error' => 'erreur',
		'categories found with' => 'cat&eacute;gories trouv&eacute;es avec', 
		'category found with' => 'cat&eacute;gorie trouv&eacute;e avec', 
		'products found with' => 'produits trouv&eacute;s avec', 
		'product found with' => 'produit trouv&eacute; avec', 
		'id' => 'id', 
		'Manufacturer' => 'Fabriquant', 
		'Name' => 'Nom', 
		'Price' => 'Prix', 
		'Tax' => 'Taxe', 
		'Reference' => 'Référence', 
		'Stock' => 'Stock',
		'Weight' => 'Poids', 
		'Status' => 'Statut', 
		'Actions' => 'Actions', 
		'Modify this product' => 'Modifier ce produit', 
		'Delete this product' => 'Supprimer ce produit', 
		'Do you want to delete' => 'Souhaitez-vous supprimer', 
		'No categories or products found' => 'Aucune cat&eacute;gorie ou produit trouv&eacute;',
		'customers' => 'clients', 
		'customer' => 'client',
		'Sex' => 'Sexe', 
		'email' => 'email', 
		'Birth date' => 'Date de naissance', 
		'Register date' => 'Date d\'inscription',
		'Addresses' => 'Adresses',
		'Orders' => 'Commandes',
		'Newsletter' => 'Newsletter',
		'Opt-in' => 'Opt-in',
		'Male' => 'Homme',
		'Female' => 'Femme',
		'Write to this customer' => '&Eacute;crire &agrave; ce client', 
		'View oders' => 'Voir les commandes',
		'Modify this customer' => 'Modifier les informations de ce client', 
		'Delete this customer' => 'Supprimer ce client', 
		'Are you sure?' => '&Ecirc;tes-vous s&ucirc;r ?',  
		'No customer found' =>  'Aucun client trouv&eacute;',
		'Search results' => 'R&eacute;sultats pour',
		
		);
	break;
}

function displayErrors($errors)
{
	global $lsearch; 
	
	if ($nbErrors = sizeof($errors))
	{
		echo '
		<div class="alert error">
			<h3>'.($nbErrors > 1 ? lsearch('There are') : lsearch('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? lsearch('errors') : lsearch('error')).'</h3>
			<ol>';
			foreach ($errors AS $error)
				echo '<li>'.$error.'</li>';
			echo '
			</ol>
		</div>
		<br />';
	}
}


/* Handle empty search field */
if (!isset($_POST['bo_query']) OR empty($_POST['bo_query']) OR !isset($_POST['bo_search_type']))
{
	echo '<h2>'.lsearch('Search results').'</h2>';
	$errors[] = Tools::displayError('please fill search form first');
}
else
{
	echo '<h2>'.lsearch('Search results for').' "'.$_POST['bo_query'].'"</h2>';
	/* Search only in the selected type of data */
	switch ($_POST['bo_search_type'])
	{
		case 1:
			searchCatalog(trim(strval($_POST['bo_query'])));
			break;
			
		case 2:
			/* Handle customer ID */
			if (ereg('^([0-9])*$', $_POST['bo_query']))
			{
				$customer = new Customer(intval($_POST['bo_query']));
				if ($customer->id)
					Tools::redirect(basename(dirname(__FILE__)).'/index.php?tab=AdminCustomers&id_customer='.intval($_POST['bo_query']).'&viewcustomer');
				else
					$errors[] = Tools::displayError('customer #').intval($_POST['bo_query']).' '.Tools::displayError('not found');
			}
			/* Search customers by name */
			else
				searchCustomer($_POST['bo_query']);
			break;
			
		case 3:
			/* Handle order ID */
			if (ereg('^([0-9])*$', $_POST['bo_query']))
			{
				$order = new Order(intval($_POST['bo_query']));
				if ($order->id)
					Tools::redirect(basename(dirname(__FILE__)).'/index.php?tab=AdminOrders&id_order='.intval($_POST['bo_query']).'&vieworder');
				else
					$errors[] = Tools::displayError('order #').intval($_POST['bo_query']).' '.Tools::displayError('not found');
			}
			else
				$errors[] = Tools::displayError('please type an order id');
			break;
			
		default:
			displayErrors(array('Please fill search form first.'));
	}
}

if (sizeof($errors))
	displayErrors($errors);

/**
  * Search a specific string in the products and categories
  *
  * @params string $query String to find in the catalog
  */
function searchCatalog($query)
{
	global $lsearch, $cookie;

	$currentIndex = 'index.php';
	$products = false;
	$currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
	if (Validate::isCatalogName($query))
		$products = Product::searchByName(intval($cookie->id_lang), $query);
	if (Validate::isCatalogName($query))
		$categories = Category::searchByName(intval($cookie->id_lang), $query);
	
	/* Display categories if any has been matching */
	if (isset($categories) AND $nbCategories = sizeof($categories))
	{
		echo '<h3>'.$nbCategories.' '.($nbCategories > 1 ? lsearch('categories found with') : lsearch('category found with')).' <b>"'.$query.'"</b></h3>';
		echo '
		<table cellspacing="0" cellpadding="0" class="table">';
		$irow = 0;
		foreach ($categories AS $k => $category)
			echo '<tr class="'.($irow++ % 2 ? 'alt_row' : '').'"><td>'.rtrim(getPath($currentIndex.'?tab=AdminCatalog', $category['id_category'], '', $query), ' >').'</td></tr>';
		echo '</table><br /><br />';
	}
	else
		$nbCategories = 0;
	
	/* Display products if any has been matching */
	if (isset($products) AND $products AND $nbProducts = sizeof($products))
	{
		echo '<h3>'.$nbProducts.' '.($nbProducts > 1 ? lsearch('products found with') : lsearch('product found with')).' <b>"'.$query.'"</b></h3>
		<table class="table" cellpadding="0" cellspacing="0">
			<tr>
				<th>'.lsearch('id').'</th>
				<th>'.lsearch('Manufacturer').'</th>
				<th>'.lsearch('Reference').'</th>
				<th>'.lsearch('Name').'</th>
				<th>'.lsearch('Price').'</th>
				<th>'.lsearch('Tax').'</th>
				'.(Configuration::get('PS_STOCK_MANAGEMENT') ? '<th>'.lsearch('Stock').'</th>' : '').'
				<th>'.lsearch('Weight').'</th>
				<th>'.lsearch('Status').'</th>
				<th>'.lsearch('Actions').'</th>
			</tr>';
		foreach ($products AS $k => $product)
		{				
			echo '
			<tr>
				<td>'.$product['id_product'].'</td>
				<td align="center">'.($product['manufacturer_name'] != NULL ? stripslashes($product['manufacturer_name']) : '--').'</td>
				<td>'.$product['reference'].'</td>
				<td><a href="'.$currentIndex.'?tab=AdminCatalog&id_product='.$product['id_product'].'&addproduct">'.stripslashes($product['nameh']).'</a></td>
				<td>'.Tools::displayPrice($product['price'], $currency).'</td>
				<td>'.stripslashes($product['tax_name']).'</td>
				'.(Configuration::get('PS_STOCK_MANAGEMENT') ? '<td align="center">'.$product['quantity'].'</td>' : '').'
				<td align="center">'.$product['weight'].' kg</td>
				<td align="center"><a href="'.$currentIndex.'?tab=AdminCatalog&id_product='.$product['id_product'].'&status">
				<img src="../img/admin/'.($product['active'] ? 'enabled.gif' : 'forbbiden.gif').'" alt="" /></a></td>
				<td>
					<a href="'.$currentIndex.'?tab=AdminCatalog&id_product='.$product['id_product'].'&addproduct">
					<img src="../img/admin/edit.gif" alt="'.lsearch('Modify this product').'" /></a>&nbsp;
					<a href="'.$currentIndex.'?tab=AdminCatalog&id_product='.$product['id_product'].'&deleteproduct" onclick="return confirm(\''.lsearch('Do you want to delete').' '.$product['name'].' ?\');">
					<img src="../img/admin/delete.gif" alt="'.lsearch('Delete this product').'" /></a>
				</td>
			</tr>';
		}
		echo '</table>';
	}
	else
		$nbProducts = 0;
	
	/* Display error if nothing has been matching */
	if (!$nbCategories AND !$nbProducts)
		echo '<h3>'.lsearch('No categories or products found').'.</h3>';
}

/**
  * Search a specific name in the customers
  *
  * @params string $query String to find in the catalog
  */
function	searchCustomer($query)
{
	global $lsearch;

	$currentIndex = 'index.php';
	$customers = Customer::searchByName($query);
	
	/* Display customers if any has been matching */
	if ($nbCustomers = sizeof($customers))
	{
		echo '<h3>'.$nbCustomers.' '.($nbCustomers > 1 ? lsearch('customers') : lsearch('customer')).' '.lsearch('found with').' <b>"'.$query.'"</b></h3>
		<table cellspacing="0" cellpadding="0" class="table widthfull">
			<tr>
				<th>'.lsearch('id').'</th>
				<th>'.lsearch('Sex').'</th>
				<th>'.lsearch('Name').'</th>
				<th>'.lsearch('email').'</th>
				<th>'.lsearch('Birth date').'</th>
				<th>'.lsearch('Register date').'</th>
				<th>'.lsearch('Addresses').'</th>
				<th>'.lsearch('Orders').'</th>
				<th>'.lsearch('Newsletter').'</th>
				<th>'.lsearch('Opt-in').'</th>
				<th>'.lsearch('Status').'</th>
				<th class="center">'.lsearch('Actions').'</th>
			</tr>';
		$irow = 0;
		foreach ($customers AS $k => $customer)
		{
			switch ($customer['iso_code'])
			{
				case 1:
					$imgGender = '<img src="../img/admin/male.gif" alt="'.lsearch('Male').'" />';
					break;
				case 2:
					$imgGender = '<img src="../img/admin/female.gif" alt="'.lsearch('Female').'" />';
					break;
				default:
					$imgGender = '';
			}
			$customerAddressTotal = Customer::getAddressesTotalById($customer['id_customer']);
			echo '
			<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
				<td>'.$customer['id_customer'].'</td>
				<td class="center">'.$imgGender.'</td>
				<td>'.stripslashes($customer['name']).' '.stripslashes($customer['surname']).'</td>
				<td><a href="mailto:'.stripslashes($customer['email']).'">
				<img src="../img/admin/email_edit.gif" alt="'.lsearch('Write to this customer').'" /></a> 
				'.stripslashes($customer['email']).'</td>
				<td>'.displayDate($customer['birthday']).'</td>
				<td>'.displayDate($customer['date_add']).'</td>
				<td class="center"><a href="'.$currentIndex.'?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&addresses">
				<img src="../img/admin/employee.gif" alt="'.lsearch('Addresses').'" /></a> 
				'.$customerAddressTotal.'</td>
				<td>'.Order::getCustomerNbOrders($customer['id_customer']).'</td>
				<td class="center"><img src="../img/admin/'.($customer['newsletter'] ? 'enabled.gif' : 'delete.gif').'" alt="" /></td>
				<td class="center"><img src="../img/admin/'.($customer['optin'] ? 'enabled.gif' : 'delete.gif').'" alt="" /></td>
				<td class="center"><img src="../img/admin/'.($customer['active'] ? 'enabled.gif' : 'forbbiden.gif').'" alt="" /></td>
				<td class="center" width="60px">
					<a href="'.$currentIndex.'?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&viewcustomer">
					<img src="../img/admin/details.gif" alt="'.lsearch('View orders').'" /></a>
					<a href="'.$currentIndex.'?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&addcustomer">
					<img src="../img/admin/edit.gif" alt="'.lsearch('Modify this customer').'" /></a>
					<a href="'.$currentIndex.'?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&deletecustomer" onclick="return confirm(\''.lsearch('Are you sure?').'\');">
					<img src="../img/admin/delete.gif" alt="'.lsearch('Delete this customer').'" /></a>
				</td>
			</tr>';
		}
		echo '</table>';
	}
	/* Display error if nothing has been matching */
	else
		echo '<h3>'.lsearch('No customer found').'.</h3>';
}

include(dirname(__FILE__).'/footer.inc.php');

?>