<?php

/**
  * Access management tab for admin panel, AdminAccess.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */
  
include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminAccess extends AdminTab
{
	public function display()
	{
		if (empty($_POST))
			$this->displayForm();
		else
		{
			$access = new Access();
			$access->updateProfileAccess($_POST['id_profile'], $_POST['id_tab'], $_POST['action'], $_POST['status']);
		}
	}
	
	/**
	* Get the current profile id
	*
	* @return the $_GET['profile'] if valid, else 1 (the first profile id)
	*/
	function getCurrentProfileId()
	{
	 	return (isset($_GET['profile']) AND !empty($_GET['profile']) AND is_numeric($_GET['profile'])) ? intval($_GET['profile']) : 1;
	}
	
	function displayForm()
	{
		global $cookie, $currentIndex;
	 	
	 	$currentProfile = $this->getCurrentProfileId();
	 	$access = new Access();
	 	$tabs = Tab::getTabs($cookie->id_lang);
		$profiles = Profile::getProfiles(intval($cookie->id_lang));
		$accesses = $access->getProfileAccesses(intval($currentProfile));

		echo '
		<script language="javascript">
			setLang(Array(\''.$this->l('Profile updated').'\', \''.$this->l('Request failed!').'\', \''.$this->l('Updating in progress. Please wait.').'\', \''.$this->l('Server connection failed!').'\'));
		</script>
		<h2>'.$this->l('Permissions').'</h2>
		<div id="ajax_confirmation"></div>
		<table class="table" cellspacing="0">
			<tr>
				<th>
					<select name="profile" onchange="redirect(\'http://'.$_SERVER['HTTP_HOST'].$currentIndex.'&profile=\'+this.options[this.selectedIndex].value)">';
		if ($profiles)
			foreach ($profiles AS $profile)
				echo '<option value="'.$profile['id_profile'].'" '.($profile['id_profile'] == $currentProfile ? 'selected="selected"' : '').'>'.$profile['name'].'</option>';
		echo '
					</select>
				</th>
				<th>'.$this->l('View').'</th>
				<th>'.$this->l('Add').'</th>
				<th>'.$this->l('Edit').'</th>
				<th>'.$this->l('Delete').'</th>
			</tr>';
			
		if (!sizeof($tabs))
			echo '<tr><td colspan="5">'.$this->l('No tab').'</td></tr>';
		else
			foreach ($tabs AS $tab)
				if (!$tab['id_parent'])
				{
					$this->printTabAccess(intval($currentProfile), $tab, $accesses[$tab['id_tab']], false);
					foreach ($tabs AS $child)
						if ($child['id_parent'] === $tab['id_tab'])
					 		$this->printTabAccess($currentProfile, $child, $accesses[$child['id_tab']], true);
				}

		echo '</table>';
	}
	
	private function printTabAccess($currentProfile, $tab, $access, $is_child)
	{
		echo '
		<tr>
		 <td'.($is_child ? '' : ' class="bold"').'>'.($is_child ? ' &raquo; ' : '').$tab['name'].'</td>
		 <td class="center"><input type="checkbox" name="1" onchange="ajax_power(this, \'view\', \''.intval($currentProfile).'\', '.intval($tab['id_tab']).')" '.($access['view'] === '1' ? 'checked="checked"' : '').'/></td>
		 <td class="center"><input type="checkbox" name="1" onchange="ajax_power(this, \'add\', \''.intval($currentProfile).'\', '.intval($tab['id_tab']).')" '.($access['add'] === '1' ? 'checked="checked"' : '').'/></td>
		 <td class="center"><input type="checkbox" name="1" onchange="ajax_power(this, \'edit\', \''.intval($currentProfile).'\', '.intval($tab['id_tab']).')" '.($access['edit'] === '1' ? 'checked="checked"' : '').'/></td>
		 <td class="center"><input type="checkbox" name="1" onchange="ajax_power(this, \'delete\', \''.intval($currentProfile).'\', '.intval($tab['id_tab']).')" '.($access['delete'] === '1' ? 'checked="checked"' : '').'/></td>
		</tr>';
	 
	}
}

?>