<?php

class AdminAliases extends AdminTab
{
	function __construct()
	{
	 	$this->table = 'alias';
	 	$this->className = 'Alias';
	 	$this->edit = true;
		
		$this->fieldsDisplay = array(
		'alias' => array('title' => $this->l('Aliases'), 'width' => 160),
		'search' => array('title' => $this->l('Search'), 'width' => 40),
		'active' => array('title' => $this->l('Status'), 'align' => 'center', 'active' => 'status', 'type' => 'bool', 'orderby' => false)
		);
		parent::__construct();
	}

	public function postProcess()
	{
		if (isset($_POST['submitAdd'.$this->table]))
		{
			Alias::addAliases(strval($_POST['alias']), strval($_POST['search']));
		}
		else
			parent::postProcess();
	}

	public function displayForm()
	{
		global $currentIndex;
		
		$obj = $this->loadObject(true);

		echo '
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" class="width2">
		'.($obj->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$obj->id.'" />' : '').'
			<fieldset><legend><img src="../img/admin/search.gif" />'.$this->l('Aliases').'</legend>
				<label>'.$this->l('Alias:').' </label>
				<div class="margin-form">
					<input type="text" size="40" name="alias" value="'.$obj->getAliases().'" /> <sup>*</sup>
					<p style="clear: both;">'.$this->l('Enter each alias separated by a ,').'<br />
					'.$this->l('Forbidden characters:').' <>;=#{}</p>
				</div>
				<label>'.$this->l('Result:').' </label>
				<div class="margin-form">
					<input type="text" size="15" name="search" value="'.$this->getFieldValue($obj, 'search').'" /> <sup>*</sup>
					<p style="clear: both;">'.$this->l('Search this word instead.').'</p>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Required fields').'</div>
			</fieldset>
		</form>';
	}
}

?>