<?php

/**
  * Carriers tab for admin panel, AdminCarriers.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminCarriers extends AdminTab
{
	protected $maxImageSize = 30000;

	public function __construct()
	{
		global $cookie;
		
	 	$this->table = 'carrier';
	 	$this->className = 'Carrier';
	 	$this->lang = true;
	 	$this->edit = true;
	 	$this->deleted = true;
 		$this->fieldImageSettings = array('name' => 'logo', 'dir' => 's');
 				
		$this->fieldsDisplay = array(
		'id_carrier' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 25),
		'name' => array('title' => $this->l('Name'), 'width' => 100),
		'logo' => array('title' => $this->l('Logo'), 'align' => 'center', 'image' => 's', 'orderby' => false, 'search' => false),
		'delay' => array('title' => $this->l('Delay'), 'width' => 300, 'orderby' => false),
		'active' => array('title' => $this->l('Status'), 'align' => 'center', 'active' => 'status', 'type' => 'bool', 'orderby' => false));

		$this->optionTitle = $this->l('Carriers options');
		$this->_fieldsOptions = array(
			'PS_CARRIER_DEFAULT' => array('title' => $this->l('Default carrier:'), 'desc' => $this->l('The default carrier used in shop'), 'cast' => 'intval', 'type' => 'select', 'identifier' => 'id_carrier', 'list' => Carrier::getCarriers(intval($cookie->id_lang), true)),
		);
		
		parent::__construct();
	}

	public function displayForm()
	{
		global $currentIndex, $cookie;
		
		$obj = $this->loadObject(true);
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$currentLanguage = intval($cookie->id_lang);
		$languages = Language::getLanguages();

		echo '
		<script type="text/javascript">
			id_language = Number('.$defaultLanguage.');
		</script>
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" enctype="multipart/form-data">
		'.($obj->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$obj->id.'" />' : '').'
			<fieldset class="width3"><legend><img src="../img/admin/delivery.gif" />'.$this->l('Carriers').'</legend>
				<label>'.$this->l('Company:').' </label>
				<div class="margin-form">
					<input type="text" size="25" name="name" value="'.$this->getFieldValue($obj, 'name').'" /> <sup>*</sup>
					<span class="hint" name="help_box">'.$this->l('Allowed characters: letters, spaces and').' ().-<span class="hint-pointer">&nbsp;</span></span>
					<p class="clear">'.$this->l('Carrier name displayed during checkout').'<br />'.$this->l('With value 0, the carrier name will be replaced by the shop name').'</p>
				</div>
				<label>'.$this->l('Logo:').' </label>
				<div class="margin-form">
					<input type="file" name="logo" />
					<p>'.$this->l('Upload logo from your computer').' (.gif, .jpg, .jpeg or .png)</p>
				</div>
				<label>'.$this->l('Transit time:').' </label>
				<div class="margin-form">';
				foreach ($languages as $language)
					echo '
					<div id="delay_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" size="41" maxlength="128" name="delay_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'delay', intval($language['id_lang'])).'" /> <sup>*</sup>
					</div>';							
				displayFlags($languages, $defaultLanguage, 'delay', 'delay');
				echo '
					<p style="clear: both">'.$this->l('Time taken for product delivery; displayed during checkout').'</p>
				</div>
				<label>'.$this->l('URL:').' </label>
				<div class="margin-form">
					<input type="text" size="40" name="url" value="'.$this->getFieldValue($obj, 'url').'" />
					<p class="clear">'.$this->l('URL for the tracking number; type \'@\' where the tracking number will appear').'</p>
				</div>
				<label>'.$this->l('Tax:').'</label>
				<div class="margin-form">
					<select name="id_tax">
						<option value="0"'.(($obj->id && $obj->id_tax == 0) ? ' selected="selected"' : '').'>'.$this->l('No tax').'</option>';
						$tvaList = Tax::getTaxes($currentLanguage);
						foreach ($tvaList AS $line)
							echo '<option value="'.$line['id_tax'].'"'.(($obj->id && $obj->id_tax == $line['id_tax']) ? ' selected="selected"' : '').'>'.$line['name'].'</option>';
					echo '</select>
					<p>'.$this->l('Include tax on carrier eg: VAT').'</p>
				</div>
				<label>'.$this->l('Zone:').'</label>
				<div class="margin-form">';
					$carrier_zones = $obj->getZones();
					$zones = Zone::getZones(true);
					foreach ($zones AS $zone)
						echo '<input type="checkbox" id="zone_'.$zone['id_zone'].'" name="zone_'.$zone['id_zone'].'" value="true" '.((is_array($carrier_zones) AND in_array(array('id_carrier' => $obj->id, 'id_zone' => $zone['id_zone']), $carrier_zones)) ? ' checked="checked"' : '').'><label class="t" for="zone_'.$zone['id_zone'].'">&nbsp;<b>'.$zone['name'].'</b></label><br />';
				echo '<p>'.$this->l('In which zone this carrier is used').'</p>
				</div>
				<label>'.$this->l('Status:').' </label>
				<div class="margin-form">
					<input type="radio" name="active" id="active_on" value="1" '.($this->getFieldValue($obj, 'active') ? 'checked="checked" ' : '').'/>
					<label class="t" for="active_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="active" id="active_off" value="0" '.(!$this->getFieldValue($obj, 'active') ? 'checked="checked" ' : '').'/>
					<label class="t" for="active_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p>'.$this->l('Include or exclude carrier from list of carriers on Website').'</p>
				</div>
				<label>'.$this->l('Shipping Handling:').' </label>
				<div class="margin-form">
					<input type="radio" name="shipping_handling" id="shipping_handling_on" value="1" '.($this->getFieldValue($obj, 'shipping_handling') ? 'checked="checked" ' : '').'/>
					<label class="t" for="shipping_handling_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="shipping_handling" id="shipping_handling_off" value="0" '.(!$this->getFieldValue($obj, 'shipping_handling') ? 'checked="checked" ' : '').'/>
					<label class="t" for="shipping_handling_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p>'.$this->l('Include or not the shipping handling cost in carrier price').'</p>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Requireds fields').'</div>
			</fieldset>
		</form>';
	}
	
	public function beforeDelete($object)
	{
		return $object->isUsed();
	}
	
	public function afterDelete($object, $oldId)
	{
		$object->copyCarrierData(intval($oldId));
	}
	
public function postProcess()
	{
		global $currentIndex;
		
		if(Tools::getValue('submitAdd'.$this->table))
		{
		 	/* Checking fields validity */
			$this->validateRules();
			if (!sizeof($this->_errors))
			{
				$id = intval(Tools::getValue('id_'.$this->table));

				/* Object update */
				if (isset($id) AND !empty($id))
				{
					if ($this->tabAccess['edit'] === '1')
					{
						$object = new $this->className($id);
						if (Validate::isLoadedObject($object))
						{
							$object->deleted = 1;
							$object->update();
							$objectNew = new $this->className();
							$this->copyFromPost($objectNew, $this->table);
							$result = $objectNew->add();
							if (Validate::isLoadedObject($objectNew))
								$this->afterDelete($objectNew, $object->id);
							
							if (!$result)
								$this->_errors[] = Tools::displayError('an error occurred while updating object').' <b>'.$this->table.'</b>';
							elseif ($this->postImage($objectNew->id))
								{
									$this->changeZones($objectNew->id);
									Tools::redirectAdmin($currentIndex.'&id_'.$this->table.'='.$object->id.'&conf=4');
								}
						}
						else
							$this->_errors[] = Tools::displayError('an error occurred while updating object').' <b>'.$this->table.'</b> '.Tools::displayError('(cannot load object)');
					}
					else
						$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
				}
				
				/* Object creation */
				else
				{
					if ($this->tabAccess['add'] === '1')
					{
						$object = new $this->className();
						$this->copyFromPost($object, $this->table);
						if (!$object->add())
							$this->_errors[] = Tools::displayError('an error occurred while creating object').' <b>'.$this->table.'</b>';
						elseif (($_POST['id_'.$this->table] = $object->id /* voluntary */) AND $this->postImage($object->id) AND $this->_redirect)
						{
							$this->changeZones($object->id);
							Tools::redirectAdmin($currentIndex.'&id_'.$this->table.'='.$object->id.'&conf=3');
						}
					}
					else
						$this->_errors[] = Tools::displayError('You do not have permission to add something here.');
				}
			}
		}
		else
			parent::postProcess();
	}
	
	function changeZones($id)
	{
		$carrier = new $this->className($id);
		if (!Validate::isLoadedObject($carrier))
			die (Tools::displayError('object cannot be loaded'));
		$zones = Zone::getZones(true);
		foreach ($zones as $zone)
			if (count($carrier->getZone($zone['id_zone'])))
			{
				if (!isset($_POST['zone_'.$zone['id_zone']]) OR !$_POST['zone_'.$zone['id_zone']])
					$carrier->deleteZone($zone['id_zone']);
			}
			else
				if (isset($_POST['zone_'.$zone['id_zone']]) AND $_POST['zone_'.$zone['id_zone']])
					$carrier->addZone($zone['id_zone']);
	}
	
	public function displayListContent()
	{
		foreach ($this->_list as $key => $list)
			if ($list['name'] == '0')
				$this->_list[$key]['name'] = Configuration::get('PS_SHOP_NAME');
		parent::displayListContent();
	}
}

?>