<?php

/**
  * Catalog tab for admin panel, AdminCatalog.php
  * Tab has been separated in 3 files : this one, AdminCategories.php and AdminProducts.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');
include(dirname(__FILE__).'/AdminCategories.php');
include(dirname(__FILE__).'/AdminProducts.php');

class AdminCatalog extends AdminTab
{
	/** @var object AdminCategories() instance */
	private $adminCategories;
	
	/** @var object AdminProducts() instance */
	private $adminProducts;
	
	/** @var object Category() instance for navigation*/
	private static $_category = null;
	
	public function __construct()
	{
		/* Get current category */
		$id_category = abs(intval(Tools::getValue('id_category')));
		if (!$id_category) $id_category = 1;
		self::$_category = new Category($id_category);
		if (!Validate::isLoadedObject(self::$_category))
			die('Category cannot be loaded');
		
		$this->adminCategories = new AdminCategories();
		$this->adminProducts = new AdminProducts();
		
		parent::__construct();
	}
	
	/**
	 * Return current category
	 *
	 * @return object
	 */
	public static function getCurrentCategory()
	{
		return self::$_category;
	}
	
	public function viewAccess($disable = false)
	{
		$result = parent::viewAccess($disable);
		$this->adminCategories->tabAccess = $this->tabAccess;
		$this->adminProducts->tabAccess = $this->tabAccess;
		return $result;
	}
	
	public function postProcess()
	{
		if (!Tools::getValue('id_product'))
			$this->adminCategories->postProcess();
		$this->adminProducts->postProcess();
	}
	
	public function displayErrors()
	{
		$this->adminProducts->displayErrors();
		$this->adminCategories->displayErrors();
	}

	public function display()
	{
		global $currentIndex;
	
		if ((isset($_POST['submitAddcategory']) AND sizeof($this->adminCategories->_errors)) OR isset($_GET['updatecategory']) OR isset($_GET['addcategory']))
		{
			$this->adminCategories->displayForm();
			echo '<br /><br /><a href="'.$currentIndex.'"><img src="../img/admin/arrow.gif" /> '.$this->l('Back to list').'</a><br />';
		}
		elseif ((isset($_GET['submitAddproduct']) AND sizeof($this->adminProducts->_errors)) OR isset($_GET['updateproduct']) OR isset($_GET['addproduct']))
		{
			$this->adminProducts->displayForm();
			echo '<br /><br /><a href="'.$currentIndex.'"><img src="../img/admin/arrow.gif" /> '.$this->l('Back to list').'</a><br />';
		}
		elseif (!isset($_GET['editImage']))
		{
			$id_category = intval(Tools::getValue('id_category'));
			if (!$id_category)
				$id_category = 1;
			$currentIndex .= '&id_category='.$id_category;
			echo '<div class="cat_bar"><font color="#3C8534">'.$this->l('Current categorie').' :</font>&nbsp;&nbsp;&nbsp;'.getPath($currentIndex, $id_category).'</div>';
			echo '<h2>'.$this->l('Categories').'</h2>';
			$this->adminCategories->display();
			echo '<div style="margin:10px">&nbsp;</div>';
			echo '<h2>'.$this->l('Products in this category').'</h2>';
			$this->adminProducts->display();
		}
	}
}

?>