<?php

/**
  * Categories class for AdminCatalog tab, AdminCategories.php
  * This file is part of a group with 2 other files : AdminCatalog.php and AdminProducts.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminCategories extends AdminTab
{
	protected $maxImageSize = 300000;
	
	/** @var object Category() instance for navigation*/
	private $_category;

	public function __construct()
	{
		$this->table = 'category';
	 	$this->className = 'Category';
	 	$this->lang = true;
	 	$this->edit = true;
	 	$this->view = true;
		
 		$this->fieldImageSettings = array('name' => 'image', 'dir' => 'c');
		
		$this->fieldsDisplay = array(
		'id_category' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 30),
		'name' => array('title' => $this->l('Name'), 'width' => 100, 'callback' => 'hideCategoryPosition'),
		'description' => array('title' => $this->l('Description'), 'width' => 550, 'maxlength' => 90, 'orderby' => false),
		'active' => array('title' => $this->l('Displayed'), 'active' => 'status', 'align' => 'center', 'type' => 'bool', 'orderby' => false));

		$this->_category = AdminCatalog::getCurrentCategory();
		$this->_filter = 'AND `id_parent` = '.intval($this->_category->id);
		
		parent::__construct();
	}
	
	public function displayList()
	{
		/* Display list header (filtering, pagination and column names) */
		$this->displayListHeader();
		if (!sizeof($this->_list))
			echo '<tr><td class="center" colspan="'.sizeof($this->fieldsDisplay).'">'.$this->l('No items found').'</td></tr>';
		
		/* Show the content of the table */
		$this->displayListContent();
		
		/* Close list table and submit button */
		$this->displayListFooter();
	}
	
	public function display()
	{
		global $currentIndex, $cookie;
		
		if ((($conf = intval(Tools::getValue('conf'))) == 3 OR $conf == 4) AND !Tools::getValue('id_category'))
		{
			$category = new Category(intval(Tools::getValue('id_category')));
			Tools::redirectLink(Link::getUrlWith('id_category', $category->id_parent).'&conf='.$conf);
		}
	
		$this->getList(intval($cookie->id_lang), !Tools::getValue('orderby') ? 'name' : null, !Tools::getValue('orderway') ? 'ASC' : null);
		echo '<h3>'.(!$this->_listTotal ? ($this->l('There are no subcategories')) : ($this->_listTotal.' '.($this->_listTotal > 1 ? $this->l('subcategories') : $this->l('subcategorie')))).' '.
		$this->l('in category').' "'.stripslashes(Category::hideCategoryPosition($this->_category->name[intval($cookie->id_lang)])).'"</h3>';
		echo '<a href="'.__PS_BASE_URI__.substr($_SERVER['PHP_SELF'], strlen(__PS_BASE_URI__)).'?tab=AdminCatalog&add'.$this->table.'&id_parent='.Tools::getValue('id_category').'"><img src="../img/admin/add.gif" border="0" /> '.$this->l('Add a new subcategory').'</a>';
		echo '<div style="margin:10px;">';
		if ($this->_listTotal)
			$this->displayList();
		echo '</div>';
	}
	
	private function recurseCategory($categories, $current, $id_category = 1, $id_selected = 1)
	{
		global	$currentIndex;
		
		echo '<option value="'.$id_category.'"'.(($id_selected == $id_category) ? ' selected="selected"' : '').'>'.
		str_repeat('&nbsp;', $current['infos']['level_depth'] * 5).Category::hideCategoryPosition(stripslashes($current['infos']['name'])).'</option>';
			
		if (isset($categories[$id_category]))
			foreach ($categories[$id_category] AS $key => $row)
				$this->recurseCategory($categories, $categories[$id_category][$key], $key, $id_selected);
	}
	
	public function postProcess()
	{
	 	global	$cookie;
	 
	 	$access = new Access();
		$this->tabAccess = $access->getProfileAccess($cookie->profile, $this->id);
	 
		
		if (Tools::isSubmit('submitAdd'.$this->table))
		{
			if ($id_category = intval(Tools::getValue('id_category')))
				if (!Category::checkBeforeMove($id_category, intval(Tools::getValue('id_parent'))))
				{
					$this->_errors[] = Tools::displayError('category cannot be moved here');
					return false;
				}
		}
		parent::postProcess();
		
		if (($id_category = intval(Tools::getValue('id_category'))) AND isset($_FILES) AND file_exists(_PS_CAT_IMG_DIR_.$id_category.'.jpg'))
		{
			$imagesTypes = ImageType::getImagesTypes('categories');
			foreach ($imagesTypes AS $k => $imageType)
			{
				$file['tmp_name'] = _PS_CAT_IMG_DIR_.$id_category.'.jpg';
				$file['type'] = 'image/jpg';
				imageResize($file, _PS_CAT_IMG_DIR_.$id_category.'-'.stripslashes($imageType['name']).'.jpg', intval($imageType['width']), intval($imageType['height']));
			}	
		}
	}
	
	public function displayForm()
	{
		global $currentIndex, $cookie;
		
		$obj = $this->loadObject(true);
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$langtags = 'cname¤cdescription¤clink_rewrite¤cmeta_title¤cmeta_keywords¤cmeta_description';
		$this->displayImage($obj->id, _PS_IMG_DIR_.'c/'.$obj->id.'.jpg', 350);
		$active = $this->getFieldValue($obj, 'active');

		echo '
		<script type="text/javascript">
			id_language = Number('.$defaultLanguage.');
		</script>
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" enctype="multipart/form-data">
		'.($obj->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$obj->id.'" />' : '').'
			<fieldset class="width2"><legend><img src="../img/admin/tab-categories.gif" />'.$this->l('Category').'</legend>
				<label>'.$this->l('Name:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="cname_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" style="width: 260px" name="name_'.$language['id_lang'].'" id="name_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'name', intval($language['id_lang'])).'" onkeyup="copy2friendlyURL();" /><sup> *</sup>
						<span class="hint" name="help_box">'.$this->l('Invalid characters:').' <>;=#{}<span class="hint-pointer">&nbsp;</span></span>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'cname');
		echo '		<div class="clear"></div>
				</div>
				<label>'.$this->l('Displayed').' </label>
				<div class="margin-form">
					<input type="radio" name="active" id="active_on" value="1" '.($active ? 'checked="checked" ' : '').'/> 
					<label class="t" for="active_on"><img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="active" id="active_off" value="0" '.(!$active ? 'checked="checked" ' : '').'/> 
					<label class="t" for="active_off"><img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
				</div>
				<label>'.$this->l('Parent category:').' </label>
				<div class="margin-form">
					<select name="id_parent">';
		$categories = Category::getCategories(intval($cookie->id_lang), false);
		$this->recurseCategory($categories, $categories[0][1], 1, $this->getFieldValue($obj, 'id_parent'));
		echo '
					</select>
				</div>
				<label>'.$this->l('Description:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="cdescription_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<textarea name="description_'.$language['id_lang'].'" rows="3" cols="30">'.$this->getFieldValue($obj, 'description', intval($language['id_lang'])).'</textarea>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'cdescription');
		echo '		<div class="clear"></div>
				</div>
				<label>'.$this->l('Image:').' </label>
				<div class="margin-form">
					<input type="file" name="image" />
				</div>
				<label>'.$this->l('Meta title:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="cmeta_title_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="meta_title_'.$language['id_lang'].'" id="meta_title_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'meta_title', intval($language['id_lang'])).'" />
						<span class="hint" name="help_box">'.$this->l('Forbidden characters:').' <>;=#{}<span class="hint-pointer">&nbsp;</span></span>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'cmeta_title');
		echo '		<div class="clear"></div>
				</div>
				<label>'.$this->l('Meta keywords:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="cmeta_keywords_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="meta_keywords_'.$language['id_lang'].'" id="meta_keywords_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'meta_keywords', intval($language['id_lang'])).'" />
						<span class="hint" name="help_box">'.$this->l('Forbidden characters:').' <>;=#{}<span class="hint-pointer">&nbsp;</span></span>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'cmeta_keywords');
		echo '		<div class="clear"></div>
				</div>
				<label>'.$this->l('Meta description:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="cmeta_description_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="meta_description_'.$language['id_lang'].'" id="meta_description_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'meta_description', intval($language['id_lang'])).'" />
						<span class="hint" name="help_box">'.$this->l('Forbidden characters:').' <>;=#{}<span class="hint-pointer">&nbsp;</span></span>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'cmeta_description');
		echo '		<div class="clear"></div>
				</div>
				<label>'.$this->l('Friendly URL:').' </label>
				<div class="margin-form">';
		foreach ($languages as $language)
			echo '
					<div id="clink_rewrite_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left;">
						<input type="text" name="link_rewrite_'.$language['id_lang'].'" id="link_rewrite_'.$language['id_lang'].'" value="'.$this->getFieldValue($obj, 'link_rewrite', intval($language['id_lang'])).'" onkeyup="this.value = str2url(this.value);" /><sup> *</sup>
						<span class="hint" name="help_box">'.$this->l('Only letters and the minus character are allowed').'<span class="hint-pointer">&nbsp;</span></span>
					</div>';							
		displayFlags($languages, $defaultLanguage, $langtags, 'clink_rewrite');
		echo '		<div class="clear"></div>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Required fields').'</div>
			</fieldset>
		</form>
		<div class="clear"></div>';
	}
}

?>