<?php

/**
  * Currencies tab for admin panel, AdminCurrencies.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminCurrencies extends AdminTab
{
	public function __construct()
	{
	 	$this->table = 'currency';
	 	$this->className = 'Currency';
	 	$this->lang = false;
	 	$this->edit = true;
				
		$this->fieldsDisplay = array(
		'id_currency' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 25),
		'name' => array('title' => $this->l('Currency'), 'width' => 100),
		'iso_code' => array('title' => $this->l('iso_code'), 'align' => 'center', 'width' => 35),
		'sign' => array('title' => $this->l('Symbol'), 'width' => 20, 'align' => 'center', 'orderby' => false, 'search' => false),
		'conversion_rate' => array('title' => $this->l('Conversion rate'), 'align' => 'center', 'width' => 50, 'search' => false));

		$this->optionTitle = $this->l('Currencies options');
		$this->_fieldsOptions = array(
			'PS_CURRENCY_DEFAULT' => array('title' => $this->l('Default currency:'), 'desc' => $this->l('The default currency used in shop'), 'cast' => 'intval', 'type' => 'select', 'identifier' => 'id_currency', 'list' => Currency::getCurrencies()),
		);

		parent::__construct();
	}
	
	public function postProcess()
	{
		global $currentIndex;

		if (isset($_GET['delete'.$this->table]))
		{
			if ($this->tabAccess['delete'] === '1')		 	
		 	{
				if (Validate::isLoadedObject($object = $this->loadObject()))
				{
					if ($object->id == Configuration::get('PS_CURRENCY_DEFAULT'))
						$this->_errors[] = $this->l('You can\'t delete the default currency');
					elseif ($object->delete())
						Tools::redirectAdmin($currentIndex.'&conf=1');
					else
						$this->_errors[] = Tools::displayError('an error occurred during deletion');
				}
				else
					$this->_errors[] = Tools::displayError('an error occurred while deleting object').' <b>'.$this->table.'</b> '.Tools::displayError('(cannot load object)');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to delete here.');
		}
		elseif (Tools::getValue('submitOptions'.$this->table))
		{
			foreach ($this->_fieldsOptions as $key => $field)
			{
				Configuration::updateValue($key, $field['cast'](Tools::getValue($key)));
				if ($key == 'PS_CURRENCY_DEFAULT')
				{
					$currency = new Currency($field['cast'](Tools::getValue($key)));
					$currency->conversion_rate = 1;
					$currency->update();
				}
			}
			Tools::redirectAdmin($currentIndex.'&conf=6');
		} else
			parent::postProcess();
	}
	
	public function displayForm()
	{
		global $currentIndex;
		
		$obj = $this->loadObject(true);

		echo '
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" class="width3">
		'.($obj->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$obj->id.'" />' : '').'
			<fieldset><legend><img src="../img/admin/money.gif" />'.$this->l('Currencies').'</legend>
				<label>'.$this->l('Currency:').' </label>
				<div class="margin-form">
					<input type="text" size="30" maxlength="32" name="name" value="'.$this->getFieldValue($obj, 'name').'" /> <sup>*</sup>
					<span class="hint" name="help_box">'.$this->l('Only letters and the minus character are allowed').'<span class="hint-pointer">&nbsp;</span></span>
					<p class="clear">'.$this->l('Will appear on Website, e.g., euro, dollar').'...</p>
				</div>
				<label>'.$this->l('Iso code:').' </label>
				<div class="margin-form">
					<input type="text" size="30" maxlength="32" name="iso_code" value="'.$this->getFieldValue($obj, 'iso_code').'" /> <sup>*</sup>
					<span class="hint-pointer">&nbsp;</span>
					<p class="clear">'.$this->l('ISO code, e.g., USD for dollar, EUR for euro').'...</p>
				</div>
				<label>'.$this->l('Symbol:').' </label>
				<div class="margin-form">
					<input type="text" size="3" maxlength="8" name="sign" value="'.$this->getFieldValue($obj, 'sign').'" /> <sup>*</sup>
					<p style="clear: both;">'.$this->l('Will appear on Website, e.g., &euro;, $').'...</p>
				</div>
				<label>'.$this->l('Conversion rate:').' </label>
				<div class="margin-form">
					<input type="text" size="3" maxlength="5" name="conversion_rate" value="'.$this->getFieldValue($obj, 'conversion_rate').'" /> <sup>*</sup>
					<p style="clear: both;">'.$this->l('Conversion rate, e.g., from euros to dollars:').' 1&euro; = $1,38</p>
				</div>
				<label>'.$this->l('Formatting:').' </label>
				<div class="margin-form">
					<select name="format">
						<option value="2"'.(($this->getFieldValue($obj, 'format') == 2) ? ' selected="selected"' : '').'>0.000,00X ('.$this->l('as with euros').')</option>
						<option value="1"'.(($this->getFieldValue($obj, 'format') == 1) ? ' selected="selected"' : '').'>X0,000.00 ('.$this->l('as with dollars').')</option>
					</select>
					<p style="clear: both;">'.$this->l('Applies to all prices, e.g.,').' $1,240.15</p>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Required fields').'</div>
			</fieldset>
		</form>';
	}
}

?>
