<?php

/**
  * Emails tab for admin panel, AdminEmails.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');
include_once(dirname(__FILE__).'/AdminPreferences.php');

class AdminEmails extends AdminPreferences
{
	public function __construct()
	{
		$this->className = 'Configuration';
		$this->table = 'configuration';
 		
 		$this->_fieldsEmail = array(
		'PS_MAIL_METHOD' => array('title' => '', 'validation' => 'isGenericName', 'required' => true, 'type' => 'radio', 'choices' => array(1 => $this->l('Use PHP mail() function.  Recommended; works in most cases'), 2 => $this->l('Set my own SMTP parameters. For advanced users ONLY')), 'js' => array(1 => 'onclick="javascript:toggleLayer(\'smtp\', 0);"', 2 => 'onclick="javascript:toggleLayer(\'smtp\', 1);"')),
		'PS_MAIL_SERVER' => array('title' => $this->l('SMTP server:'), 'desc' => $this->l('IP or server name (e.g., smtp.mydomain.com)'), 'validation' => 'isGenericName', 'size' => 30, 'type' => 'text'),
		'PS_MAIL_USER' => array('title' => $this->l('SMTP user:'), 'desc' => $this->l('Leave empty if not applicable'), 'validation' => 'isGenericName', 'size' => 30, 'type' => 'text'),
		'PS_MAIL_PASSWD' => array('title' => $this->l('SMTP password:'), 'desc' => $this->l('Leave empty if not applicable'), 'validation' => 'isGenericName', 'size' => 30, 'type' => 'password'),
		'PS_MAIL_SMTP_ENCRYPTION' => array('title' => $this->l('Encryption:'), 'desc' => $this->l('Use an encrypt protocol'), 'type' => 'select', 'cast' => 'strval', 'identifier' => 'mode', 'list' => array(array('mode' => 'off', 'name' => $this->l('None')), array('mode' => 'tls', 'name' => $this->l('TLS')), array('mode' => 'ssl', 'name' => $this->l('SSL')))),
		'PS_MAIL_SMTP_PORT' => array('title' => $this->l('Port:'), 'desc' => $this->l('Use a secure port'), 'type' => 'select', 'cast' => 'strval', 'identifier' => 'mode', 'list' => array(array('mode' => $this->l('default'), 'name' => $this->l('Default')), array('mode' => $this->l('secure'), 'name' => $this->l('Secure'))))
		);
	
		parent::__construct();
	}
	
	public function postProcess()
	{
		if (isset($_POST['submitEmail'.$this->table]))
		{
		 	if ($this->tabAccess['edit'] === '1')
				$this->_postConfig($this->_fieldsEmail);
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
	}	
	public function display() { $this->_displayForm('email', $this->_fieldsEmail, $this->l('Email'), 'width2', 'email'); }
}

?>