<?php

/**
  * Import tab for admin panel, AdminImport.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */
include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminImport extends AdminTab
{
	public static $available_fileds;
	public static $required_fields = array(
		'name',
		'price',
	);
	public static $columns = array(
		'id_tax' => 1,
		'description' => '',
		'description_short' => '',
		'meta_title' => '',
		'meta_keywords' => '',
		'meta_description' => '',
		'availability' => '', 
		'category' => '1');
	public static $validators = array('price' => array('AdminImport', 'getPrice'),
		'name' => array('AdminImport', 'createMultiLangField'),
		'availability' => array('AdminImport', 'createMultiLangField'),
		'description' => array('AdminImport', 'createMultiLangField'),
		'description_short' => array('AdminImport', 'createMultiLangField'),
		'link_rewrite' => array('AdminImport', 'createMultiLangField'),
		'meta_title' => array('AdminImport', 'createMultiLangField'),
		'meta_keywords' => array('AdminImport', 'createMultiLangField'),
		'meta_description' => array('AdminImport', 'createMultiLangField'),
		'category' => array('AdminImport', 'splitCategories'),
		);
		
	private $column_mask;

	public function __construct()
	{
		$this->available_fields = array(
				'no' => $this->l('Don\'t use these values'),
				'id' => $this->l('id'),
				'reference' => $this->l('reference'),
				'name' => $this->l('name'),
				'EAN13' => $this->l('EAN13'),
				'price' => $this->l('price'),
				'weight' => $this->l('weight'),
				'quantity' => $this->l('quantity'),
				'description_short' => $this->l('short description'),
				'description' => $this->l('description'),
				'category' => $this->l('category'),
		);
		parent::__construct();
	}
	
	private static function getPrice($field)
	{
		preg_match("/\d+?\.\d+/", $field, $ret);
		return floatval(isset($ret[0]) ? $ret[0] : 0);
	}
	
	private static function splitCategories($field)
	{
		$tab = explode(',', $field);
		$res = array_map('intval', $tab);
		return $tab;
	}
	
	private static function createMultiLangField($field)
	{
		$languages = Language::getLanguages();
		$res = array();
		foreach ($languages AS $lang)
			$res[$lang['id_lang']] = $field;
		return $res;
	}

	private function getMaskedRow($row)
	{
		$res = array();
		foreach ($this->column_mask as $type => $nb)
			$res[$type] = $row[$nb];
		return $res;
	}

	private static function fillProductInfo($infos, $key, $product)
	{
		$product->{$key} = (isset(self::$validators[$key]) ? call_user_func(self::$validators[$key], $infos) : $infos);
	}
	
	public static function setDefaultValues(&$info_product)
	{
		$info_product['link_rewrite'] = preg_replace('/[^a-z0-9]/i', '-', ($info_product['name']));
		foreach (self::$columns as $k => $v)
			if (!isset($info_product[$k]))
				$info_product[$k] = $v;
	}
	
	public function productImport()
	{
		foreach ($_POST['type_value'] as $nb => $type)
			if ($type != 'no')
				$this->column_mask[$type] = $nb;
		$results = array_map(array($this, 'getMaskedRow'), $_POST['value']);
		foreach($results as $info_product)
		{
			self::setDefaultValues($info_product);
			$product = new Product();
			array_walk($info_product, array('AdminImport', 'fillProductInfo'), $product);
			if (!$product->save())
				$this->_errors[] = $info_product['name'].(isset($info_product['id']) ? ' ('.$info_product['id'].')' : '').' '.Tools::displayError('cannot be saved');
			$product->addInCategories($product->category);
		}
	}
	
	public function displayCSV()
	{
		global $currentIndex;
		
		$html = '<h2>'.$this->l('Your products data').'</h2>'.'
		<h3>'.$this->l('Please set the type of value of each column').'</h3>';
		
		// errors
		$html .= '<div id="error_duplicate_type" class="warning warn" style="display:none;">'.'
			<h3>'.$this->l('Two column cannot has the same type').'</h3>'.'
		</div>'.'
		<div id="required_column" class="warning warn" style="display:none;">'.'
			<h3>'.$this->l('Column').' <span id="missing_column">&nbsp;</span> '.$this->l('must be set').'</h3>'.'
		</div>';
		
		// data values
		$lines = file($_FILES['csv_product']['tmp_name']);
		$values = '';
		$i = 1;
		$glue = (isset($_POST['separator']) ? strval($_POST['separator']) : ';');
		foreach ($lines AS $line)
		{
			if (trim($line) != '') 
			{
				$data = $this->csvToArray($line, $glue);
				$values.= '
						<tr>
						<td style="width:20px;"><a href="javascript:void(0);" onclick="this.parentNode.parentNode.innerHTML=\'\';">
						<img border="0" title="'.$this->l('Remove this line').'" alt="'.$this->l('Remove this line').'" src="../img/admin/delete.gif"/></a></td>';
				$j = 1;
				foreach($data as $d)
				{
					$values.= '
					<td><textarea name="value['.$i.']['.$j.']" id="value['.$i.']['.$j.']">'.$d.'</textarea></td>';
					++$j;
				}
				$values.= '</tr>';
				if(!isset($nbCol)) $nbCol = count($data);
				++$i;
			}
		}
		
		// header
		$header = '';
		for ($i = 1; $i <= $nbCol; ++$i)
		{
			$header .= '<td style="width:160px; text-align:center;"><select id="type_value['.$i.']" name="type_value['.$i.']">';
			foreach ($this->available_fields AS $k => $field)
				$header .= '<option value="'.$k.'">'.$field.'</option>';
			$header .= '</select></td>';
		}

		$res = array();
		foreach (self::$required_fields AS $elem)
			$res[] = '\''.$elem.'\'';
		
		// print return
		$html .= '
		<form action="'.$currentIndex.'" method="post" id="import_form" name="import_form">
			<input type="hidden" name="import" value="on">
			<div style="text-align:center; margin-bottom:10px;"><input onclick="validateImportation(new Array('.implode(',', $res).'));return false;" id="import" type="submit" value="'.$this->l('Import CSV data').'" class="button" /></div>
			<table style="margin:0px 0px 10px 25px;">
				<tr>
					'.$header.'
				</tr>
			</table>
			<div class="table_overflow">
				<table>
					'.$values.'
				</table>
			</div>
			</div>
		</form>';
		echo $html;
	}

	public function postProcess()
	{
	
		if (!empty($_FILES['csv_product']['tmp_name']))
			$this->displayCSV();
		elseif (isset($_POST['import']))
			$this->productImport();
		parent::postProcess();
	}

	public function displayForm()
	{
		global $currentIndex;

		if (isset($_POST['import']) AND !count($this->_errors))
			echo '<div class="module_confirmation conf confirm"><img src="../img/admin/ok.gif" alt="" title="" style="margin-right:5px; float:left;" />'.$this->l('CSV file has been imported into your shop!').'</div>';
		echo '
			<form id="preview_import" action="'.$currentIndex.'" method="post" class="width2" enctype="multipart/form-data">
				<fieldset>
					<legend><img src="../img/admin/import.gif" />'.$this->l('Import products').'</legend>
					<label class="clear">'.$this->l('Select your CSV file:').' </label>
					<div class="margin-form">
						<input id="csv_product" name="csv_product" type="file" />
					</div>
					<label class="clear">'.$this->l('Column separator:').' </label>
					<div class="margin-form">
						<input name="separator" type="text" value=";" size="2" />
					</div>
					<div class="margin-form">
						<input type="submit" value="'.$this->l('Import file').'" class="button" />
					</div>
				</fieldset>
			</form>';
	}
	
	public function display()
	{
		$this->displayForm();
	}
	
	private function csvToArray($str, $glue)
	{
		return preg_replace("/^\"(.*)\"$/", "$1", preg_split("/".$glue."(?=(?:[^\"]*\"[^\"]*\")*(?![^\"]*\"))/", trim($str)));
	}
}

?>