<?php

/**
  * Manufacturers tab for admin panel, AdminManufacturers.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(realpath(dirname(__FILE__).'/../../').'/classes/AdminTab.php');

class AdminManufacturers extends AdminTab
{
	protected $maxImageSize = 200000;

	/** @var array countries list */
	private $countriesArray = array();

	public function __construct()
	{
		global $cookie;

		$this->table = 'manufacturer';
		$this->className = 'Manufacturer';
		$this->lang = false;
		$this->edit = true;
		$this->_includeTab = array('Addresses');
		$this->_includeTabTitle = array($this->l('Manufacturers addresses'));
	 	$this->view = true;
		$this->_select = 'COUNT(`id_product`) AS `products`';
		$this->_join = 'LEFT JOIN `'._DB_PREFIX_.'product` p ON a.`id_manufacturer` = p.`id_manufacturer`';
		$this->_group = 'GROUP BY a.`id_manufacturer`';
		
		$this->fieldImageSettings = array('name' => 'logo', 'dir' => 'm');
		
		$this->fieldsDisplay = array(
			'id_manufacturer' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 25),
			'name' => array('title' => $this->l('Name'), 'width' => 100),
			'logo' => array('title' => $this->l('Logo'), 'align' => 'center', 'image' => 'm', 'orderby' => false, 'search' => false),
			'products' => array('title' => $this->l('Number of products'), 'align' => 'right')
		);

		$countries = Country::getCountries(intval($cookie->id_lang));
		foreach ($countries AS $country)
			$this->countriesArray[$country['id_country']] = $country['name'];

		parent::__construct();
	}

	public function postProcess()
	{
		global $currentIndex;
		
		/* Generate image with differents size */
		if (($id_manufacturer = intval(Tools::getValue('id_manufacturer'))) AND isset($_FILES) AND file_exists(_PS_MANU_IMG_DIR_.$id_manufacturer.'.jpg'))
		{
			$imagesTypes = ImageType::getImagesTypes('manufacturers');
			foreach ($imagesTypes AS $k => $imageType)
			{
				$file['tmp_name'] = _PS_MANU_IMG_DIR_.$id_manufacturer.'.jpg';
				$file['type'] = 'image/jpg';
				imageResize($file, _PS_MANU_IMG_DIR_.$id_manufacturer.'-'.stripslashes($imageType['name']).'.jpg', intval($imageType['width']), intval($imageType['height']));
			}
		}
		parent::postProcess();
	}
	
	public function manageAdress($manufacturer, $id = 0)
	{
		/* Address addition */
		$address = new Address($id ? $id : NULL);
		$address->name = pSQL($_POST['address_name']);
		$address->id_customer = 0;
		$address->id_supplier = 0;
		$address->id_manufacturer = $manufacturer->id;
		$address->alias = $address->name;
		if ($this->validateRules())
			return false;
		return $address->add($autodate, true);
	}

	public function displayForm()
	{
		global $currentIndex;
		
		$manufacturer = $this->loadObject(true);
		$address = new Address($manufacturer->id_address);
		$this->displayImage($manufacturer->id, _PS_MANU_IMG_DIR_.$manufacturer->id.'.jpg', 350);

		echo '
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" enctype="multipart/form-data" class="width3">
		'.($manufacturer->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$manufacturer->id.'" />' : '').'
			<fieldset><legend><img src="../img/admin/manufacturers.gif" />'.$this->l('Manufacturers').'</legend>
				<label>'.$this->l('Name:').' </label>
				<div class="margin-form">
					<input type="text" size="40" name="name" value="'.Tools::getValue('name', $manufacturer->name).'" /> <sup>*</sup>
					<span class="hint" name="help_box">'.$this->l('Invalid characters:').' <>;=#{}<span class="hint-pointer">&nbsp;</span></span>
				</div>
				<label>'.$this->l('Logo:').' </label>
				<div class="margin-form">
					<input type="file" name="logo" />
					<p>'.$this->l('Upload manufacturer logo from your computer').'</p>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Requireds fields').'</div>
			</fieldset>
		</form>';
	}
	
public function viewmanufacturer()
	{
		global $cookie;
		$manufacturer = $this->loadObject();		
		echo '<h2>'.$manufacturer->name.'</h2>';
		
		$products = $manufacturer->getProductsLight(intval($cookie->id_lang));
		echo '<h3>'.$this->l('Total products:').' '.sizeof($products).'</h3>';
		foreach ($products AS $product)
		{
			$product = new Product($product['id_product'], false, intval($cookie->id_lang));
			echo '<hr />';
			if (!$product->hasAttributes())
			{
				echo '
				<table border="0" cellpadding="0" cellspacing="0" class="table width3">
					<tr>
						<th>'.$product->name.'</th>
						'.(!empty($product->reference) ? '<th width="150">'.$this->l('Ref:').' '.$product->reference.'</th>' : '').'
						'.(!empty($product->ean13) ? '<th width="120">'.$this->l('EAN13:').' '.$product->ean13.'</th>' : '').'
						'.(Configuration::get('PS_STOCK_MANAGEMENT') ? '<th class="right" width="50">'.$this->l('Qty:').' '.$product->quantity.'</th>' : '').'
					</tr>
				</table>';
			}
			else
			{
				echo '
				<h3>'.$product->name.'</h3>
				<table>
					<tr>
						<td colspan="2">
		            		<table border="0" cellpadding="0" cellspacing="0" class="table" style="width: 600px;">
			                	<tr>
				                    <th>'.$this->l('Attribute name').'</th>
				                    <th width="80">'.$this->l('Reference').'</th>
				                    <th width="80">'.$this->l('EAN13').'</th>
				                   '.(Configuration::get('PS_STOCK_MANAGEMENT') ? '<th class="right" width="40">'.$this->l('Quantity').'</th>' : '').'
			                	</tr>';
			     	/* Build attributes combinaisons */
				$combinaisons = $product->getAttributeCombinaisons(intval($cookie->id_lang));
				foreach ($combinaisons AS $k => $combinaison)
				{
					$combArray[$combinaison['id_product_attribute']]['reference'] = $combinaison['reference'];
					$combArray[$combinaison['id_product_attribute']]['ean13'] = $combinaison['ean13'];
					$combArray[$combinaison['id_product_attribute']]['quantity'] = $combinaison['quantity'];
					$combArray[$combinaison['id_product_attribute']]['attributes'][] = array($combinaison['group_name'], $combinaison['attribute_name'], $combinaison['id_attribute']);
				}
				$irow = 0;
				foreach ($combArray AS $id_product_attribute => $product_attribute)
				{
					$list = '';
					foreach ($product_attribute['attributes'] AS $attribute)
						$list .= $attribute[0].' - '.$attribute[1].', ';
					$list = rtrim($list, ', ');
					echo '
					<tr'.($irow++ % 2 ? ' class="alt_row"' : '').' >
						<td>'.stripslashes($list).'</td>
						<td>'.$product_attribute['reference'].'</td>
						'.(Configuration::get('PS_STOCK_MANAGEMENT') ? '<td>'.$product_attribute['ean13'].'</td>' : '').'
						<td class="right">'.$product_attribute['quantity'].'</td>
					</tr>';
				}
				unset($combArray);
				echo '</table>';
			}
		}
	}
}
