<?php

/**
  * Orders tab for admin panel, AdminOrders.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminOrders extends AdminTab
{
	public function __construct()
	{
	 	$this->table = 'order';
	 	$this->className = 'Order';
	 	$this->view = true;
	 	$this->_select = 'a.id_order AS id_pdf, CONCAT(c.`surname`, \' \', c.`name`) AS `customer`, osl.`name` AS `osname`, os.`color`';
	 	$this->_join = 'LEFT JOIN `'._DB_PREFIX_.'customer` c ON (c.`id_customer` = a.`id_customer`) 
	 	LEFT JOIN `'._DB_PREFIX_.'order_history` oh ON (oh.`id_order` = a.`id_order`) 
		LEFT JOIN `'._DB_PREFIX_.'order_state` os ON (os.`id_order_state` = oh.`id_order_state`) 
		LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`id_lang` = a.`id_lang`)';
		$this->_where = 'AND oh.`id_order_history` = (SELECT MAX(`id_order_history`) FROM `'._DB_PREFIX_.'order_history` moh WHERE moh.`id_order` = a.`id_order` GROUP BY moh.`id_order`)';
		
		global $cookie, $currentIndex;
		$statesArray = array();
		$states = OrderState::getOrderStates(intval($cookie->id_lang));
		foreach ($states AS $state)
			$statesArray[$state['id_order_state']] = $state['name'];
		
 		$this->fieldsDisplay = array(
		'id_order' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 25),
		'customer' => array('title' => $this->l('Customer'), 'width' => 140, 'filter_key' => 'c!name'),
		'total_paid' => array('title' => $this->l('Total'), 'width' => 50, 'align' => 'right', 'prefix' => '<b>', 'suffix' => '</b>', 'price' => true, 'currency' => true),
		'payment' => array('title' => $this->l('Payment'), 'width' => 100),
		'osname' => array('title' => $this->l('Status'), 'type' => 'select', 'select' => $statesArray, 'filter_key' => 'os!id_order_state', 'width' => 200),
		'date_add' => array('title' => $this->l('Date'), 'width' => 90, 'align' => 'right', 'type' => 'date', 'filter_key' => 'a!date_add'),
		'id_pdf' => array('title' => $this->l('PDF'), 'width' => 20, 'prefix' => '<a href="pdf.php?id_order=', 'align' => 'right', 'suffix' => '&pdf"><img src="../img/admin/pdf.gif" alt="'.$this->l('PDF').'" /></a>', 'orderby' => false, 'search' => false));

		parent::__construct();
	}
	
	/**
	  * @global object $cookie Employee cookie necessary to keep trace of his/her actions
	  */
	public function postProcess()
	{
		global $currentIndex, $cookie;
		/* Change order state, add a new entry in order history and send an e-mail to the customer if needed */
		if ((Tools::isSubmit('submitState') OR Tools::isSubmit('submitShippingNumber')) AND ($id_order = intval(Tools::getValue('id_order'))) AND Validate::isLoadedObject($order = new Order($id_order)))
		{
			if (Tools::isSubmit('submitShippingNumber'))
			{
			 	if ($this->tabAccess['edit'] === '1')
		 		{
					if (($shipping_number = Tools::getValue('shipping_number')) AND Validate::isUrl($shipping_number))
					{
						$order->shipping_number = $shipping_number;
						$order->update();
					}
					else
					{
						$this->_errors[] = Tools::displayError('shipping number is not valid');
						return;
					}
				}
				else
					$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
			}
			$history = new OrderHistory();
			$history->id_order = $id_order;
			$newOrderStatusId = intval(Tools::getValue('id_order_state'));
			$history->changeIdOrderState($newOrderStatusId, $id_order);
			$history->id_employee = intval($cookie->id_employee);
			$carrier = new Carrier(intval($order->id_carrier), intval($order->id_lang));
			$templateVars = array('{followup}' => ($history->id_order_state == _PS_OS_SHIPPING_ AND $order->shipping_number) ? str_replace('@', $order->shipping_number, $carrier->url) : '');
 			if ($history->addWithemail(true, $templateVars))
				Tools::redirectAdmin($currentIndex.'&id_order='.$id_order.'&vieworder');
			$this->_errors[] = Tools::displayError('an error occurred while changing state or mail couldn\'t have been sent to the customer');
		}
		
		/* Add a new message for the current order and send an e-mail to the customer if needed */
		elseif (($productName = urldecode(Tools::getValue('deleteProduct'))) AND Validate::isLoadedObject($order = new Order(intval(Tools::getValue('id_order')))))
		{
		 	if ($this->tabAccess['edit'] === '1')
			{
				if ($order->deleteProduct($productName))
					Tools::redirectLink($currentIndex.'&conf=1');
				$this->_errors[] = Tools::displayError('an error occurred during deletion');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to delete here.');
		}
		
		/* Add a new message for the current order and send an e-mail to the customer if needed */
		elseif (isset($_POST['submitMessage']))
		{
		 	if ($this->tabAccess['edit'] === '1')
			{
				if (!($id_order = intval(Tools::getValue('id_order'))) OR !($id_customer = intval(Tools::getValue('id_customer'))))
					$this->_errors[] = Tools::displayError('an error occurred before sending message');
				elseif (!Tools::getValue('message'))
					$this->_errors[] = Tools::displayError('message cannot be blank');
				else
				{
					/* Get message rules and and check fields validity */
					$rules = call_user_func(array('Message', 'getValidationRules'), 'Message');
					foreach ($rules['required'] AS $field)
						if (($value = Tools::getValue($field)) == false AND (string)$value != '0')
							if (!Tools::getValue('id_'.$this->table) OR $field != 'passwd')
								$this->_errors[] = Tools::displayError('field').' <b>'.$field.'</b> '.Tools::displayError('is required');	
					foreach ($rules['size'] AS $field => $maxLength)
						if (Tools::getValue($field) AND strlen(Tools::getValue($field)) > $maxLength)
							$this->_errors[] = Tools::displayError('field').' <b>'.$field.'</b> '.Tools::displayError('is too long').' ('.$maxLength.' '.Tools::displayError('chars max').')';
					foreach ($rules['validate'] AS $field => $function)
						if (Tools::getValue($field))
							if (!Validate::$function(Tools::getValue($field)))
								$this->_errors[] = Tools::displayError('field').' <b>'.$field.'</b> '.Tools::displayError('is invalid');
					if (!sizeof($this->_errors))
					{
						$message = new Message();
						$message->id_employee = intval($cookie->id_employee);
						$message->message = htmlentities(Tools::getValue('message'), ENT_COMPAT, 'UTF-8');
						$message->id_order = $id_order;
						$message->private = Tools::getValue('visibility');
						if (!$message->add())
							$this->_errors[] = Tools::displayError('an error occurred while sending message');
						elseif ($message->private)
							Tools::redirectAdmin($currentIndex.'&id_order='.$id_order.'&vieworder&conf=11');
						elseif (Validate::isLoadedObject($customer = new Customer($id_customer)))
						{
							$order = new Order(intval($message->id_order));
							if (Validate::isLoadedObject($order))
								if (Mail::Send(intval($order->id_lang), 'order_merchant_comment', $this->l('New message about your order').' '.$message->id_order, array('{genre}' => Gender::getNameById($message->id_customer), '{name}' => $customer->name, '{surname}' => $customer->surname, '{id_order}' => $message->id_order, '{message}' => $message->message), $customer->email, $customer->surname.' '.$customer->name))
									Tools::redirectAdmin($currentIndex.'&id_order='.$id_order.'&vieworder&conf=2');
						}
						$this->_errors[] = Tools::displayError('an error occurred while sending mail to the customer');
					}
				}
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to delete here.');
		}
		elseif (isset($_POST['submitReestablishQuantities']))
		{
			$order = $this->loadObject();
			$currentState = $order->getCurrentStateFull($cookie->id_lang);

			if ($currentState['logable'])
				die(Tools::displayError());
			$cart = new Cart($order->id_cart);
			if (!Validate::isLoadedObject($cart))
				die(Tools::displayError());

			$products = $cart->getProducts();
			if ($products)
			{
				foreach ($products AS $product)
					if (!Product::reinjectQuantities($product))
						$this->_errors[] = Tools::displayError('Cannot reestablish quantities for the product ').'<span class="bold">'.$product['name'].'</span>';
				if (!sizeof($this->_errors))
					echo '<div class="conf confirm">'.$this->l('The quantities have been reestablished successfully').'</div>';
			}
			else
				$this->_errors[] = Tools::displayError('No products linked to this order!');
		}
		else
			parent::postProcess();
	}
	
	public function viewDetails()
	{
		global $currentIndex, $cookie;
		$irow = 0;
		$order = $this->loadObject();

		$customer = new Customer($order->id_customer);
		$customerStats = $customer->getStats();
		$addressInvoice = new Address($order->id_address_invoice);
		$addressDelivery = new Address($order->id_address_delivery);
		$carrier = new Carrier($order->id_carrier);
		$history = $order->getHistory($cookie->id_lang);
		$products = $order->getProducts();
		$discounts = $order->getDiscounts();
		$messages = Message::getMessagesByOrderId($order->id);
		$states = OrderState::getOrderStates(intval($cookie->id_lang));
		$currency = new Currency($order->id_currency);
		$link = new Link();
		
		$row = array_shift($history);
		echo '<h2>'.$customer->surname.' '.$customer->name.' #'.sprintf('%06d', $order->id).' 
		- <a href="pdf.php?id_order='.$order->id.'&pdf"><img src="../img/admin/pdf.gif" alt="'.$this->l('View invoice').'" /></a> 
		- <a href="javascript:window.print()"><img src="../img/admin/printer.gif" alt="'.$this->l('Print order').'" /></a></h2>';
		if ($order->total_paid != $order->total_paid_real)
			echo '<center><span class="warning" style="font-size: 16px">Warning: '.Tools::displayPrice($order->total_paid_real, $currency).' paid instead of '.Tools::displayPrice($order->total_paid, $currency).' !</span></center><div class="clear"><br /><br /></div>';

		// display bar code if module enabled
		$hook = Module::hookExec('invoice', array('id_order' => $order->id));
		if ($hook !== false)
		{
			echo '<div style="float: right; margin: -40px 40px 10px 0;">';
			echo $hook;
			echo '</div><br style="clear: both;" />';
		}

		// display hook specified to this page : AdminOrder
		if (($hook = Module::hookExec('adminOrder', array('id_order' => $order->id))) !== false)
		{
			echo $hook;
		}

		/* Display current state */
		echo '
		<div style="float: left;"><table cellspacing="0" cellpadding="0" class="table" style="width: 429px">
			<tr>
				<th>'.Tools::displayDate($row['date_add'], 1, true).'</th>
				<th><img src="../img/tmp/order_state_mini_'.$row['id_order_state'].'.gif" /></th>
				<th>'.stripslashes($row['ostate_name']).'</th>
				<th>'.((!empty($row['employee_name'])) ? '('.stripslashes(substr($row['employee_surname'], 0, 1)).'. '.stripslashes($row['employee_name']).')' : '').'</th>
			</tr>';
		/* Display previous states */
		foreach ($history AS $row)
		{
			echo '
			<tr class="'.($irow++ % 2 ? 'alt_row' : '').'">
				<td>'.Tools::displayDate($row['date_add'], 1, true).'</td>
				<td><img src="../img/tmp/order_state_mini_'.$row['id_order_state'].'.gif" /></td>
				<td>'.stripslashes($row['ostate_name']).'</td>
				<td>'.((!empty($row['employee_name'])) ? '('.stripslashes(substr($row['employee_surname'], 0, 1)).'. '.stripslashes($row['employee_name']).')' : '').'</td>
			</tr>';
		}
		echo '</table></div>';

		echo '<div style="float: left; margin-left: 40px">
			<form action="'.$currentIndex.'&view'.$this->table.'" method="post">
				<select name="id_order_state">';
		$currentState = $order->getCurrentStateFull($cookie->id_lang);
		foreach ($states AS $state)
			echo '<option value="'.$state['id_order_state'].'"'.(($state['id_order_state'] == $currentState['id_order_state']) ? ' selected="selected"' : '').'>'.stripslashes($state['name']).'</option>';
		echo '
				</select>
				<input type="hidden" name="id_order" value="'.$order->id.'" />
				<input type="submit" name="submitState" value="'.$this->l('Change status').'" class="button" />
				<br />';
		/* Display shipping number field */
		echo '<input type="text" name="shipping_number" value="' . $order->shipping_number . '" />
					<input type="submit" name="submitShippingNumber" value="'.$this->l('Set shipping number').'" class="button" />
			<div style="margin-bottom: 4px;">'.(intval($currentState['logable']) == 0 ? '<input type="submit" name="submitReestablishQuantities" value="'.$this->l('Reestablish quantities').'" class="button" />' : '').'</div>
			</form>
		</div>';

		echo '<div class="clear">&nbsp;</div>';

		if ($order->shipping_number)
		{
			echo '<br />
			<fieldset><legend><img src="../img/admin/delivery.gif" /> '.$this->l('Shipping number').'</legend>
				'.$this->l('Click on the following URL to follow the delivery step by step:').' <a href="'.str_replace('@', $order->shipping_number, $carrier->url).'" target="_blank">'.str_replace('@', $order->shipping_number, $carrier->url).'</a>
			</fieldset>
			<div class="clear">&nbsp;</div>';
		}
		
		/* Disply customer information */
		echo '
		<div style="float: left;">
			<fieldset style="width: 400px">
				<legend><img src="../img/admin/tab-customers.gif" /> '.$this->l('Customer informations').'</legend>
				<span style="font-weight: bold; font-size: 14px;"><a href="?tab=AdminCustomers&id_customer='.$customer->id.'&viewcustomer"> '.$customer->surname.' '.$customer->name.'</a></span><br />
				(<a href="mailto:'.$customer->email.'">'.$customer->email.'</a>)<br /><br />
				'.$this->l('Registration:').' '.Tools::displayDate($customer->date_add, 1, true).'<br />
				'.$this->l('Valid orders placed:').' <b>'.$customerStats['nb_orders'].'</b><br />
				'.$this->l('Total paid since registration:').' <b>'.Tools::displayPrice($customerStats['total_orders'], $currency).'</b><br />
			</fieldset>';
			if (sizeof($messages))
			{
				echo '<br /><fieldset style="width: 400px"><legend><img src="../img/admin/email.gif" /> '.$this->l('Messages').'</legend>';
				foreach ($messages as $message)
					echo '('.Tools::displayDate($message['date_add'], 1, true).') <b>'.(($message['ename']) ? ($message['esurname'].' '.$message['ename']) : ($message['csurname'].' '.$message['cname'])).'</b>: '.$message['message'].'<br />';
				echo '</fieldset><div class="clear">&nbsp;</div>';
			}
		echo '</div>
		<div style="float: left; margin-left: 40px">
			<fieldset style="width: 400px">
				<legend><img src="../img/admin/details.gif" /> '.$this->l('Order details').'</legend>
				<label>'.$this->l('Payment mode:').' </label>
				<div style="margin: 2px 0 1em 190px;">'.$order->payment.' '.($order->module ? '('.$order->module.')' : '').'</div>
				<div style="margin: 2px 0 1em 50px;">
					<table class="table" width="300px;" cellspacing="0" cellpadding="0">
						<tr><td width="150px;">'.$this->l('Products').'</td><td align="right">'.Tools::displayPrice($order->getTotalProductsWithTaxes(), $currency).'</td></tr>
						<tr><td>'.$this->l('Discounts').'</td><td align="right">'.Tools::displayPrice($order->total_discounts, $currency).'</td></tr>
						<tr><td>'.$this->l('Shipping').'</td><td align="right">'.Tools::displayPrice($order->total_shipping, $currency).'</td></tr>
						<tr style="font-size: 20px"><td>'.$this->l('Total').'</td><td align="right">'.Tools::displayPrice($order->total_paid, $currency, false, false).($order->total_paid != $order->total_paid_real ? '<br /><font color="red">('.$this->l('Paid:').' '.Tools::displayPrice($order->total_paid_real, $currency).')</font>' : '').'</td></tr>
					</table>
				</div>
				<label>'.$this->l('Carrier:').'</label>
				<div style="margin: 2px 0 1em 190px;">
					'.((file_exists(_PS_SHIP_IMG_DIR_.$carrier->id.'.jpg')) ? '<img src="'._THEME_SHIP_DIR_.$carrier->id.'.jpg" />' : $carrier->name.'&nbsp;').'
					<br />'.(!empty($order->shipping_number) ? $this->l('Tracking number:').' '.$order->shipping_number : $this->l('No tracking number')).'
				</div>
				<label>'.$this->l('Recycled package:').' </label>
				<div style="margin: 2px 0 1em 190px;">'.($order->recyclable ? '<img src="../img/admin/enabled.gif" />' : '<img src="../img/admin/disabled.gif" />').'</div>
				<label>'.$this->l('Gift wrapping:').' </label>
				<div style="margin: 2px 0 1em 190px;">'.($order->gift ? '<img src="../img/admin/enabled.gif" /><br />
				<div style="border: 1px dashed #999; padding: 5px; margin-top: 8px;"><b>'.$this->l('Message:').'</b><br />'.$order->gift_message.'</div>' : '<img src="../img/admin/disabled.gif" />').'</div>
			</fieldset>
		</div>';

		/* Display adresses : delivery & invoice */
		echo '<div class="clear">&nbsp;</div>
		<div style="float: left">
			<fieldset style="width: 400px;">
				<legend><img src="../img/admin/delivery.gif" alt="Shipping" />'.$this->l('Shipping').'</legend>
				<div style="float: right"><a href="'.$link->getUrlWith('tab', 'AdminAddresses').'&id_address='.$addressDelivery->id.'&addaddress&realedit=1&id_order='.$order->id.($addressDelivery->id == $addressInvoice->id ? '&address_type=1' : '').'&back='.urlencode($_SERVER['REQUEST_URI']).'"><img src="../img/admin/edit.gif" /></a></div>
				'. (!empty($addressDelivery->company) ? $addressDelivery->company.'<br />' : '') .$addressDelivery->surname.' '.$addressDelivery->name.'<br />
				'.$addressDelivery->address1.'<br />'. (!empty($addressDelivery->address2) ? $addressDelivery->address2.'<br />' : '') .'
				'.$addressDelivery->postcode.' '.$addressDelivery->city.'<br />
				'.$addressDelivery->country.'
				'.(!empty($addressDelivery->other) ? '<hr />'.$addressDelivery->other.'<br />' : '').'
			</fieldset>
		</div>
		<div style="float: left; margin-left: 40px">
			<fieldset style="width: 400px;">
				<legend><img src="../img/admin/invoice.gif" alt="'.$this->l('Invoice').'" />'.$this->l('Invoice').'</legend>
				<div style="float: right"><a href="'.$link->getUrlWith('tab', 'AdminAddresses').'&id_address='.$addressInvoice->id.'&addaddress&realedit=1&id_order='.$order->id.($addressDelivery->id == $addressInvoice->id ? '&address_type=2' : '').'&back='.urlencode($_SERVER['REQUEST_URI']).'"><img src="../img/admin/edit.gif" /></a></div>
				'. (!empty($addressInvoice->company) ? $addressInvoice->company.'<br />' : '') .$addressInvoice->surname.' '.$addressInvoice->name.'<br />
				'.$addressInvoice->address1.'<br />'. (!empty($addressInvoice->address2) ? $addressInvoice->address2.'<br />' : '') .'
				'.$addressInvoice->postcode.' '.$addressInvoice->city.'<br />
				'.$addressInvoice->country.'
				'.(!empty($addressInvoice->other) ? '<hr />'.$addressInvoice->other.'<br />' : '').'
			</fieldset>
		</div>
		<div class="clear">&nbsp;</div>';

		// List of products
		echo '
		<table style="width: 898px" cellspacing="0" cellpadding="0" class="table">
			<tr><th>'.$this->l('Reference').'</th><th>'.$this->l('Product name').'</th><th>&nbsp;</th><th style="width: 60px">'.$this->l('Unit price').'</th><th style="width: 20px">'.$this->l('Quantity').'</th><th style="width: 60px">'.$this->l('Total price').'</th></tr>';
		foreach ($products as $product)
		{
			echo '
			<tr>
				<td><a href="index.php?tab=AdminCatalog&id_product='.$product['product_id'].'&updateproduct">'.$product['product_reference'].'</a></td>
				<td style="padding: 6px">'.$product['product_name'].'</td>
				<td><a href="'.$currentIndex.'&id_order='.intval($order->id).'&deleteProduct='.urlencode($product['product_name']).'" onclick="return confirm(\''.addslashes($this->l('Delete').' '.$product['product_name']).'\');"><img src="../img/admin/delete.gif" /></a></td>
				<td align="right">'.Tools::displayPrice($product['product_price_wt'], $currency).'</td>
				<td align="right">'.$product['product_quantity'].'</td>
				<td align="right">'.Tools::displayPrice($product['total_wt'], $currency).'</td>
			</tr>';
		}
		echo '</table><div class="clear">&nbsp;</div>';
		if (sizeof($discounts))
		{
			echo '<table cellspacing="0" cellpadding="0" class="table"><tr><th>'.$this->l('Discount name').'</th><th>'.$this->l('Value').'</th></tr>';
			foreach ($discounts as $discount)
				echo '<tr><td>'.$discount['name'].'</td><td align="right">-'.Tools::displayPrice($discount['value'], $currency).'</td></tr>';
			echo '</table><div class="clear">&nbsp;</div>';
		}

		/* Display send a message to customer */
		echo '	
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" onsubmit="if (getE(\'visibility\').checked == true) return confirm(\''.$this->l('Do you want to send this message to the customer?').'\');">
			<fieldset style="width: 400px;">
				<legend style="cursor: pointer;" onclick="openCloseLayer(\'message\');openCloseLayer(\'message_m\');"><img src="../img/admin/email_edit.gif" /> '.$this->l('New message').'</legend>
				<div id="message_m" style="display: '.(Tools::getValue('message') ? 'none' : 'block').'">
					<a href="javascript:openCloseLayer(\'message\');openCloseLayer(\'message_m\');">'.$this->l('Click here to add a comment or send a message to the customer').'</a>
				</div>
				<div id="message" style="display: '.(Tools::getValue('message') ? 'block' : 'none').'">
					<b>'.$this->l('Display to consumer?').'</b>
					<input type="radio" name="visibility" id="visibility" value="0" /> '.$this->l('Yes').'
					<input type="radio" name="visibility" value="1" checked="checked" /> '.$this->l('No').'<br /><br />
					<textarea name="message" cols="60" rows="8">'.Tools::getValue('message').'</textarea><br /><br />
					<input type="hidden" name="id_order" value="'.$order->id.'" />
					<input type="hidden" name="id_customer" value="'.$order->id_customer.'" />
					<input type="submit" class="button" name="submitMessage" value="'.$this->l('Send').'" />
				</div>
			</fieldset>
		</form>';

		/* */

		echo '<br /><br /><a href="'.$currentIndex.'"><img src="../img/admin/arrow.gif" /> '.$this->l('Back to list').'</a><br />';
	}
	
	public function display()
	{
		global $cookie;
		
		if (isset($_GET['view'.$this->table]))
			$this->viewDetails();
		else
		{
			$this->getList(intval($cookie->id_lang), !Tools::getValue('orderby') ? 'date_add' : null, !Tools::getValue('orderway') ? 'DESC' : null);
			$this->displayList();
		}
	}
}

?>
