<?php

/**
  * Payment tab for admin panel, AdminPayment.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminPayment extends AdminTab
{
	public function display()
	{
		$irow = 0;
		
		/* Get all modules then select only payment ones*/
		$modules = Module::getModulesOnDisk();
		$paymentModules = array();
		foreach ($modules AS $module)
			if ($module->tab == 'Payment')
				$paymentModules[] = $module;
				
		foreach ($paymentModules AS $module)
			if ($module->active AND $module->warning)
				$this->displayWarning($module->displayName.' - '.stripslashes(pSQL($module->warning)));
		
		echo '
		<table cellpadding="0" cellspacing="0" class="table width3">
			<tr>
				<th colspan="4" class="center">
					<strong><span style="color: red">'.sizeof($paymentModules).'</span> '.((sizeof($paymentModules) > 1) ? $this->l('payment modules') : $this->l('payment module')).'</strong>
				</th>
			</tr>';
		/* Display payment modules */
		foreach ($paymentModules AS $module)
			echo '
			<tr'.($irow++ % 2 ? ' class="alt_row"' : '').' style="height: 35px;">
				<td style="padding-left: 10px;">
					<img src="'.__PS_BASE_URI__.'modules/'.$module->name.'/logo.gif" alt="'.$module->name.'" />
					<strong>'.$module->displayName.'</strong>
					'.($module->version ? ' v'.(intval($module->version) == $module->version? sprintf('%.1f', $module->version) : floatval($module->version)) : '').'
					<br />'.$module->description.'
				</td>
				<td width="80">'.($module->active ? '<a href="index.php?tab=AdminModules&configure='.urlencode($module->name).'&bpay">'.$this->l('Configure').'</a>' : '').'</td>
				<td class="center" width="40"><img src="../img/admin/'.($module->active ? 'enabled.gif' : 'forbbiden.gif').'" alt="" /></td>
				<td class="center" width="80">'.((!$module->active)
					? '<input type="button" class="button small" name="Install" value="'.$this->l('Install').'"
					onclick="javascript:document.location.href=\'index.php?tab=AdminModules&install='.urlencode($module->name).'&bpay=1\'" />'
					: '<input type="button" class="button small" name="Uninstall" value="'.$this->l('Uninstall').'"
					onclick="javascript:document.location.href=\'index.php?tab=AdminModules&uninstall='.urlencode($module->name).'&bpay=1\'" />').'
				</td>
			</tr>';	
		echo '</table>';
	}
}

?>