<?php

/**
  * General preferences tab for admin panel, AdminPreferences.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminPreferences extends AdminTab
{
	public function __construct()
	{
		
		global $cookie;
	
		$this->className = 'Configuration';
		$this->table = 'configuration';
		
 		$this->_fieldsGeneral = array(
			'PS_BASE_URI' => array('title' => $this->l('PS directory:'), 'desc' => $this->l('Name of the PrestaShop directory on your Web server, bracketed by forward slashes (e.g., /shop/)'), 'validation' => 'isGenericName', 'type' => 'text', 'size' => 20, 'default' => '/'),
			'PS_SHOP_ENABLE' => array('title' => $this->l('Enable Shop:'), 'desc' => $this->l('Enable or disabled your shop. You can deactivate your shop in order to perform maintenance on it'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
			'PS_REWRITING_SETTINGS' => array('title' => $this->l('Friendly URL:'), 'desc' => $this->l('Enable only if your server allows URL rewriting (recommended)').'<p class="hint clear" style="display: block;">'.$this->l('If you turn on this feature, you must rename the .htaccess.txt file to .htaccess').'</p><div class="clear"></div>', 'validation' => 'isBool', 'required' => true, 'cast' => 'intval', 'type' => 'bool'),
			'PS_HELPBOX' => array('title' => $this->l('Back Office help boxes:'), 'desc' => $this->l('Enable yellow help boxes which are displayed under form fields in the Back Office'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
			'PS_CONDITIONS' => array('title' => $this->l('Terms of service:'), 'desc' => $this->l('Require customers to accept or decline terms of service before processing the order'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
			'PS_GIFT_WRAPPING' => array('title' => $this->l('Offer gift-wrapping:'), 'desc' => $this->l('Suggest free gift-wrapping to customer'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
			'PS_RECYCLABLE_PACK' => array('title' => $this->l('Offer recycled packaging:'), 'desc' => $this->l('Suggest recycled packaging to customer'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
			'PS_CART_FOLLOWING' => array('title' => $this->l('Cart re-display at login:'), 'desc' => $this->l('After customer logs in, recall and display contents of his/her last shopping cart'), 'validation' => 'isBool', 'cast' => 'intval', 'type' => 'bool'),
		);
	
		parent::__construct();
	}
	
	public function display()
	{
		$this->_displayForm('general', $this->_fieldsGeneral, $this->l('General'), 'width2', 'tab-preferences');
	}
	
	public function postProcess()
	{
		global $currentIndex;
		
		if (isset($_POST['submitGeneral'.$this->table]))
		{
		 	if ($this->tabAccess['edit'] === '1')
				$this->_postConfig($this->_fieldsGeneral);
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (isset($_POST['submitShop'.$this->table]))
		{
		 	if ($this->tabAccess['edit'] === '1')
				$this->_postConfig($this->_fieldsShop);
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (isset($_POST['submitAppearance'.$this->table]))
		{
		 	if ($this->tabAccess['edit'] === '1')
				$this->_postConfig($this->_fieldsAppearance);
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (isset($_POST['submitThemes'.$this->table]))
		{
		 	if ($this->tabAccess['edit'] === '1')
		 	{
				if ($val = Tools::getValue('PS_THEME'))
				{
				 	rewriteSettingsFile(NULL, $val, NULL);
				 	Tools::redirectAdmin($currentIndex.'&conf=6');
				}
				else
					$this->_errors[] = Tools::displayError('you must choose a graphical theme');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
	}
	
	/**
	  * Update settings in database and configuration files
	  *
	  * @params array $fields Fields settings
	  *
	  * @global string $currentIndex Current URL in order to keep current Tab
	  */
	protected function _postConfig($fields)
	{
		global $currentIndex;
		
		$languages = Language::getLanguages();

		/* Check required fields */
		foreach ($fields AS $field => $values)
			if (isset($values['required']) AND $values['required'])
				if ($values['type'] == 'textLang')
				{
					foreach ($languages as $language)
						if (($value = Tools::getValue($field.'_'.$language['id_lang'])) == false AND (string)$value != '0')
							$this->_errors[] = Tools::displayError('field').' <b>'.$values['title'].'</b> '.Tools::displayError('is required');
				}
				elseif (($value = Tools::getValue($field)) == false AND (string)$value != '0')
					$this->_errors[] = Tools::displayError('field').' <b>'.$values['title'].'</b> '.Tools::displayError('is required');

		/* Check fields validity */
		foreach ($fields AS $field => $values)
			if ($values['type'] == 'textLang')
			{
				foreach ($languages as $language)
					if (Tools::getValue($field.'_'.$language['id_lang']) AND isset($values['validation']))
						if (!Validate::$values['validation'](Tools::getValue($field.'_'.$language['id_lang'])))
							$this->_errors[] = Tools::displayError('field').' <b>'.$values['title'].'</b> '.Tools::displayError('is invalid');
			}
			elseif (Tools::getValue($field) AND isset($values['validation']))
				if (!Validate::$values['validation'](Tools::getValue($field)))
					$this->_errors[] = Tools::displayError('field').' <b>'.$values['title'].'</b> '.Tools::displayError('is invalid');

		/* Default value if null */
		foreach ($fields AS $field => $values)
			if (!Tools::getValue($field) AND isset($values['default']))
				$_POST[$field] = $values['default'];
		
		/* Save process */
		if (!sizeof($this->_errors))
		{
			if (isset($_POST['submitGeneral'.$this->table]))
			{
				rewriteSettingsFile(isset($_POST['PS_BASE_URI']) ? $_POST['PS_BASE_URI'] : '', NULL, NULL);
				unset($this->_fieldsGeneral['PS_BASE_URI']);
			}
			elseif (isset($_POST['submitAppearance'.$this->table]))
			{
				if (isset($_FILES['PS_LOGO']['tmp_name']) AND $_FILES['PS_LOGO']['tmp_name'])
				{
					if ($error = checkImage($_FILES['PS_LOGO'], 300000))
						$this->_errors[] = $error;
					elseif (!imageResize($_FILES['PS_LOGO'], _PS_IMG_DIR_.'logo.jpg'))
						$this->_errors[] = 'an error occured during logo copy';
				}
				$this->uploadIco('PS_FAVICON', _PS_THEME_DIR_.'img/favicon.ico');
			}
			
			/* Update settings in database */
			if (!sizeof($this->_errors))
			{
				foreach ($fields AS $field => $values)
				{
					unset($val);
					if ($values['type'] == 'textLang')
						foreach ($languages as $language)
							$val[$language['id_lang']] = isset($values['cast']) ? $values['cast'](Tools::getValue($field.'_'.$language['id_lang'])) : Tools::getValue($field.'_'.$language['id_lang']);
					else
						$val = isset($values['cast']) ? $values['cast'](Tools::getValue($field)) : Tools::getValue($field);
					Configuration::updateValue($field, $val);
				}
				Tools::redirectAdmin($currentIndex.'&conf=6');
			}
		}
	}
	
	private function getVal($conf, $key)
	{
		return Tools::getValue($key, (isset($conf[$key]) ? $conf[$key] : ''));
	}
	
	private function getConf($fields, $languages)
	{
		foreach ($fields AS $key => $field)
		{
			if ($field['type'] == 'textLang')
				foreach ($languages as $language)
					$tab[$key.'_'.$language['id_lang']] = Tools::getValue($key.'_'.$language['id_lang'], Configuration::get($key, $language['id_lang']));
			else
				$tab[$key] =  Tools::getValue($key, Configuration::get($key));
		}
		$tab['PS_BASE_URI'] = __PS_BASE_URI__;
		$tab['PS_THEME'] = _THEME_NAME_;
		$tab['db_type'] = _DB_TYPE_;
		$tab['db_server'] = _DB_SERVER_;
		$tab['db_name'] = _DB_NAME_;
		$tab['db_prefix'] = _DB_PREFIX_;
		$tab['db_user'] = _DB_USER_;
		$tab['db_passwd'] = '';
		return $tab;
	}
	
	private function	getDivLang($fields)
	{
		$tab = array();
		foreach ($fields AS $key => $field)
			if ($field['type'] == 'textLang')
				$tab[] = $key;
		return implode('¤', $tab);
	}
	
	/**
	  * Display configuration form
	  *
	  * @params string $name Form name
	  * @params array $fields Fields settings
	  *
	 * @global string $currentIndex Current URL in order to keep current Tab
	  */
	protected function _displayForm($name, $fields, $tabname, $size, $icon)
	{
		global $currentIndex;
		
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$confValues = $this->getConf($fields, $languages);
		$divLangName = $this->getDivLang($fields);
		$required = false;

		echo '
		<script type="text/javascript">
			id_language = Number('.$defaultLanguage.');
		</script>
		<form action="'.$currentIndex.'&submit'.$name.$this->table.'=1" method="post" class="'.$size.'" enctype="multipart/form-data">
			<fieldset><legend><img src="../img/admin/'.strval($icon).'.gif" />'.$tabname.'</legend>';
		foreach ($fields AS $key => $field)
		{
			/* Specific line for e-mails settings */
			if (get_class($this) == 'Adminemails' AND $key == 'PS_MAIL_SERVER')
				echo '<div id="smtp" style="display: '.((isset($confValues['PS_MAIL_METHOD']) AND $confValues['PS_MAIL_METHOD'] == 2) ? 'block' : 'none').';">';
			if (isset($field['required']) AND $field['required'])
				$required = true;
			$val = $this->getVal($confValues, $key);
			if (!in_array($field['type'], array('image', 'radio')) OR isset($field['show']))
				echo '<div style="clear: both; padding-top:15px;">'.($field['title'] ? '<label >'.$field['title'].'</label>' : '').'<div class="margin-form" style="padding-top:5px;">';
			
			/* Display the appropriate input type for each field */
			switch ($field['type'])
			{
				case 'select':
					echo '
					<select name="'.$key.'">';
					foreach ($field['list'] AS $k => $value)
						echo '<option value="'.(isset($value['cast']) ? $value['cast']($value[$field['identifier']]) : $value[$field['identifier']]).'"'.(($val == $value[$field['identifier']]) ? ' selected="selected"' : '').'>'.$value['name'].'</option>';
					echo '
					</select>';
					break;
					
				case 'bool':
					echo '<label class="t" for="'.$key.'_on"><img src="../img/admin/enabled.gif" alt="'.$this->l('Yes').'" title="'.$this->l('Yes').'" /></label>
					<input type="radio" name="'.$key.'" id="'.$key.'_on" value="1"'.($val ? ' checked="checked"' : '').' />
					<label class="t" for="'.$key.'_on"> '.$this->l('Yes').'</label>
					<label class="t" for="'.$key.'_off"><img src="../img/admin/disabled.gif" alt="'.$this->l('No').'" title="'.$this->l('No').'" style="margin-left: 10px;" /></label>
					<input type="radio" name="'.$key.'" id="'.$key.'_off" value="0" '.(!$val ? 'checked="checked"' : '').'/>
					<label class="t" for="'.$key.'_off"> '.$this->l('No').'</label>';
					break;
					
				case 'radio':
					foreach ($field['choices'] AS $cValue => $cKey)
						echo '<input type="radio" name="'.$key.'" id="'.$key.$cValue.'_on" value="'.intval($cValue).'"'.(($cValue == $val) ? ' checked="checked"' : '').(isset($field['js'][$cValue]) ? ' '.$field['js'][$cValue] : '').' /><label class="t" for="'.$key.$cValue.'_on"> '.$cKey.'</label><br />';
					echo '<br />';
					break;

				case 'image':
					echo '
					<table cellspacing="0" cellpadding="0">
						<tr>';
					$i = 0;
					foreach ($field['list'] AS $theme)
					{
						echo '<td class="center" style="width: 180px; padding:0px 20px 20px 0px;">
						<input type="radio" name="'.$key.'" id="'.$key.'_'.$theme['name'].'_on" style="vertical-align: text-bottom;" value="'.$theme['name'].'"'.
						(_THEME_NAME_ == $theme['name'] ? 'checked="checked"' : '').' />
						<label class="t" for="'.$key.'_'.$theme['name'].'_on"> '.ucwords(strtolower($theme['name'])).'</label>
						<br />
						<label class="t" for="'.$key.'_'.$theme['name'].'_on">
							<img src="../themes/'.$theme['name'].'/preview.jpg" alt="'.ucwords(strtolower($theme['name'])).'">
						</label>
						</td>';
						if (isset($field['max']) AND $field['max'] == $i + 1)
							echo '</tr><tr>';
						$i++;
					}
					echo '</tr>
					</table>';
					break;

				case 'price':
					$default_currency = new Currency(intval(Configuration::get("PS_CURRENCY_DEFAULT")));
					echo ($default_currency->format == 1 ? $default_currency->sign.'&nbsp;' : '').'<input type="'.$field['type'].'" size="'.(isset($field['size']) ? intval($field['size']) : 5).'" name="'.$key.'" value="'.($field['type'] == 'password' ? '' : $val).'" />'.($default_currency->format == 2 ? '&nbsp;'.$default_currency->sign : '');
					break;

				case 'textLang':
					foreach ($languages as $language)
						echo '
						<div id="'.$key.'_'.$language['id_lang'].'" style="margin-bottom:8px; display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; float: left; vertical-align: top;">
							<input type="text" name="'.$key.'_'.$language['id_lang'].'" value="'.$this->getVal($confValues, $key.'_'.$language['id_lang']).'" />
						</div>';
					displayFlags($languages, $defaultLanguage, $divLangName, $key);
					break;
					
				case 'file':
					if (isset($field['thumb']) AND $field['thumb'] AND $field['thumb']['pos'] == 'before')
						echo '<img src="'.$field['thumb']['file'].'" alt="'.$field['title'].'" title="'.$field['title'].'" /><br />';
					echo '<input type="file" name="'.$key.'" />';
					break;

				case 'text':
				default:
					echo '<input type="'.$field['type'].'" size="'.(isset($field['size']) ? intval($field['size']) : 5).'" name="'.$key.'" value="'.($field['type'] == 'password' ? '' : $val).'" />'.(isset($field['next']) ? '&nbsp;'.strval($field['next']) : '');
			}
			echo ((isset($field['required']) AND $field['required'] AND !in_array($field['type'], array('image', 'radio')))  ? ' <sup>*</sup>' : '');
			echo (isset($field['desc']) ? '<p style="clear:both">'.((isset($field['thumb']) AND $field['thumb'] AND $field['thumb']['pos'] == 'after') ? '<img src="'.$field['thumb']['file'].'" alt="'.$field['title'].'" title="'.$field['title'].'" style="float:left;" />' : '' ).$field['desc'].'</p>' : '');
			if (!in_array($field['type'], array('image', 'radio')) OR isset($field['show']))
				echo '</div></div>';
		}
		
		/* End of specific div for e-mails settings */
		if (get_class($this) == 'Adminemails')
			echo '<script type="text/javascript">if (getE(\'PS_MAIL_METHOD2_on\').checked) getE(\'smtp\').style.display = \'block\'; else getE(\'smtp\').style.display = \'none\';</script></div>';

		echo '	<div align="center" style="margin-top: 20px;">
					<input type="submit" value="'.$this->l('   Save   ', 'AdminPreferences').'" name="submit'.ucfirst($name).$this->table.'" class="button" />
				</div>
				'.($required ? '<div class="small"><sup>*</sup> '.$this->l('Required fields', 'AdminPreferences').'</div>' : '').'
			</fieldset>
		</form>';
	}
}

?>
