<?php

/**
  * Price ranges tab for admin panel, AdminRangePrice.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminRangePrice extends AdminTab
{
	public function __construct()
	{
	 	$this->table = 'range_price';
	 	$this->className = 'RangePrice';
	 	$this->lang = false;
	 	$this->edit = true;
				
		$this->fieldsDisplay = array(
		'id_range_price' => array('title' => $this->l('ID'), 'align' => 'center', 'width' => 25),
		'delimiter1' => array('title' => $this->l('From'), 'width' => 86, 'price' => true, 'align' => 'right'),
		'delimiter2' => array('title' => $this->l('To'), 'width' => 86, 'price' => true, 'align' => 'right'));
	
		parent::__construct();
	}
	
	public function postProcess()
	{
		if (isset($_POST['submitAdd'.$this->table]) AND Tools::getValue('delimiter1') >= Tools::getValue('delimiter2'))
			$this->_errors[] = Tools::displayError('invalid range');
		else
			parent::postProcess();
	}
	
	public function displayForm()
	{
		global $currentIndex;
		
		$obj = $this->loadObject(true);
		$currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));

		echo '
		<form action="'.$currentIndex.'&submitAdd'.$this->table.'=1" method="post" class="width2">
		'.($obj->id ? '<input type="hidden" name="id_'.$this->table.'" value="'.$obj->id.'" />' : '').'
			<fieldset><legend><img src="../img/admin/dollar.gif" />'.$this->l('Prices ranges').'</legend>
				<label>'.$this->l('From:').' </label>
				<div class="margin-form">
					'.($currency->format == 1 ? $currency->sign.' ' : '').'<input type="text" size="4" name="delimiter1" value="'.$this->getFieldValue($obj, 'delimiter1').'" />'.($currency->format == 2 ? ' '.$currency->sign : '').'<sup>*</sup>
					<p style="clear: both;">'.$this->l('Range start').'</p>
				</div>
				<label>'.$this->l('To:').' </label>
				<div class="margin-form">
					'.($currency->format == 1 ? $currency->sign.' ' : '').'<input type="text" size="4" name="delimiter2" value="'.$this->getFieldValue($obj, 'delimiter2').'" />'.($currency->format == 2 ? ' '.$currency->sign : '').'<sup>*</sup>
					<p style="clear: both;">'.$this->l('Range end').'</p>
				</div>
				<div class="margin-form">
					<input type="submit" value="'.$this->l('   Save   ').'" name="submitAdd'.$this->table.'" class="button" />
				</div>
				<div class="small"><sup>*</sup> '.$this->l('Required fields').'</div>
			</fieldset>
		</form>';
	}
}

?>