<?php

/**
  * Translations tab for admin panel, AdminTranslations.php
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

include_once(dirname(__FILE__).'/../../classes/AdminTab.php');

class AdminTranslations extends AdminTab
{
	private function _fullCopy($source, $dest)
    {
        if (is_dir($source))
        {
            if (!file_exists($dest) AND !mkdir($dest))
				return false;
            $d = dir($source);
            while (false !== ($entry = $d->read()))
            {
                if ($entry{0} == '.')
                    continue;

                $realEntry = $source.'/'.$entry;
                if (is_dir($realEntry))
                {
                    $this->_fullCopy($realEntry, $dest.'/'.$entry);
                    continue;
                }
                copy($realEntry, $dest.'/'.$entry);
            }
			$d->close();
			return true;
        }
		else
            copy($source, $dest);
    }

	private function getModuleTranslations()
	{
		global $_MODULES, $_MODULE;

		if (!isset($_MODULE) AND !isset($_MODULES))
			$_MODULES = array();
		elseif (isset($_MODULE))
			$_MODULES = (is_array($_MODULES) AND is_array($_MODULE)) ? array_merge($_MODULES, $_MODULE) : $_MODULE;
	}

	public function postProcess()
	{
		global $currentIndex;
	
		if (Tools::isSubmit('submitCopyLang'))
		{
		 	if ($this->tabAccess['add'] === '1')
			{
				if (!($from = intval(Tools::getValue('from'))) OR !($to = intval(Tools::getValue('to'))))
					$this->_errors[] = $this->l('you must select 2 languages in order to copy data from one to another');
				elseif ($from == $to)
					$this->_errors[] = $this->l('you cannot copy data from a language to itself');
				elseif (!Language::copyLanguageData($from, $to))
					$this->_errors[] = $this->l('an error occurred while copying data');
				else
				{
					$fromIso = Language::getIsoById($from);
					$toIso = Language::getIsoById($to);
					if (!file_exists(_PS_TRANSLATIONS_DIR_.$toIso))
						if (!mkdir(_PS_TRANSLATIONS_DIR_.$toIso, 0777))
							$this->_errors[] = $this->l('Cannot create the language folder. Check the "translations"\' directory writing permision.');
					$bool = @copy(_PS_TRANSLATIONS_DIR_.$fromIso.'/admin.php', _PS_TRANSLATIONS_DIR_.$toIso.'/admin.php');
					$bool &= @copy(_PS_TRANSLATIONS_DIR_.$fromIso.'/errors.php', _PS_TRANSLATIONS_DIR_.$toIso.'/errors.php');
					$bool &= @copy(_PS_TRANSLATIONS_DIR_.$fromIso.'/fields.php', _PS_TRANSLATIONS_DIR_.$toIso.'/fields.php');
					$bool &= @copy(_PS_THEME_DIR_.'lang/'.$fromIso.'.php', _PS_THEME_DIR_.'lang/'.$toIso.'.php');
					$modules = Module::getModulesDirOnDisk();
					foreach ($modules as $module)
					{
						$dir = _PS_TRANSLATIONS_DIR_.'../modules/'.$module.'/';
						if (file_exists($dir.$fromIso.'.php'))
							$bool &= @copy($dir.$fromIso.'.php', $dir.$toIso.'.php');
					}
					$bool &= $this->_fullCopy(_PS_MAIL_DIR_.$fromIso, _PS_MAIL_DIR_.$toIso);
					if ($bool)
						Tools::redirectLink($currentIndex.'&conf=14');
					$this->_errors[] = $this->l('a part of the data have been copied but some language files couldn\'t have been found or copied');
				}
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to add something here.');
		}
		elseif (Tools::isSubmit('submitExport'))
		{
			$lang = strtolower(Tools::getValue('iso_code'));
			$theme = strval(Tools::getValue('theme'));
			$modules = Module::getModulesDirOnDisk();
			if ($lang AND $theme AND count($modules))
			{
				// making files list
				$pack = array(
					_PS_TRANSLATIONS_DIR_.$lang.'/'.'errors.php',
					_PS_TRANSLATIONS_DIR_.$lang.'/'.'fields.php',
					_PS_TRANSLATIONS_DIR_.$lang.'/'.'admin.php',
					_PS_ALL_THEMES_DIR_.$theme.'/lang/'.$lang.'.php');
				foreach ($modules as $module)
					if (file_exists($file = _PS_MODULE_DIR_.$module.'/'.$lang.'.php'))
						$pack[] = $file;
				// creating gzip files
				$gz = new Archive_Tar(_PS_TRANSLATIONS_DIR_.'/export/'.$lang.'.gzip', true);
				if ($gz->createModify($pack, null, _PS_ROOT_DIR_));
					Tools::redirect(_PS_TRANSLATIONS_DIR_.'/export/'.$lang.'.gzip');
				$this->_errors[] = Tools::displayError('an error occurred while creating archive');
			}
			$this->_errors[] = Tools::displayError('please choose a language, a theme and modules');
		}
		elseif (Tools::isSubmit('submitImport') AND ($lang = strtolower(Tools::getValue('iso_code'))))
		{
		 	if ($this->tabAccess['add'] === '1')
			{
				if (!isset($_FILES['file']['tmp_name']) OR !$_FILES['file']['tmp_name'])
					$this->_errors[] = Tools::displayError('no file selected');
				else
				{
					if (!file_exists(_PS_TRANSLATIONS_DIR_.$lang))
						mkdir(_PS_TRANSLATIONS_DIR_.$lang);
					$gz = new Archive_Tar($_FILES['file']['tmp_name'], true);
					if ($gz->extract(_PS_TRANSLATIONS_DIR_.'../'))
						Tools::redirectAdmin($currentIndex.'&conf=15');
					$this->_errors[] = Tools::displayError('archive cannot be extracted');
				}
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to add something here.');
		}
		elseif (Tools::isSubmit('submitTranslationsFront'))
		{
			if ($this->tabAccess['edit'] === '1')
			{
				if ($fd = fopen(_PS_THEME_DIR_.'lang/'.strtolower(Tools::getValue('lang')).'.php', 'w'))
				{
					unset($_POST['submitTranslationsFront']);
					unset($_POST['lang']);
					$toInsert = array();
					foreach($_POST as $key => $value)
						if (!empty($value))
							$toInsert[$key] = pSQL($value);
					fwrite($fd, "<?php\n\nglobal \$_LANG;\n\$_LANG = array();\n");
					foreach($toInsert as $key => $value)
						fwrite($fd, '$_LANG[\''.$key.'\'] = \''.$value.'\';'."\n");
					fwrite($fd, "\n?>");
					fclose($fd);
					Tools::redirectAdmin($currentIndex.'&conf=4');
				}
				else
					die('Cannot write language file');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (Tools::isSubmit('submitTranslationsBack'))
		{
		 	if ($this->tabAccess['edit'] === '1')
		 	{
				if ($fd = fopen(_PS_TRANSLATIONS_DIR_.strtolower(Tools::getValue('lang')).'/admin.php', 'w'))
				{
					unset($_POST['submitTranslationsBack']);
					unset($_POST['lang']);
					$toInsert = array();
					foreach($_POST as $key => $value)
						if (!empty($value))
							$toInsert[$key] = pSQL($value);
					fwrite($fd, "<?php\n\nglobal \$_LANGADM;\n\$_LANGADM = array();\n");
					foreach($toInsert as $key => $value)
						fwrite($fd, '$_LANGADM[\''.$key.'\'] = \''.$value.'\';'."\n");
					fwrite($fd, "\n?>");
					fclose($fd);
					Tools::redirectAdmin($currentIndex.'&conf=4');
				}
				else
					die('Cannot write language file');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (Tools::isSubmit('submitTranslationsErrors'))
		{
		 	if ($this->tabAccess['edit'] === '1')
		 	{
				if ($fd = fopen(_PS_TRANSLATIONS_DIR_.strtolower(Tools::getValue('lang')).'/errors.php', 'w'))
				{
					unset($_POST['submitTranslationsErrors']);
					unset($_POST['lang']);
					$toInsert = array();
					foreach($_POST as $key => $value)
						if (!empty($value))
							$toInsert[$key] = pSQL($value);
					fwrite($fd, "<?php\n\nglobal \$_ERRORS;\n\$_ERRORS = array();\n");
					foreach($toInsert as $key => $value)
						fwrite($fd, '$_ERRORS[\''.$key.'\'] = \''.$value.'\';'."\n");
					fwrite($fd, "\n?>");
					fclose($fd);
					Tools::redirectAdmin($currentIndex.'&conf=4');
				}
				else
					die('Cannot write language file');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (Tools::isSubmit('submitTranslationsFields'))
		{
		 	if ($this->tabAccess['edit'] === '1')
		 	{
				if ($fd = fopen(_PS_TRANSLATIONS_DIR_.strtolower(Tools::getValue('lang')).'/fields.php', 'w'))
				{
					unset($_POST['submitTranslationsFields']);
					unset($_POST['lang']);
					$toInsert = array();
					foreach($_POST as $key => $value)
						if (!empty($value))
							$toInsert[$key] = pSQL($value);
					fwrite($fd, "<?php\n\nglobal \$_FIELDS;\n\$_FIELDS = array();\n");
					foreach($toInsert as $key => $value)
						fwrite($fd, '$_FIELDS[\''.$key.'\'] = \''.$value.'\';'."\n");
					fwrite($fd, "\n?>");
					fclose($fd);
					Tools::redirectAdmin($currentIndex.'&conf=4');
				}
				else
					die('Cannot write language file');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
		elseif (Tools::isSubmit('submitTranslationsModules'))
		{
			if ($this->tabAccess['edit'] === '1')
			{
				$lang = strtolower($_POST['lang']);
				unset($_POST['submitTranslationsModules']);
				unset($_POST['lang']);
				$toInsert = array();
				
				foreach($_POST as $key => $value)
					if (!empty($value))
					{
						preg_match('(<\{(.*)\}(.*)>)', $key, $match);
						$toInsert[$match[2]][$match[1]][$key] = pSQL($value);
					}

				foreach($toInsert as $themeName => $theme)
				{
					if ($themeName == 'default')
						$translationsDir = _PS_MODULE_DIR_;
					else
						$translationsDir = _PS_ALL_THEMES_DIR_.$themeName.'/modules/';
					foreach ($theme AS $module => $files)
						if (!$fd = @fopen($translationsDir.$module.'/'.$lang.'.php', 'w'))
							die ($this->l('Cannot write the theme\'s language file ').'('.$translationsDir.$module.'/'.$lang.'.php)'.$this->l('. Please check writing permissions.'));
						else
						{
							fwrite($fd, "<?php\n\nglobal \$_MODULE;\n\$_MODULE = array();\n");
							foreach ($files AS $key => $value)
								fwrite($fd, '$_MODULE[\''.$key.'\'] = \''.$value.'\';'."\n");
							fwrite($fd, "\n?>");
							fclose($fd);
						}
				}
				Tools::redirectAdmin($currentIndex.'&conf=4');
			}
			else
				$this->_errors[] = Tools::displayError('You do not have permission to edit something here.');
		}
	}
	
	public function display()
	{
		global $currentIndex;
		
		if ($type = Tools::getValue('type'))
			$this->{'displayForm'.$type}();
		else
		{
			$languages = Language::getLanguages();
			echo '<fieldset class="width2"><legend><img src="../img/admin/translation.gif" />'.$this->l('Modify Translations').'</legend>'.
			$this->l('Select a language database to view or modify by clicking on the corresponding flag').'.<br /><br />';
			
			echo '<h3>'.$this->l('Front Office translations').'</h3>';
			foreach ($languages as $language)
				echo '	<a href="'.$currentIndex.'&lang='.$language['iso_code'].'&type=front" >
							<img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" />
						</a> ';
			echo '<br /><br />';
			echo '<h3>'.$this->l('Back Office translations').'</h3>';
			foreach ($languages as $language)
				echo '	<a href="'.$currentIndex.'&lang='.$language['iso_code'].'&type=back" >
							<img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" />
						</a> ';
			echo '<br /><br />';
			echo '<h3>'.$this->l('Errors translations').'</h3>';
			foreach ($languages as $language)
				echo '	<a href="'.$currentIndex.'&lang='.$language['iso_code'].'&type=errors" >
							<img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" />
						</a> ';
			echo '<br /><br />';
			echo '<h3>'.$this->l('Fields translations').'</h3>';
			foreach ($languages as $language)
				echo '	<a href="'.$currentIndex.'&lang='.$language['iso_code'].'&type=fields" >
							<img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" />
						</a> ';
			echo '<br /><br />';
			echo '<h3>'.$this->l('Module translations').'</h3>';
			foreach ($languages as $language)
				echo '	<a href="'.$currentIndex.'&lang='.$language['iso_code'].'&type=modules" >
							<img src="'._THEME_LANG_DIR_.$language['id_lang'].'.jpg" alt="'.$language['iso_code'].'" title="'.$language['iso_code'].'" />
						</a>';

			echo '</fieldset>
			<br /><br /><h2>'.$this->l('Translations exchange').'</h2>
			<fieldset class="width2"><legend><img src="../img/admin/import.gif" />'.$this->l('Import a language pack').'</legend>
			<form action="'.$currentIndex.'" method="post" enctype="multipart/form-data">
				<p>'.$this->l('Import data from file (language pack).').'<br />
				'.$this->l('Browse your computer for the language file to be imported:').'</p>
				<p><input type="file" name="file" />&nbsp;&nbsp;
				<input type="submit" class="button" name="submitImport" value="'.$this->l('Import').'" /></p>
			</form>
			</fieldset>
			<br /><br />
			<fieldset class="width2"><legend><img src="../img/admin/export.gif" />'.$this->l('Export a language').'</legend>
			<form action="'.$currentIndex.'" method="post" enctype="multipart/form-data">
				<p>'.$this->l('Export data from one language to a file (language pack).').'<br />'.
				$this->l('Choose the theme from which you want to export translations.').'<br />
				<select name="iso_code" style="margin-top:10px;">';
			foreach ($languages as $language)
				echo '<option value="'.$language['iso_code'].'">'.$language['name'].'</option>';
			echo '
				</select>
				&nbsp;&nbsp;&nbsp;
				<select name="theme" style="margin-top:10px;">';
			$themes = self::getThemesList();
			foreach ($themes as $theme)
				echo '<option value="'.$theme['name'].'">'.$theme['name'].'</option>';
			echo '
				</select>&nbsp;&nbsp;
				<input type="submit" class="button" name="submitExport" value="'.$this->l('Export').'" />
			</form>
		</fieldset>
		<br /><br />
		<form action="'.$currentIndex.'" method="post">
			<fieldset class="width2"><legend><img src="../img/admin/copy_files.gif" />'.$this->l('Copy').'</legend>
				<p>'.$this->l('Copies data from one language to another one.').'<br />'.
				$this->l('Be careful, as it will replace all existing data for the destination language!').'<br />'.
				$this->l('If necessary').', <b><a href="index.php?tab=AdminLanguages&addlang">'.$this->l('first create a new language').'</a></b>.</p>
				<div style="float:left;">
					<p>
						<div style="width:75px; font-weight:bold; float:left;">'.$this->l('From:').'</div>
						<select name="from">
							<option value="0">-- '.$this->l('Choose').' --&nbsp;&nbsp;&nbsp;</option>';
				foreach	($languages AS $language)
					echo '<option value="'.$language['id_lang'].'">'.$language['name'].'</option>';
				echo '
						</select>
					</p>
					<p>
						<div style="width:75px; font-weight:bold; float:left;">'.$this->l('To:').'</div>
						<select name="to">
							<option value="0">-- '.$this->l('Choose').' --&nbsp;&nbsp;&nbsp;</option>';
				foreach	($languages AS $language)
					echo '<option value="'.$language['id_lang'].'">'.$language['name'].'</option>';
				echo '
						</select>
					</p>
				</div>
				<div style="float:left;">
					<input type="submit" value="'.$this->l('   Copy   ').'" name="submitCopyLang" class="button" style="margin:25px 0px 0px 25px;" />
				</div>
			</fieldset>
		</form>';
		}
	}
	
	function displayFormfront()
	{
		global $currentIndex;
		
		$lang = Tools::getValue('lang');
		$_LANG = array();
		
		if (!file_exists(_PS_THEME_DIR_.'lang'))
			if (!mkdir(_PS_THEME_DIR_.'lang', 0700))
				die('Please create a "lang" directory in '._PS_THEME_DIR_);
		if (!file_exists(_PS_THEME_DIR_.'lang/'.strtolower($lang).'.php'))
			if (!file_put_contents(_PS_THEME_DIR_.'lang/'.strtolower($lang).'.php', "<?php\n\nglobal \$_LANG;\n\$_LANG = array();\n\n?>"))
				die('Please create a "'.strtolower($lang).'.php" file in '._PS_THEME_DIR_.'lang/');
		if (!is_writable(_PS_THEME_DIR_.'lang/'.strtolower($lang).'.php'))
			$this->displayWarning(Tools::displayError('This file has to be writable:').' '._PS_THEME_DIR_.'lang/'.strtolower($lang).'.php');
		include(_PS_THEME_DIR_.'lang/'.strtolower($lang).'.php');
		$files = array();
		
		/* List templates to parse */
		$templates = scandir(_PS_THEME_DIR_);
		$count = 0;
		foreach ($templates AS $template)
			if (ereg('^(.*).tpl$', $template) AND file_exists($tpl = _PS_THEME_DIR_.$template))
			{
				$template = substr(basename($template), 0, -4);
				$newLang = array();
				$fd = fopen($tpl, 'r');
				$content = fread($fd, filesize($tpl));
				
				/* Search language tags (eg {l s='to translate'}) */
				$regex = '/\{l s=\'(.+)\'( js=1)?\}/U';
				preg_match_all($regex, $content, $matches);
				
				/* Get string translation */
				foreach($matches[1] as $key)
				{
					$key2 = $template.'_'.md5($key);
					$newLang[$key] = (key_exists($key2, $_LANG)) ? $_LANG[$key2] : '';
				}
				$files[$template] = $newLang;
				$count += sizeof($newLang);
			}
		
		echo '
		<h2>'.$this->l('Language').' : '.strtoupper($lang).'</h2>
		'.$this->l('Total expressions').' : <b>'.$count.'</b>. '.$this->l('Click the fieldset title to expand or close the fieldset.').'.<br /><br />
		<form method="post" action="'.$currentIndex.'&submitTranslationsFront=1" class="form">
		<script language="javascript">
			var openAll = \''.$this->l('Expand all fieldsets').'\';
			var closeAll = \''.$this->l('Close all fieldsets').'\';
		</script>
		<input type="hidden" name="lang" value="'.$lang.'" />
		<input type="button" class="button" id="buttonall" onclick="openCloseAllDiv(\'front_div\', this.value == openAll); toggleElemValue(this.id, openAll, closeAll);" />
		<script language="javascript">
			toggleElemValue(\'buttonall\', openAll, closeAll);
		</script>';
		echo '<input type="submit" name="submitTranslationsFront" value="'.$this->l('Update translations').'" class="button" /><br /><br />';
		foreach ($files as $k => $newLang)
			if (sizeof($newLang))
			{
				$countValues = array_count_values($newLang);
				$empty = isset($countValues['']) ? $countValues[''] : 0;
			 	echo '
				<fieldset class="width3"><legend style="cursor : pointer" onclick="openCloseLayer(\''.$k.'\')">'.$k.' - <font color="blue">'.sizeof($newLang).'</font> '.$this->l('expressions').' (<font color="red">'.$empty.'</font>)</legend>
					<div name="front_div" id="'.$k.'" style="display: '.($empty ? 'block' : 'none').';"> 
						<table cellpadding="2">';
				foreach ($newLang as $key => $value)
					echo '<tr><td>'.stripslashes($key).'</td><td style="width: 380px">= <input type="text" name="'.$k.'_'.md5($key).'" value="'.stripslashes(preg_replace('/"/', '\&quot;', stripslashes($value))).'" style="width: 350px"></td></tr>';
				echo '
						</table>
					</div>
				</fieldset><br />';
			}
		echo '<br /><input type="submit" name="submitTranslationsFront" value="'.$this->l('Update translations').'" class="button" /></form>';
	}
	
	function displayFormback()
	{
		global $currentIndex;
		
		$lang = strtolower(Tools::getValue('lang'));
		$_LANG = array();
		
		if (!file_exists(_PS_TRANSLATIONS_DIR_.$lang))
			if (!mkdir(_PS_TRANSLATIONS_DIR_.$lang, 0700))
				die('Please create a "'.$iso.'" directory in '._PS_TRANSLATIONS_DIR_);
		if (!file_exists(_PS_TRANSLATIONS_DIR_.$lang.'/admin.php'))
			if (!file_put_contents(_PS_TRANSLATIONS_DIR_.$lang.'/admin.php', "<?php\n\nglobal \$_LANGADM;\n\$_LANGADM = array();\n\n?>"))
				die('Please create a "'.strtolower($lang).'.php" file in '.realpath(dirname(__FILE__).'/../'));
		unset($_LANGADM);
		include(_PS_TRANSLATIONS_DIR_.$lang.'/admin.php');
		$files = array();
		
		/* List templates to parse */
		$count = 0;
		$tabs = scandir(dirname(__FILE__));
		$tabs[] = '../../classes/AdminTab.php';
		foreach ($tabs AS $tab)
			if (ereg('^(.*)\.php$', $tab) AND file_exists($tpl = dirname(__FILE__).'/'.$tab))
			{
				$tab = basename(substr($tab, 0, -4));
				$newLang = array();
				$fd = fopen($tpl, 'r');
				$content = fread($fd, filesize($tpl));
				fclose($fd);
				$regex = '/this->l\(\'(.+)\'[\)|\,]/U';
				preg_match_all($regex, $content, $matches);
				foreach($matches[1] as $key)
					$tabsArray[$tab][$key] = stripslashes(key_exists($tab.md5($key), $_LANGADM) ? $_LANGADM[$tab.md5($key)] : '');
				$count += isset($tabsArray[$tab]) ? sizeof($tabsArray[$tab]) : 0;
			}

		echo '
		<h2>'.$this->l('Language').' : '.strtoupper($lang).'</h2>
		'.$this->l('Expressions to translate').' : <b>'.$count.'</b>. '.$this->l('Click on the titles to open fieldsets').'.<br /><br />
		<form method="post" action="'.$currentIndex.'&submitTranslationsBack=1" class="form">
				<script language="javascript">
					var openAll = \''.$this->l('Expand all fieldsets').'\';
					var closeAll = \''.$this->l('Close all fieldsets').'\';
				</script>
				<input type="hidden" name="lang" value="'.$lang.'" />
				<input type="button" class="button" id="buttonall" onclick="openCloseAllDiv(\'back_div\', this.value == openAll); toggleElemValue(this.id, openAll, closeAll);" />
				<script language="javascript">
					toggleElemValue(\'buttonall\', openAll, closeAll);
				</script>';
		echo '<input type="submit" name="submitTranslationsBack" value="'.$this->l('Update translations').'" class="button" /><br /><br />';
		foreach ($tabsArray as $k => $newLang)
			if (sizeof($newLang))
			{
				$countValues = array_count_values($newLang);
				$empty = isset($countValues['']) ? $countValues[''] : 0;
			 	echo '
				<fieldset style="width: 700px"><legend style="cursor : pointer" onclick="openCloseLayer(\''.$k.'\')">'.$k.' - <font color="blue">'.sizeof($newLang).'</font> '.$this->l('expressions').' (<font color="red">'.$empty.'</font>)</legend>
					<div name="back_div" id="'.$k.'" style="display: '.($empty ? 'block' : 'none').';"> 
						<table cellpadding="2">';
				foreach ($newLang as $key => $value)
				{
					echo '
					<tr>
						<td>'.stripslashes($key).'</td>
						<td style="width: 280px">
							= <input type="text" name="'.$k.md5($key).'" value="'.stripslashes(preg_replace('/"/', '\&quot;', $value)).'" style="width: 250px">
						</td>
					</tr>';
				}
				echo '
						</table>
					</div>
				</fieldset><br />';
			}
		echo '<br /><input type="submit" name="submitTranslationsBack" value="'.$this->l('Update translations').'" class="button" /></form>';
	}
	
	function displayFormerrors()
	{
		global $currentIndex;

		$lang = Tools::getValue('lang');
		$_ERRORS = array();
		include(_PS_TRANSLATIONS_DIR_.$lang.'/errors.php');
		
		/* List files to parse */
		$stringToTranslate = array();
		$dirToParse = array(dirname(__FILE__).'/../../',
							dirname(__FILE__).'/../../classes/',
							dirname(__FILE__).'/../',
							dirname(__FILE__).'/../tabs/');
		foreach ($dirToParse AS $dir)
		{
			$files = scandir($dir);
			foreach ($files AS $file)
				if (ereg('.php$', $file) AND file_exists($fn = $dir.$file))
				{
					$fd = fopen($fn, 'r');
					$content = fread($fd, filesize($fn));
					$regex = '/Tools::displayError\(\'(.*)\'\)/U';
					preg_match_all($regex, $content, $matches);
					foreach($matches[1] as $key)
						$stringToTranslate[$key] = (key_exists(md5($key), $_ERRORS)) ? $_ERRORS[md5($key)] : '';
				}
		}
		
		$irow = 0;
		echo '<h2>'.$this->l('Language').' : '.strtoupper($lang).'</h2>'.$this->l('Errors to translate').' : <b>'.sizeof($stringToTranslate).'</b><br /><br />
		<form method="post" action="'.$currentIndex.'&submitTranslationsErrors=1&lang='.$lang.'" class="form">
		<input type="submit" name="submitTranslationsErrors" value="'.$this->l('Update translations').'" class="button" /><br /><br />
		<table cellpadding="0" cellspacing="0" class="table">';
		foreach ($stringToTranslate as $key => $value)
			echo '<tr '.(++$irow % 2 ? 'class="alt_row"' : '').'><td>'.stripslashes($key).'</td><td style="width: 430px">= <input type="text" name="'.md5($key).'" value="'.preg_replace('/"/', '\&quot;', stripslashes($value)).'" style="width: 400px"></td></tr>';
		echo '</table><br /><input type="submit" name="submitTranslationsErrors" value="'.$this->l('Update translations').'" class="button" /></form>';
	}
	
	function displayFormfields()
	{
		global $currentIndex;
		
		$lang = Tools::getValue('lang');
		$_FIELDS = array();
		@include(_PS_TRANSLATIONS_DIR_.$lang.'/fields.php');
		$classArray = array();
		$count = 0;
		foreach (scandir(_PS_CLASS_DIR_) AS $classFile)
		{
			if (!preg_match('/\.php$/', $classFile) || $classFile == 'index.php')
				continue;
			include_once(_PS_CLASS_DIR_.$classFile);
			$className = substr($classFile, 0, -4);
			if (!class_exists($className))
				continue;
			if (!is_subclass_of($className, 'ObjectModel'))
				continue;
			$classArray[$className] = call_user_func(array($className, 'getValidationRules'), $className);
			if (isset($classArray[$className]['validate']))
				$count += sizeof($classArray[$className]['validate']);
			if (isset($classArray[$className]['validateLang']))
				$count += sizeof($classArray[$className]['validateLang']);
		}
		
		
		echo '
		<h2>'.$this->l('Language').' : '.strtoupper($lang).'</h2>
		'.$this->l('Fields to translate').' : <b>'.$count.'</b>. '.$this->l('Click on the titles to open fieldsets').'.<br /><br />
		<form method="post" action="'.$currentIndex.'&submitTranslationsFields=1" class="form">
		<script language="javascript">
			var openAll = \''.$this->l('Expand all fieldsets').'\';
			var closeAll = \''.$this->l('Close all fieldsets').'\';
		</script>
		<input type="hidden" name="lang" value="'.$lang.'" />
		<input type="button" class="button" id="buttonall" onclick="openCloseAllDiv(\'fields_div\', this.value == openAll); toggleElemValue(this.id, openAll, closeAll);" />
		<script language="javascript">
			toggleElemValue(\'buttonall\', openAll, closeAll);
		</script>';
		echo '<input type="submit" name="submitTranslationsFields" value="'.$this->l('Update translations').'" class="button" /><br /><br />';
		foreach ($classArray AS $className => $rules)
		{
			$translated = 0;
			$toTranslate = 0;
			if (isset($rules['validate']))
				foreach ($rules['validate'] AS $key => $value)
					(array_key_exists($className.'_'.md5($key), $_FIELDS)) ? ++$translated : ++$toTranslate;
			if (isset($rules['validateLang']))
				foreach ($rules['validateLang'] AS $key => $value)
					(array_key_exists($className.'_'.md5($key), $_FIELDS)) ? ++$translated : ++$toTranslate;
			echo '
			<fieldset class="width3"><legend style="cursor : pointer" onclick="openCloseLayer(\''.$className.'\')">'.$className.' - <font color="blue">'.($toTranslate + $translated).'</font> '.$this->l('fields').' (<font color="red">'.$toTranslate.'</font>)</legend>
			<div name="fields_div" id="'.$className.'" style="display: '.($toTranslate ? 'block' : 'none').';"> 
				<table cellpadding="2">';
			if (isset($rules['validate']))
				foreach ($rules['validate'] AS $key => $value)
					echo '<tr><td>'.stripslashes($key).'</td><td style="width: 380px">= <input type="text" name="'.$className.'_'.md5($key).'" value="'.(array_key_exists($className.'_'.md5($key), $_FIELDS) ? $_FIELDS[$className.'_'.md5($key)] : '').'" style="width: 350px"></td></tr>';
			if (isset($rules['validateLang']))
				foreach ($rules['validateLang'] AS $key => $value)
					echo '<tr><td>'.stripslashes($key).'</td><td style="width: 380px">= <input type="text" name="'.$className.'_'.md5($key).'" value="'.(array_key_exists($className.'_'.md5($key), $_FIELDS) ? $_FIELDS[$className.'_'.md5($key)] : '').'" style="width: 350px"></td></tr>';
			echo '
				</table>
			</div>
			</fieldset><br />';
		}
		echo '<br /><input type="submit" name="submitTranslationsFields" value="'.$this->l('Update translations').'" class="button" /></form>';
	}

	function displayFormModules()
	{
		global $currentIndex, $_MODULES;
		
		$lang = Tools::getValue('lang');
		$_LANG = array();
		
		if (!file_exists(_PS_MODULE_DIR_))
			die('Fatal error: Module directory is not here ('._PS_MODULE_DIR_.') anymore !');
		if (!is_writable(_PS_MODULE_DIR_))
			$this->displayWarning(Tools::displayError('The module directory must be writable'));
		$modules = scandir(_PS_MODULE_DIR_);
		if ($modules == false)
			$this->displayWarning(Tools::displayError('There is no module in your PrestaShop. Use the module section to retieve them or go to our website to download some of them.'));
		else
		{
			$allfiles = array();
			$count = 0;

			foreach ($modules AS $module)
			{
				if ($module{0} != '.')
				{
					@include_once(_PS_MODULE_DIR_.$module.'/'.$lang.'.php');
					self::getModuleTranslations();

					$files = @scandir(_PS_MODULE_DIR_.$module.'/');
					if ($files)
						foreach ($files AS $file)
							if ((ereg('^(.*).tpl$', $file) OR ereg('^(.*).php$', $file)) AND file_exists($tpl = _PS_MODULE_DIR_.$module.'/'.$file))
							{
								$template = substr(basename($file), 0, -4);
								$newLang = array();
								$fd = fopen($tpl, 'r');
								$content = (filesize($tpl) ? fread($fd, filesize($tpl)) : '');

								/* Search language tags (eg {l s='to translate'}) */
								$regex = (substr($file, -4) == '.tpl' ? '/\{l s=\'(.+)\'( mod=\'.+\')?( js=1)?\}/U' : '/l\(\'(.+)\'(, \'(.+)\')?(, (.+))?\)/U');

								preg_match_all($regex, $content, $matches);

								/* Get string translation */
								foreach($matches[1] as $key)
								{
									$key2 = '<{'.$module.'}default>'.$template.'_'.md5($key);
									$newLang[$key] = (key_exists($key2, $_MODULES)) ? $_MODULES[$key2] : '';
								}
								$allfiles['default'][$module][$template] = isset($allfiles['default'][$module][$template]) ? array_merge($allfiles['default'][$module][$template], $newLang) : $newLang;
								$count += sizeof($newLang);
							}
				}
			}
			$themes = scandir(_PS_ALL_THEMES_DIR_);
			if ($themes)
				foreach ($themes AS $theme)
				{
					if ($theme{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme))
					{
						if (file_exists(_PS_ALL_THEMES_DIR_.$theme.'/modules/'))
						{
							$modules = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/');
							if ($modules)
								foreach ($modules AS $module)
								{
									if ($module{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module))
									{
										@include_once(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/'.$lang.'.php');
										self::getModuleTranslations();

										$files = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/');
										if ($files)
											foreach ($files AS $file)
												if (ereg('^(.*).tpl$', $file) AND file_exists($tpl = _PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/'.$file))
												{
													$template = basename($file, '.tpl');
													$newLang = array();
													$fd = fopen($tpl, 'r');
													$content = fread($fd, filesize($tpl));
													
													/* Search language tags (eg {l s='to translate'}) */
													$regex = '/\{l s=\'(.+)\'( mod=\'.+\')?( js=1)?\}/U';
													preg_match_all($regex, $content, $matches);
													
													/* Get string translation */
													foreach($matches[1] as $key)
													{
														$key2 = '<{'.$module.'}'.$theme.'>'.$template.'_'.md5($key);
														$newLang[$key] = (key_exists($key2, $_MODULES)) ? $_MODULES[$key2] : '';
													}
													$allfiles[$theme][$module][$template] = $newLang;
													$count += sizeof($newLang);
												}
									}
								}
						}
					}
				}

			echo '
			<h2>'.$this->l('Language').' : '.strtoupper($lang).'</h2>
			'.$this->l('Total expressions').' : <b>'.$count.'</b>. '.$this->l('Click the fieldset title to expand or close the fieldset.').'.<br /><br />
			<form method="post" action="'.$currentIndex.'&submitTranslationsModules=1" class="form">
				<script language="javascript">
					var openAll = \''.$this->l('Expand all fieldsets').'\';
					var closeAll = \''.$this->l('Close all fieldsets').'\';
				</script>
				<input type="hidden" name="lang" value="'.$lang.'" />
				<input type="button" class="button" id="buttonall" onclick="openCloseAllDiv(\'module_div\', this.value == openAll); toggleElemValue(this.id, openAll, closeAll);" />
				<script language="javascript">
					toggleElemValue(\'buttonall\', openAll, closeAll);
				</script>';
				echo '<input type="submit" name="submitTranslationsModules" value="'.$this->l('Update translations').'" class="button" /><br /><br />';
				foreach ($allfiles AS $theme_name => $theme)
					foreach ($theme AS $module_name => $module)
						foreach ($module AS $template_name => $newLang)
							if (sizeof($newLang))
							{
								$countValues = array_count_values($newLang);
								$empty = isset($countValues['']) ? $countValues[''] : 0;
								echo '
								<fieldset class="width3"><legend style="cursor : pointer" onclick="openCloseLayer(\''.$theme_name.'_'.$module_name.'_'.$template_name.'\')">'.$theme_name.' - '.$template_name.' - <font color="blue">'.sizeof($newLang).'</font> '.$this->l('expressions').' (<font color="red">'.$empty.'</font>)</legend>
									<div name="module_div" id="'.$theme_name.'_'.$module_name.'_'.$template_name.'" style="display: '.($empty ? 'block' : 'none').';"> 
										<table cellpadding="2">';
								foreach ($newLang as $key => $value)
									echo '<tr><td>'.stripslashes($key).'</td><td style="width: 380px">= <input type="text" name="<{'.$module_name.'}'.$theme_name.'>'.$template_name.'_'.md5($key).'" value="'.stripslashes(preg_replace('/"/', '\&quot;', stripslashes($value))).'" style="width: 350px" /></td></tr>';
								echo '
										</table>
									</div>
								</fieldset><br />';
							}
			echo '<br /><input type="submit" name="submitTranslationsModules" value="'.$this->l('Update translations').'" class="button" /></form>';

		}
	}

	/**
	  * Return an array with themes and thumbnails
	  *
	  * @return array
	  */
	static public function getThemesList()
	{
		$dir = opendir(_PS_ALL_THEMES_DIR_);
		while ($folder = readdir($dir))
			if ($folder != '.' AND $folder != '..' AND file_exists(_PS_ALL_THEMES_DIR_.'/'.$folder.'/preview.jpg'))
				$themes[$folder]['name'] = $folder;
		closedir($dir);
		return isset($themes) ? $themes : array();
	}
}
?>