<?php

/**
  * Toolbar bar for admin panel
  * @category admin
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */
  
function recursiveTab($id_tab)
{
	global $cookie, $tabs;
	
	$adminTab = Tab::getTab(intval($cookie->id_lang), $id_tab);
	$tabs[]= $adminTab;
	if ($adminTab['id_parent'])
		recursiveTab($adminTab['id_parent']);
}

function checkingTab($tab)
{
	global $adminObj;
	
	include(dirname(__FILE__).'/tabs/'.$tab.'.php');
	$id_tab = Tab::getIdFromClassName($tab);
	if (!class_exists($tab, false) || !$id_tab)
	{
		echo Tools::displayError('Tab does not exist');
		return false;
	}
	$adminObj = new $tab;
	if (!$adminObj->viewAccess())
	{
		echo Tools::displayError('access denied');
		return false;
	}
	return ($id_tab);
}
?>