<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

$errors = array();

if ($cookie->isLogged())
    Tools::redirect('my-account.php');

if (isset($_GET['back']))
	$smarty->assign('back', Tools::safeOutput($_GET['back']));
elseif (isset($_POST['back']))
	$smarty->assign('back', Tools::safeOutput($_POST['back']));

if (isset($_POST['SubmitCreate']) OR isset($_POST['SubmitCreate_x']) OR isset($_POST['SubmitCreate_y']))
{
    if (!Validate::isemail($email = Tools::getValue('email_create')))
        $errors[] = Tools::displayError('invalid e-mail address');
	elseif (Customer::customerExists($email))
		$errors[] = Tools::displayError('someone has already registered with this e-mail');	
    else
    {
        $create_account = 1;
        $smarty->assign('email_create', Tools::safeOutput($email));
		$_POST['email'] = $email;
    }
}

if (Tools::isSubmit('submitAccount'))
{
    $create_account = 1;
    $smarty->assign('email_create', 1);
	
	if (!Validate::isemail($email = Tools::getValue('email')))
		$errors[] = Tools::displayError('e-mail not valid');	
	elseif (!Validate::isPasswd(Tools::getValue('passwd')))
		$errors[] = Tools::displayError('invalid password');	
	elseif (Customer::customerExists($email))
		$errors[] = Tools::displayError('someone has already registered with this e-mail');	
	elseif (!@checkdate(Tools::getValue('months'), Tools::getValue('days'), Tools::getValue('years')) AND !(Tools::getValue('months') == '' AND Tools::getValue('days') == '' AND Tools::getValue('years') == ''))
		$errors[] = Tools::displayError('invalid birthday');
	else
	{
		$customer = new Customer();
		$customer->birthday = (empty($_POST['years']) ? '' : intval($_POST['years']).'-'.intval($_POST['months']).'-'.intval($_POST['days']));
		
		/* Customer and address, same fields, caching data */
		$addrName = isset($_POST['name']) ? $_POST['name'] : $_POST['customer_name'];
		$addrSurname = isset( $_POST['surname']) ?  $_POST['surname'] : $_POST['customer_surname'];
		$_POST['name'] = $_POST['customer_name'];
		$_POST['surname'] = $_POST['customer_surname'];
		$errors = $customer->validateControler();		
		$_POST['name'] = $addrName;
		$_POST['surname'] = $addrSurname;
		$address = new Address();
		$address->id_customer = 1;
		$errors = array_merge($errors, $address->validateControler());
		
		if (!sizeof($errors))
		{
			$customer->active = 1;
			if (!$customer->add())
				$errors[] = Tools::displayError('an error occurred while creating your account');
			else
			{
				$address->id_customer = $customer->id;
				if (!$address->add())
					$errors[] = Tools::displayError('an error occurred while creating your address');
				else
				{
					if (Mail::Send(intval($cookie->id_lang), 'account', 'Welcome!', 
					array('{surname}' => $customer->surname, '{name}' => $customer->name, '{email}' => $customer->email, '{passwd}' => Tools::getValue('passwd')), $customer->email, $customer->surname.' '.$customer->name))
						$smarty->assign('confirmation', 1);
		            $cookie->id_customer = $customer->id;
		            $cookie->customer_name = $customer->name;
					$cookie->customer_surname = $customer->surname;
		            $cookie->passwd = $customer->passwd;
		            $cookie->logged = 1;
		            $cookie->email = $customer->email;
					$customer->addConnection();
					Module::hookExec('authentication');
		            if ($back = Tools::getValue('back'))
		                Tools::redirect($back);
				}
			}
		}
    }   
}

if (Tools::isSubmit('SubmitLogin'))
{
	$passwd = trim(Tools::getValue('passwd'));
	$email = trim(Tools::getValue('email'));
	if (empty($email))
        $errors[] = Tools::displayError('e-mail address is required');
    elseif (!Validate::isemail($email))
        $errors[] = Tools::displayError('invalid e-mail address');
    elseif (empty($passwd))
        $errors[] = Tools::displayError('password is required');
    elseif (strlen($passwd) > 32)
    	$errors[] = Tools::displayError('password is too long');
    elseif (!Validate::isPasswd($passwd))
    	$errors[] = Tools::displayError('invalid password');
	else
    {
        $customer = new Customer();
        $authentication = $customer->getByemail(trim($email), trim($passwd));
		/* Handle brute force attacks */
        sleep(1);
        if (!$authentication OR !$customer->id)
            $errors[] = Tools::displayError('authentication failed');
        else
        {
            $cookie->id_customer = $customer->id;
            $cookie->customer_name = $customer->name;
			$cookie->customer_surname = $customer->surname;
            $cookie->logged = 1;
            $cookie->passwd = $customer->passwd;
            $cookie->email = $customer->email;
            if (Configuration::get('PS_CART_FOLLOWING') AND (empty($cookie->id_cart) OR Cart::getNbProducts($cookie->id_cart)) == 0)
            	$cookie->id_cart = Cart::lastNoneOrderedCart($customer->id);
			$customer->addConnection();
			Module::hookExec('authentication');
			if ($back = Tools::getValue('back'))
				Tools::redirect($back);
			Tools::redirect('my-account.php');
        }
    }
}

if (isset($create_account))
{
	// Years, months and days
	if (isset($_POST['years']) AND is_numeric($_POST['years']))
		$selectedYears = intval($_POST['years']);
	$years = Tools::dateYears();
	if (isset($_POST['months']) AND is_numeric($_POST['months']))
		$selectedMonths = intval($_POST['months']);
	$months = Tools::dateMonths();
	if (isset($_POST['days']) AND is_numeric($_POST['days']))
		$selectedDays = intval($_POST['days']);
	$days = Tools::dateDays();
	
	// Country
	if (isset($_POST['id_country']) AND is_numeric($_POST['id_country']))
		$selectedCountry = intval($_POST['id_country']);
	elseif (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
	{
		$array = split(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		if (Validate::isLanguageIsoCode($array[0]))
		{
			$selectedCountry = Country::getByIso($array[0]);
			if (!$selectedCountry)
				$selectedCountry = intval(Configuration::get('PS_COUNTRY_DEFAULT'));
		}
	}
	if (!isset($selectedCountry))
		$selectedCountry = intval(Configuration::get('PS_COUNTRY_DEFAULT'));
	$countries = Country::getCountries(intval($cookie->id_lang), true);
	
	// Smarty assign
	$smarty->assign('years', $years);
	$smarty->assign('sl_year', (isset($selectedYears) ? $selectedYears : 0));
	$smarty->assign('months', $months);
	$smarty->assign('sl_month', (isset($selectedMonths) ? $selectedMonths : 0));
	$smarty->assign('days', $days);
	$smarty->assign('sl_day', (isset($selectedDays) ? $selectedDays : 0));
	$smarty->assign('countries', $countries);
	$smarty->assign('sl_country', (isset($selectedCountry) ? $selectedCountry : 0));

	/*$countriesList = '';
	foreach ($countries as $country)
	    $countriesList .= '<option value="'.$country['id_country'].'" '.($country['id_country'] == $selectedCountry ? 'selected="selected"' : '').'>'.$country['name'].'</option>';
	$smarty->assign('countries_list', $countriesList);*/
}

$smarty->assign('errors', $errors);
$smarty->display(_PS_THEME_DIR_.'authentication.tpl');

include(dirname(__FILE__).'/footer.php');

?>