<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');
$errors = array();

$add = isset($_POST['add']) ? 1 : (isset($_GET['add']) ? 1 : 0);
$update = isset($_POST['update']) ? 1 : (isset($_GET['update']) ? 1 : 0);
$delete = isset($_POST['delete']) ? 1 : (isset($_GET['delete']) ? 1 : 0);
$idProduct = intval(Tools::getValue('id_product'), NULL);
$idProductAttribute = intval(Tools::getValue('id_product_attribute'), NULL);

if (isset($_GET['ipa']))
	$idProductAttribute = intval($_GET['ipa']);
$qty = (isset($_POST['qty']) AND $_POST['qty'] != NULL)  ? 
intval($_POST['qty']) : (isset($_GET['qty']) ? intval($_GET['qty']) : 1);

$op = isset($_GET['op']) ? $_GET['op'] : 'up';
$queryString = isset($_GET['query']) ? urlencode($_GET['query']) : isset($_POST['query']) ? urlencode($_POST['query']) : NULL;

$cartDiscounts = $cart->getDiscounts();
$orderTotal = $cart->getOrderTotal(true, 1);
foreach ($cartDiscounts AS $k => $cartDiscount)
	if ($error = $cart->checkDiscountValidity(new Discount(intval($cartDiscount['id_discount'])), $cartDiscounts, $orderTotal, $cart->getProducts()))
		$cart->deleteDiscount(intval($cartDiscount['id_discount']));

if ($add OR $update OR $delete)
{
	if (!$idProduct)
		$errors[] = Tools::displayError('product not found');
	else
	{
		$producToAdd = new Product(intval($idProduct), false, intval($cookie->id_lang));

		if (!$producToAdd->id and !$delete)
			$errors[] = Tools::displayError('product is no longer available');
		else
		{
			if ($idProductAttribute AND is_numeric($idProductAttribute))
			{
				if (!$delete and !$producToAdd->isAvailableWhenOutOfStock($producToAdd->out_of_stock) AND !Attribute::checkAttributeQty(intval($idProductAttribute), intval($qty)))
					$errors[] = Tools::displayError('product is no longer available');
			}
			elseif ($producToAdd->hasAttributes() AND !$delete)
			{
				$idProductAttribute = Product::getDefaultAttribute(intval($producToAdd->id));
				if (!$idProductAttribute)
					Tools::redirectAdmin($link->getProductLink($producToAdd));
				else
					if (!$delete and !$producToAdd->isAvailableWhenOutOfStock($producToAdd->out_of_stock) AND !Attribute::checkAttributeQty(intval($idProductAttribute), intval($qty)))
						$errors[] = Tools::displayError('product is no longer available');
			}
			elseif (!$delete and !$producToAdd->checkQty(intval($qty)))
					$errors[] = Tools::displayError('product is no longer available');

			if (!sizeof($errors))
			{
				if ($add AND $qty >= 0)
				{
					if (!isset($cart->id) OR !$cart->id)
					{
					    $cart->add();
					    if ($cart->id)
							$cookie->id_cart = intval($cart->id);
					}
					$result = $cart->updateQty(intval($qty), intval($idProduct), intval($idProductAttribute), $op);
					if (!$result)
						$errors[] = Tools::displayError('you already have the maximum quantity available for this product');
				}
				elseif ($delete)
				{
					$cart->deleteProduct(intval($idProduct), intval($idProductAttribute));
					$discounts = $cart->getDiscounts();
					foreach($discounts as $discount)
					{
						$discountObj = new Discount(intval($discount['id_discount']), intval($cookie->id_lang));
						if ($cart->checkDiscountValidity($discountObj, $discounts, $cart->getOrderTotal(true, 1), $cart->getProducts()))
							$cart->deleteDiscount(intval($discount['id_discount']));
					}
				}
			}
			if (!sizeof($errors))
			{			
				if ($queryString AND !Configuration::get('PS_CART_REDIRECT'))
					Tools::redirect('search.php?search='.$queryString);
				if (isset($_SERVER['HTTP_REFERER']))
				{
					ereg('http://(.*)/(.*)', $_SERVER['HTTP_REFERER'], $regs);
					if (isset($regs[2]) AND !Configuration::get('PS_CART_REDIRECT'))
						Tools::redirect($regs[2]);
				}
			}
		}
	}
}

if (sizeof($errors))
{		
	$smarty->assign('errors', $errors);
	$smarty->display(_PS_THEME_DIR_.'errors.tpl');
}
else	
	Tools::redirect('order.php');


include(dirname(__FILE__).'/footer.php');

?>