<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');
$errors = array();

$nArray = array(10, 20, 50);
$p = abs(intval(Tools::getValue('p', 1)));
if ($p < 0) $p = 0;
$n = abs(intval(Tools::getValue('n', intval(Configuration::get('PS_PRODUCTS_PER_PAGE')))));
if (!$n) $n = $nArray[0];

$orderByValues = array(0 => 'name', 1 => 'price', 2 => 'date_add', 3 => 'date_upd');
$orderWayValues = array(0 => 'ASC', 1 => 'DESC');
$orderBy = strtolower(Tools::getValue('orderby', 
$orderByValues[intval(Configuration::get('PS_PRODUCTS_ORDER_BY'))]));
$orderWay = strtoupper(Tools::getValue('orderway', 
$orderWayValues[intval(Configuration::get('PS_PRODUCTS_ORDER_WAY'))]));

if (!in_array($orderWay, array('DESC', 'ASC'))) $orderWay = 'ASC';

if (!isset($_GET['id_category']) OR !Validate::isUnsignedId($_GET['id_category']))
	$errors[] = Tools::displayError('category id is missing');
else
{
	$id_category = intval(Tools::getValue('id_category'));
	$category = new Category($id_category, intval($cookie->id_lang));
	if (!Validate::isLoadedObject($category))
		$errors[] = Tools::displayError('category does not exist');
	else
	{
		$category->name = Category::hideCategoryPosition($category->name);
		$category->description = nl2br2($category->description);
		$subCategories = $category->getSubCategories(intval($cookie->id_lang));
		$smarty->assign('category', $category);
		if (Db::getInstance()->numRows())
			$smarty->assign('subcategories', $subCategories);
		if ($category->id != 1)
		{
			$nbProducts = $category->getProducts(NULL, NULL, NULL, $orderBy, $orderWay, true);
			if ($p > ($nbProducts / $n))
				$p = ceil($nbProducts / $n);
			$smarty->assign('pages_nb', ceil($nbProducts / intval($n)));
            $cproducts = $category->getProducts(intval($cookie->id_lang), intval($p), intval($n), $orderBy, $orderWay);
		 	$smarty->assign('nb_products', $nbProducts);
		}
        $smarty->assign('products', (isset($cproducts) AND $cproducts) ? $cproducts : NULL);
		$smarty->assign('id_category', intval($category->id));
		$smarty->assign('id_category_parent', intval($category->id_parent));
		$smarty->assign('return_category_name', Tools::safeOutput(Category::hideCategoryPosition($category->name)));
	   $path = Tools::safeOutput(Category::hideCategoryPosition($category->name));
		$smarty->assign('navigation_pipe', $navigationPipe);
		$smarty->assign('path', $path);
	}
}

$smarty->assign('allow_oosp', intval(Configuration::get('PS_ORDER_OUT_OF_STOCK')));
$smarty->assign('suppliers', Supplier::getSuppliers());
$smarty->assign('p', intval($p));
$smarty->assign('n', intval($n));
$smarty->assign('nArray', $nArray);
$smarty->assign('orderby', $orderBy);
$smarty->assign('orderway', $orderWay);
$smarty->assign('errors', $errors);
if (isset($subCategories))
{
	$smarty->assign('subcategories_nb_total', count($subCategories));
	$smarty->assign('subcategories_nb_half', ceil(count($subCategories) / 2));
}
$smarty->display(_PS_THEME_DIR_.'category.tpl');

include(dirname(__FILE__).'/footer.php');
?>
