<?php

/**
  * Attribute groups class, AttributeGroup.php
  * Attribute groups management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class		AttributeGroup extends ObjectModel
{
 	/** @var string Name */
	public 		$name;
	
	/** @var string Public Name */
	public 		$public_name;	
	
 	protected 	$fieldsRequiredLang = array('name', 'public_name');
 	protected 	$fieldsSizeLang = array('name' => 64, 'public_name' => 64);
 	protected 	$fieldsValidateLang = array('name' => 'isGenericName', 'public_name' => 'isGenericName');
		
	protected 	$table = 'attribute_group';
	protected 	$identifier = 'id_attribute_group';

	public function getFields()
	{
		return array('id_attribute_group' => NULL);
	}
	
	public function add($autodate = true, $nullValues = false)
	{
	 	return parent::add($autodate, true);
	}
	
	/**
	* Check then return multilingual fields for database interaction
	*
	* @return array Multilingual fields
	*/
	public function getTranslationsFieldsChild()
	{
		parent::validateFieldsLang();
		return parent::getTranslationsFields(array('name', 'public_name'));
	}
	
	public function update($nullValues = false)
	{
	 	$result = 1;
	 	$fields = $this->getTranslationsFieldsChild();
		foreach ($fields as $field)
		{
			foreach ($field as $key => $value)
			 	if (!Validate::isTableOrIdentifier($key))
	 				die(Tools::displayError());

			$mode = Db::getInstance()->getRow('SELECT `id_lang` FROM `'.pSQL(_DB_PREFIX_.$this->table).'_lang` WHERE `'.pSQL($this->identifier).
			'` = '.intval($this->id).' AND `id_lang` = '.intval($field['id_lang']));
			$result *= (!Db::getInstance()->NumRows()) ? Db::getInstance()->AutoExecute(_DB_PREFIX_.$this->table.'_lang', $field, 'INSERT') : 
			Db::getInstance()->AutoExecute(_DB_PREFIX_.$this->table.'_lang', $field, 'UPDATE', '`'.
			pSQL($this->identifier).'` = '.intval($this->id).' AND `id_lang` = '.intval($field['id_lang']));
		}
		return $result;
	}
	
	public function delete()
	{
	 	/* Also delete related attributes */
		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'attribute_lang` WHERE `id_attribute` IN (SELECT id_attribute FROM `'._DB_PREFIX_.'attribute` WHERE `id_attribute_group` = '.intval($this->id).')');
		Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'attribute` WHERE `id_attribute_group` = '.intval($this->id));
		return parent::delete();
	}
	
	/**
	 * Get all attributes for a given language / group
	 *
	 * @param integer $id_lang Language id
	 * @param boolean $id_attribute_group Attribute group id
	 * @return array Attributes
	 */
	static public function getAttributes($id_lang, $id_attribute_group)
	{
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM `'._DB_PREFIX_.'attribute` a
		LEFT JOIN `'._DB_PREFIX_.'attribute_lang` al ON (a.`id_attribute` = al.`id_attribute` AND al.`id_lang` = '.intval($id_lang).')
		WHERE a.`id_attribute_group` = '.intval($id_attribute_group).'
		ORDER BY `name`');
	}
	
	/**
	 * Get all attributes groups for a given language
	 *
	 * @param integer $id_lang Language id
	 * @return array Attributes groups
	 */
	static public function getAttributesGroups($id_lang)
	{
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM `'._DB_PREFIX_.'attribute_group` ag
		LEFT JOIN `'._DB_PREFIX_.'attribute_group_lang` agl ON (ag.`id_attribute_group` = agl.`id_attribute_group` AND `id_lang` = '.intval($id_lang).')
		ORDER BY `name` ASC');
	}
	
	/**
	 * Delete several objects from database
	 *
	 * return boolean Deletion result
	 */
	public function deleteSelection($selection)
	{
		/* Also delete Attributes */
		foreach ($selection AS $value) {
			$obj = new AttributeGroup($value);
			if (!$obj->delete())
				return false;
		}
		return true;
	}
}

?>