<?php

/**
  * Country class, Country.php
  * Countries management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */
  
class		Country extends ObjectModel
{
	public 		$id;
	
	/** @var integer Zone id which country belongs */
	public 		$id_zone;
	
	/** @var string 2 letters iso code */
	public 		$iso_code;
	
	/** @var string Name */
	public 		$name;
	
	/** @var boolean Status for delivery */
	public		$active = true;

	
	protected 	$tables = array ('country', 'country_lang');
	
 	protected 	$fieldsRequired = array('id_zone', 'iso_code');
 	protected 	$fieldsSize = array('id_zone' => 3, 'iso_code' => 2);
 	protected 	$fieldsValidate = array('id_zone' => 'isUnsignedId', 'iso_code' => 'isLanguageIsoCode', 'active' => 'isBool');
 	protected 	$fieldsRequiredLang = array('name');
 	protected 	$fieldsSizeLang = array('name' => 64);
 	protected 	$fieldsValidateLang = array('name' => 'isGenericName');
	
	protected 	$table = 'country';
	protected 	$identifier = 'id_country';

	public function getFields()
	{
		parent::validateFields();
		$fields['id_zone'] = intval($this->id_zone);
		$fields['iso_code'] = pSQL(strtoupper($this->iso_code));
		$fields['active'] = intval($this->active);
		return $fields;
	}
	
	/**
	  * Check then return multilingual fields for database interaction
	  *
	  * @return array Multilingual fields
	  */
	public function getTranslationsFieldsChild()
	{
		parent::validateFieldsLang();
		return parent::getTranslationsFields(array('name'));
	}
	
	/**
	  * Return available countries
	  *
	  * @param integer $id_lang Language ID
	  * @param boolean $active return only active coutries
	  * @return array Countries and corresponding zones
	  */
	static public function getCountries($id_lang, $active = false)
	{
	 	if (!Validate::isBool($active))
	 		die(Tools::displayError());

	    return Db::getInstance()->ExecuteS('
		SELECT c.*, cl.*, cl.`name` AS country, z.`name` AS zone
		FROM `'._DB_PREFIX_.'country` c
		LEFT JOIN `'._DB_PREFIX_.'country_lang` cl ON (c.`id_country` = cl.`id_country` AND cl.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'zone` z ON z.`id_zone` = c.`id_zone`
		'.($active ? 'WHERE c.active = 1' : '').'
		ORDER BY cl.name ASC');
	}
	
	/**
	  * Get a country ID with its iso code
	  *
	  * @param string $iso_code Country iso code
	  * @return integer Country ID
	  */
	static public function getByIso($iso_code)
    {
     	if (!Validate::isLanguageIsoCode($iso_code))
     		die(Tools::displayError());

	    $result = Db::getInstance()->getRow('
		SELECT `id_country`
		FROM `'._DB_PREFIX_.'country`
		WHERE `iso_code` = \''.pSQL(strtoupper($iso_code)).'\'');
		
		return $result['id_country'];
    }
	
	/**
	  * Get a country name with its ID
	  *
	  * @param string $id_lang Language ID
	  * @param string $id_country Country ID
	  * @return string Country name
	  */
	static public function getNameById($id_lang, $id_country)
    {
	    $result = Db::getInstance()->getRow('
		SELECT `name`
		FROM `'._DB_PREFIX_.'country_lang`
		WHERE `id_lang` = '.intval($id_lang).'
		AND `id_country` = '.intval($id_country).'');
		
        return $result['name'];
    }
}

?>