<?php

/**
  * Currency class, Currency.php
  * Currencies management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class		Currency extends ObjectModel
{
	public 		$id;
	
	/** @var string Name */
	public 		$name;

	/** @var string Iso code */
	public 		$iso_code;

	/** @var string Symbol for short display */
	public 		$sign;
	
	/** @var string Conversion rate from euros */
	public 		$conversion_rate;
	
	/** @var boolean True if currency has been deleted (staying in database as deleted) */
	public 		$deleted = 0;
	
	/** @var int ID used for displaying prices */
	public		$format;
	
 	protected 	$fieldsRequired = array('name', 'iso_code', 'sign', 'conversion_rate', 'format');
 	protected 	$fieldsSize = array('name' => 32, 'iso_code' => 3, 'sign' => 8);
 	protected 	$fieldsValidate = array('name' => 'isCurrencyName', 'sign' => 'isCurrencySign',
		'format' => 'isUnsignedId', 'conversion_rate' => 'isFloat', 'deleted' => 'isBool');
		
	protected 	$table = 'currency';
	protected 	$identifier = 'id_currency';
	
	public function getFields()
	{
		parent::validateFields();
		
		$fields['name'] = pSQL($this->name);
		$fields['iso_code'] = pSQL($this->iso_code);
		$fields['sign'] = pSQL($this->sign);
		$fields['format'] = intval($this->format);
		$fields['conversion_rate'] = floatval($this->conversion_rate);
		$fields['deleted'] = intval($this->deleted);
		
		return $fields;
	}
	
	public function deleteSelection($selection)
	{
		if (!is_array($selection) OR !Validate::isTableOrIdentifier($this->identifier) OR !Validate::isTableOrIdentifier($this->table))
			die(Tools::displayError());
		$result = true;
		foreach ($selection AS $id)
		{
			$obj = new Currency(intval($id));
			$res[$id] = $obj->delete();
		}
		foreach ($res AS $value)
			if (!$value)
				return false;
		return true;
	}

	public function delete()
	{
		if ($this->id == Configuration::get('PS_CURRENCY_DEFAULT'))
		{
			$result = Db::getInstance()->getRow('SELECT `id_currency` FROM '._DB_PREFIX_.'currency WHERE `id_currency` != '.intval($this->id).' AND `deleted` = 0');
			if (!$result['id_currency'])
				return false;
			Configuration::updateValue('PS_CURRENCY_DEFAULT', $result['id_currency']);
		}
		$this->deleted = 1;
		return $this->update();	
	}
	
	/**
	  * Return available currencies
	  *
	  * @return array Currencies
	  */
	static public function getCurrencies()
	{
		return Db::getInstance()->ExecuteS('
		SELECT * 
		FROM `'._DB_PREFIX_.'currency`
		WHERE `deleted` = 0 
		ORDER BY `name` ASC');
	}
	
	static public function getCurrency($id_currency)
	{
		return Db::getInstance()->getRow('
		SELECT * 
		FROM `'._DB_PREFIX_.'currency`
		WHERE `deleted` = 0 
		AND `id_currency` = '.intval($id_currency));
	}
}

?>