<?php

/**
  * Link class, Link.php
  * Links management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class Link
{
	/** @var boolean Rewriting activation */
	private $allow;
	private $url;
	
	/**
	  * Constructor (initialization only)
	  */
	function __construct()
	{
		$this->allow = intval(Configuration::get('PS_REWRITING_SETTINGS'));
		$this->url = htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8');
	}
	
	/**
	  * Return the correct link for the product
	  *
	  * @param mixed $id_product Can be either the product object or the ID only
	  * @param string $alias Friendly URL (only if $id_product is the object)
	  * @return string link
	  */
	public function getProductLink($id_product, $alias = null, $ean13 = null)
	{
	 	if (!isset($this->allow)) $this->allow = 0;
		if (is_object($id_product))
			return ($this->allow == 1)?(__PS_BASE_URI__.intval($id_product->id).'-'.$id_product->link_rewrite.($id_product->ean13 ? '-'.$id_product->ean13 : '').'.html') : 
			(__PS_BASE_URI__.'product.php?id_product='.intval($id_product->id));
		elseif ($alias)
			return ($this->allow == 1)?(__PS_BASE_URI__.intval($id_product).'-'.$alias.($ean13 ? '-'.$ean13 : '').'.html') : 
			(__PS_BASE_URI__.'product.php?id_product='.intval($id_product));
		else
			return __PS_BASE_URI__.'product.php?id_product='.intval($id_product);
	}
	
	/**
	  * Return the correct link for the category
	  *
	  * @param mixed $id_category Can be either the category object or the ID only
	  * @param string $alias Friendly URL (only if $id_category is the object)
	  * @return string link
	  */
	public function getCategoryLink($id_category, $alias = NULL)
	{
		if (is_object($id_category))
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_category->id).'-'.$id_category->link_rewrite) : 
			(__PS_BASE_URI__.'category.php?id_category='.intval($id_category->id));
		elseif ($alias)
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_category).'-'.$alias) :
			(__PS_BASE_URI__.'category.php?id_category='.intval($id_category));
		else
			return __PS_BASE_URI__.'category.php?id_category='.intval($id_category);
	}
	
	public function getSupplierLink($id_supplier, $alias = NULL)
	{
		if (is_object($id_supplier))
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_supplier->id).'__'.$id_supplier->link_rewrite) : 
			(__PS_BASE_URI__.'supplier.php?id_supplier='.intval($id_supplier->id));
		elseif ($alias)
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_supplier).'__'.$alias) :
			(__PS_BASE_URI__.'supplier.php?id_supplier='.intval($id_supplier));
		else
			return __PS_BASE_URI__.'supplier.php?id_supplier='.intval($id_supplier);
	}
	
	public function getManufacturerLink($id_manufacturer, $alias = NULL)
	{
		if (is_object($id_manufacturer))
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_manufacturer->id).'_'.$id_manufacturer->link_rewrite) : 
			(__PS_BASE_URI__.'manufacturer.php?id_manufacturer='.intval($id_manufacturer->id));
		elseif ($alias)
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_manufacturer).'_'.$alias) :
			(__PS_BASE_URI__.'manufacturer.php?id_manufacturer='.intval($id_manufacturer));
		else
			return __PS_BASE_URI__.'manufacturer.php?id_manufacturer='.intval($id_manufacturer);
	}

	public function getCustomLink($id_custom, $page, $prefix = '~', $alias = NULL)
	{
		if (is_object($id_custom))
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_custom->id).$prefix.$id_custom->link_rewrite) : 
			(__PS_BASE_URI__.$page.'?id_custom='.intval($id_custom->id));
		elseif ($alias)
			return ($this->allow == 1) ? (__PS_BASE_URI__.intval($id_custom).$prefix.$alias) :
			(__PS_BASE_URI__.$page.'?id_custom='.intval($id_custom));
		else
			return __PS_BASE_URI__.$page.'?id_custom='.intval($id_custom);
	}

	
	/**
	  * Create link after language change
	  *
	  * @param integer $id_lang Language ID
	  * @return string link
	  */
	public function getLanguageLink($id_lang)
	{
		return $this->getUrlWith('id_lang', intval($id_lang));
	}
	
	public function goLink($orderBy, $orderWay)
    {
		if ((!empty($orderBy) AND !Validate::isOrderBy($orderBy)) OR 
		 (!empty($orderWay) AND !Validate::isOrderWay($orderWay)))
	 		return false;

        $n = 0;
		$url = $this->url;
        foreach ($_GET as $k => $value)
			if ($k != 'orderby' AND $k != 'orderway' AND Tools::getValue($k))
				$url .= ((!$n++) ? '?' : '&amp;').urlencode($k).'='.urlencode($value);
        return ($url.($n ? '&amp;' : '?').'orderby='.urlencode($orderBy).'&orderway='.urlencode($orderWay));
    }
	
	public function getUrlWith($key, $val)
    {
        $n = 0;
		$url = $this->url;
        foreach ($_GET as $k => $value)
			if ($k != $key AND Tools::getValue($k))
				$url .= ((!$n++) ? '?' : '&amp;').urlencode($k).'='.urlencode($value);
        return $url.($n ? '&amp;' : '?').urlencode($key).'='.urlencode($val);
    }
	
	public function goPage($p)
	{
		return $this->getUrlWith('p', intval($p));
	}
}
	
?>
