<?php

/**
  * Price ranges class, RangePrice.php
  * Price ranges management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class RangePrice extends ObjectModel
{
	public 		$delimiter1;
	public 		$delimiter2;
	
 	protected 	$fieldsRequired = array('delimiter1', 'delimiter2');
 	protected 	$fieldsValidate = array('delimiter1' => 'isFloat', 'delimiter2' => 'isFloat');

	protected 	$table = 'range_price';
	protected 	$identifier = 'id_range_price';
		
	public function getFields()
	{
		parent::validateFields();
		$fields['delimiter1'] = floatval($this->delimiter1);
		$fields['delimiter2'] = floatval($this->delimiter2);
		return $fields;
	}
	
	/**
	* Get all available price ranges
	*
	* @return array Ranges
	*/
	public static function getRanges()
	{
		return Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'range_price` ORDER BY `delimiter1` ASC');
	}
}

?>