<?php

/**
  * Taxes class, Tax.php
  * Taxes management
  * @category classes
  *
  * @author PrestaShop <support@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.8
  *
  */

class Tax extends ObjectModel
{
 	/** @var string Name */
	public 		$name;
	
	/** @var float Rate (%) */
	public 		$rate;
	
 	protected 	$fieldsRequired = array('rate');
 	protected 	$fieldsValidate = array('rate' => 'isFloat');
 	protected 	$fieldsRequiredLang = array('name');
 	protected 	$fieldsSizeLang = array('name' => 32);
 	protected 	$fieldsValidateLang = array('name' => 'isGenericName');

	protected 	$table = 'tax';
	protected 	$identifier = 'id_tax';
	
	public		$noZeroObject = 'getTaxes';
		
	public function getFields()
	{
		parent::validateFields();
		$fields['rate'] = floatval($this->rate);
		return $fields;
	}
	
	/**
	* Check then return multilingual fields for database interaction
	*
	* @return array Multilingual fields
	*/
	public function getTranslationsFieldsChild()
	{
		parent::validateFieldsLang();
		return parent::getTranslationsFields(array('name'));
	}
	
	public static function checkTaxZone($id_tax, $id_zone)
	{
		return Db::getInstance()->ExecuteS('
			SELECT tz.`id_tax`
			FROM `'._DB_PREFIX_.'tax_zone` tz
			WHERE tz.`id_tax` = '.intval($id_tax).'
			AND tz.`id_zone` = '.intval($id_zone));
	}
	
	/**
	 * Get all zones
	 *
	 * @return array Zones
	 */
	public function getZones()
	{
		return Db::getInstance()->ExecuteS('
			SELECT *
			FROM `'._DB_PREFIX_.'tax_zone`
			WHERE `id_tax` = '. $this->id);
	}
	
	/**
	 * Get a specific zones
	 *
	 * @return array Zone
	 */
	public function getZone($id_zone)
	{
		return Db::getInstance()->ExecuteS('
			SELECT *
			FROM `'._DB_PREFIX_.'tax_zone`
			WHERE `id_tax` = '. $this->id.'
			AND `id_zone` = '. $id_zone);
	}
	
	/**
	 * Add zone
	 */
	public function addZone($id_zone)
	{
		return Db::getInstance()->ExecuteS('
			INSERT INTO `'._DB_PREFIX_.'tax_zone` (`id_tax` , `id_zone`)
			VALUES ('.$this->id.', '.$id_zone.')');
	}
	
	/**
	 * Delete zone
	 */
	public function deleteZone($id_zone)
	{
		return Db::getInstance()->ExecuteS('
			DELETE FROM `'._DB_PREFIX_.'tax_zone`
			WHERE `id_tax` = '.$this->id.'
			AND `id_zone` = '.$id_zone.' LIMIT 1');
	}
	
	/**
	* Get all available taxes
	*
	* @return array Taxes
	*/
	static public function getTaxes($id_lang = false)
	{
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM `'._DB_PREFIX_.'tax` t
		'.(intval($id_lang) ? 'LEFT JOIN `'._DB_PREFIX_.'tax_lang` tl ON (t.`id_tax` = tl.`id_tax` AND tl.`id_lang` = '.intval($id_lang).')
		ORDER BY `name` ASC' : ''));
	}
	
	static public function excludeTaxeOption()
	{
		if (Configuration::get("PS_TAX"))
			return false;
		return true;
	}
	
	static public function excludeTaxeByZone($id_tax, $country)
	{
		if (isset($country) AND Validate::isLoadedObject($country) AND !count(Tax::checkTaxZone($id_tax, $country->id_zone)))
			return true;
		return false;
	}
	
	static public function excludeCustomerTaxeByZone($id_tax)
	{
		global $cart;
		
		$country = 0;
		if (isset($cart) AND isset($cart->id_address_invoice))
		{
			$address = new Address(intval($cart->id_address_invoice));
			$country = new Country(intval($address->id_country));
		}
		return Tax::excludeTaxeByZone($id_tax, $country);
	}
}

?>