<?php
ini_set('display_errors', 'off');

// correct charset for Apache
header('Content-Type: text/html; charset=utf-8');
ini_set('default_charset', 'utf-8');

/*
 * It is not safe to rely on the system's timezone settings, but we can\'t easily determine the user timezone and the use of this function cause trouble for some configurations.
 * This will generate a PHP Strict Standards notice. To fix it up, uncomment the following line.
 */
//date_default_timezone_set('Europe/Paris');


if(!file_exists(dirname(__FILE__).'/settings.inc.php'))
{
	echo '
	<center><table style="text-align: center; margin: 100px auto 0 auto;">
		<tr><td><img src="img/install/ps-logo.gif" /><br /><br /></td></tr>
		<tr><td style="width: 450px; margin-top: 35px; padding: 12px 15px; border-top : 1px dotted #666; border-bottom: 1px dotted #666; background: #F9E3EE; text-align: left; font-family: \'Lucida Grande\', Verdana, sans-serif; font-size: 90%; text-transform: none; font-weight:normal; letter-spacing: 0; color: #C73178; ">
		<img src="img/install/warning.gif" />
		The PrestaShop\'s solution isn\'t installed yet, or your parameters file isn\'t available. <br />
		You must install the solution first.
		';
		
	if(!version_compare(substr(phpversion(), 0, 3), '5.0', '>=')){
		echo "<br/><br/>Unfortunately, PrestaShop cannot be installed with your current configuration.  The installed version of PHP is older than PHP 5.  Please ask your network administrator for assistance.";
		echo '</td></tr>';
		echo '<tr><td align="center"><a style="font-family: \'Lucida Grande\', Verdana, sans-serif; font-size:0.7em; color:#C73178;" href="javascript:refresh()" >refresh this page when PHP 5 is installed</a></td></tr>';
		} else {
		echo'</td></tr>';
		echo '<tr><td align="center"><a href="install/" ><img src="img/install/install.gif" style="border: none;" /></a></td></tr>';
	}
	
	echo '</table></center>';
	exit;
}

if (!isset($_SERVER['REQUEST_URI']) OR empty($_SERVER['REQUEST_URI'])) {
	$_SERVER['REQUEST_URI'] = $_SERVER["SCRIPT_NAME"];

	if (isset($_SERVER['QUERY_STRING']) AND !empty($_SERVER['QUERY_STRING'])) {
		$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
	}
}

require_once(dirname(__FILE__).'/settings.inc.php');

/* Autoload */
function __autoload($className)
{
	if (!class_exists($className, false))
		require_once (dirname(__FILE__).'/../classes/'.$className.'.php');
}

$currentDir = dirname(__FILE__);

/* Base and themes */
define('_THEMES_DIR_', __PS_BASE_URI__.'themes/');
define('_THEME_IMG_DIR_', _THEMES_DIR_._THEME_NAME_.'/img/');
define('_THEME_CSS_DIR_', _THEMES_DIR_._THEME_NAME_.'/css/');
define('_THEME_JS_DIR_', _THEMES_DIR_._THEME_NAME_.'/js/');
define('_THEME_CAT_DIR_', __PS_BASE_URI__.'img/c/');
define('_THEME_PROD_DIR_', __PS_BASE_URI__.'img/p/');
define('_THEME_MANU_DIR_', __PS_BASE_URI__.'img/m/');
define('_THEME_SUP_DIR_', __PS_BASE_URI__.'img/su/');
define('_THEME_SHIP_DIR_', __PS_BASE_URI__.'img/s/');
define('_THEME_LANG_DIR_', __PS_BASE_URI__.'img/l/');
define('_THEME_DIR_', _THEMES_DIR_._THEME_NAME_.'/');
define('_PS_IMG_', __PS_BASE_URI__.'img/');
define('_SUPP_DIR_', __PS_BASE_URI__.'img/su/');

/* Directories */
define('_PS_ROOT_DIR_', $currentDir.'/..');
define('_PS_CLASS_DIR_', $currentDir.'/../classes/');
define('_PS_TRANSLATIONS_DIR_', $currentDir.'/../translations/');
define('_PS_IMG_DIR_', $currentDir.'/../img/');
define('_PS_CAT_IMG_DIR_', $currentDir.'/../img/c/');
define('_PS_PROD_IMG_DIR_', $currentDir.'/../img/p/');
define('_PS_MANU_IMG_DIR_', $currentDir.'/../img/m/');
define('_PS_SHIP_IMG_DIR_', $currentDir.'/../img/s/');
define('_PS_SUPP_IMG_DIR_', $currentDir.'/../img/su/');
define('_PS_TMP_IMG_DIR_', $currentDir.'/../img/tmp/');
define('_PS_MAIL_DIR_', $currentDir.'/../mails/');
define('_PS_MODULE_DIR_', $currentDir.'/../modules/');
define('_PS_ALL_THEMES_DIR_', $currentDir.'/../themes/');
define('_PS_THEME_DIR_', $currentDir.'/../themes/'._THEME_NAME_.'/');
define('_PS_TOOL_DIR_', $currentDir.'/../tools/');
define('_PS_SMARTY_DIR_', _PS_TOOL_DIR_.'smarty/');
define('_PS_STEST_DIR_', _PS_TOOL_DIR_.'simpletest/');
define('_PS_SWIFT_DIR_', _PS_TOOL_DIR_.'swift/');
define('_PS_FPDF_PATH_', _PS_TOOL_DIR_.'fpdf/');
define('_PS_PEAR_XML_PARSER_PATH_', _PS_TOOL_DIR_.'pear_xml_parser/');
define('_PS_CSS_DIR_', __PS_BASE_URI__.'css/');
define('_PS_JS_DIR_', __PS_BASE_URI__.'js/');
define('_PS_DOWNLOAD_DIR_', $currentDir.'/../download/');

/* settings php */
define('_PS_MAGIC_QUOTES_GPC_', get_magic_quotes_gpc());
define('_PS_MYSQL_REAL_ESCAPE_STRING_', function_exists('mysql_real_escape_string'));

/* Order states */
define('_PS_OS_CHEQUE_', 1);
define('_PS_OS_PAYMENT_', 2);
define('_PS_OS_PREPARATION_', 3);
define('_PS_OS_SHIPPING_', 4);
define('_PS_OS_DELIVERED_', 5);
define('_PS_OS_CANCELED_', 6);
define('_PS_OS_REFUND_', 7);
define('_PS_OS_ERROR_', 8);
define('_PS_OS_OUTOFSTOCK_', 9);
define('_PS_OS_BANKWIRE_', 10);

/* Smarty */
require_once(_PS_SMARTY_DIR_.'Smarty.class.php');
$smarty = new Smarty();
$smarty->template_dir 	= _PS_THEME_DIR_.'tpl';
$smarty->compile_dir 	= _PS_SMARTY_DIR_.'compile';
$smarty->cache_dir 		= _PS_SMARTY_DIR_.'cache';
$smarty->config_dir 	= _PS_SMARTY_DIR_.'configs';
$smarty->caching 		= false;
$smarty->force_compile	= true;
//$smarty->debugging		= true;
$smarty->debug_tpl		= _PS_ALL_THEMES_DIR_ . 'debug.tpl';

global $_MODULES;
$_MODULES = array();

function smartyTranslate($params, &$smarty)
{
	/*
	 * Warning : 2 lines have been added to the Smarty class.
	 * "public $currentTemplate = null;" into the class itself
	 * "$this->currentTemplate = substr(basename($resource_name), 0, -4);" into the "display" method
	 */
	 
	global $_LANG, $_MODULES, $cookie, $_MODULE;
	if (!isset($params['js'])) $params['js'] = 0;
	if (!isset($params['mod'])) $params['mod'] = false;
	$msg = false;

	$key = $smarty->currentTemplate.'_'.md5(addslashes($params['s']));

	if ($params['mod'])
	{
		if (file_exists(_PS_THEME_DIR_.'modules/'.$params['mod'].'/'.Language::getIsoById($cookie->id_lang).'.php'))
		{
			$translationsFile = _PS_THEME_DIR_.'modules/'.$params['mod'].'/'.Language::getIsoById($cookie->id_lang).'.php';
			$modKey = '<{'.$params['mod'].'}'._THEME_NAME_.'>'.$key;
		}
		else
		{
			$translationsFile = _PS_MODULE_DIR_.$params['mod'].'/'.Language::getIsoById($cookie->id_lang).'.php';
			$modKey = '<{'.$params['mod'].'}default>'.$key;
		}

		if (@include_once($translationsFile))
			$_MODULES = array_merge($_MODULES, $_MODULE);


		$msg = (is_array($_MODULES) AND key_exists($modKey, $_MODULES)) ? ($params['js'] ? addslashes($_MODULES[$modKey]) : stripslashes($_MODULES[$modKey])) : false;
	}
	if (!$msg)
		$msg = (is_array($_LANG) AND key_exists($key, $_LANG)) ? ($params['js'] ? addslashes($_LANG[$key]) : stripslashes($_LANG[$key])) : $params['s'];
	return str_replace('"', '&quot;', $msg);
}

$smarty->register_function('l', 'smartyTranslate');

/* Load all configuration keys */
Configuration::loadConfiguration();

global $link;
$link = new Link();
$smarty->assign('link', $link);

?>
