<?php
require_once(dirname(__FILE__).'/config/config.inc.php');

function displayError($msg)
{
	$translations = array(
	'FR' => array(
		'return'
			=> 'retour'
		,'Invalid key.'
			=> 'Clé non valide.'
		,'This product doesn\'t exists in our store.'
			=> 'Ce produit est inexistant dans notre magasin.'
		,'This product has been deleted.'
			=> 'Ce produit a été supprimé.'
		,'This file no more exists.'
			=> 'Ce produit n\'existe plus.'
		,'The product deadline is in the past.'
			=> 'La date limite du produit est dépassé.'
		,'Dear customer, you exceed the expiration date.'
			=> 'Chèr(e) client, vous avez dépassé la date d\'expiration.'
		,'You reach the maximum number of allowed downloads.'
			=> 'Vous avez dépassé le nombre maximum de téléchargements autorisés.'
		)
	);
?>
<script type="text/javascript">
<!--
alert("<?php echo Tools::historyc_l($msg, $translations) ?>");
if(document.referrer!=document.URL)
{
	document.write('<a href="' + document.referrer + '"><?php echo Tools::historyc_l('return', $translations) ?></a>');
	window.location.href = document.referrer;
}
-->
</script>
<?php
	exit();
}

$cookie = new Cookie('psAdmin');
if ($cookie->isLoggedBack() && Tools::getValue('file'))
{
	// Admin can access to file directly
	$filename = Tools::getValue('file');
	$file = _PS_DOWNLOAD_DIR_ . $filename;
	$filename = ProductDownload::getFilenameFromFilename(Tools::getValue('file'));
	if (!file_exists($file))
		Tools::redirect('index.php');
}
else
{
	if (!($key = Tools::getValue('key')))
		displayError('no key !');

	$cookie = new Cookie('ps');
	Tools::setCookieLanguage();
	if (!$cookie->isLogged())
	{
		Tools::redirect('authentication.php?back=getFile.php?key=' . $key);
		exit();
	}

	// key must like: <sha1-filename>-<hashOrder>
	$tmp = explode("-", $key);
	if (count($tmp) != 2)
		displayError('Invalid key.');

	$filename = $tmp[0];
	$hash = $tmp[1];

	if (!($info = OrderDetail::getDownloadFromHash($hash)))
		displayError('This product doesn\'t exists in our store.');

	// product no more present in catalog
	if (!isset($info['id_product_download']) OR empty($info['id_product_download']))
		displayError('This product has been deleted.');

	if (!file_exists(_PS_DOWNLOAD_DIR_ . $filename))
		displayError('This file no more exists.');

	$now = time();

	$product_deadline = strtotime($info['download_deadline']);
	if ($now > $product_deadline && $info['download_deadline']!='0000-00-00 00:00:00')
		displayError('The product deadline is in the past.');

	$customer_deadline = strtotime($info['date_expiration']);
	if ($now > $customer_deadline && $info['date_expiration']!='0000-00-00 00:00:00')
		displayError('Dear customer, you exceed the expiration date.');

	if ($info['download_nb'] >= $info['nb_downloadable'] && $info['nb_downloadable']!=0)
		displayError('You reach the maximum number of allowed downloads.');

	// Access is authorized -> increment download value for the customer
	OrderDetail::incrementDownload($info['id_order_detail']);

	$file = _PS_DOWNLOAD_DIR_ . $info['physically_filename'];
	$filename = $info['display_filename'];
}

$handle = fopen($file, "r");
$len = filesize($file);

// detect mime content type
$mime_type = false;
if (function_exists('finfo_open'))
{
	$finfo = finfo_open(FILEINFO_MIME);
	$mime_type = finfo_file($finfo, $file);
	finfo_close($finfo);
}
else if (function_exists('mime_content_type'))
{
	$mime_type = mime_content_type($file);
}
else if (function_exists('exec'))
{
	$mime_type = trim(exec('file -bi '.escapeshellarg($file)));
}

// set headers for confortable download
header('Content-Transfer-Encoding: binary');
if ($mime_type) header('Content-Type: ' . $mime_type);
header('Content-Length: ' . $len);
header('Content-Disposition: attachment; filename="' . $filename . '"');

readfile($file);

fclose($handle);

exit();

?>