<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');

if (!$cookie->isLogged())
	Tools::redirect('authentication.php?back=identity.php');

$customer = new Customer(intval($cookie->id_customer));

if ($_POST)
	foreach ($customer->getFields() AS $key => $value)
		if ($key != 'passwd' AND $key != 'active' AND $key != 'date_add' AND $key != 'date_upd')
		{
			if (key_exists($key, $_POST))
				$customer->{$key} = trim($_POST[$key]);
			else
				$customer->{$key} = 0;
		}

if (isset($_POST['years']) && isset($_POST['months']) && isset($_POST['days']))
	$customer->birthday = intval($_POST['years']).'-'.intval($_POST['months']).'-'.intval($_POST['days']);

$errors = array();
if (Tools::isSubmit('submitIdentity'))
{
	if (!@checkdate(Tools::getValue('months'), Tools::getValue('days'), Tools::getValue('years')) AND !(Tools::getValue('months') == '' AND Tools::getValue('days') == '' AND Tools::getValue('years') == ''))
		$errors[] = Tools::displayError('invalid birthday');
	else
	{
		$customer->birthday = (empty($_POST['years']) ? '' : intval($_POST['years']).'-'.intval($_POST['months']).'-'.intval($_POST['days']));
		if ($_POST['passwd'] != $_POST['confirmation'])
			$errors[] = Tools::displayError('Password and confirmation do not match');
		else
			$errors = $customer->validateControler();
		if (!sizeof($errors))
		{
			$customer->name = strtoupper($customer->name);
		    $customer->surname = ucfirst(strtolower($customer->surname));
			if (Tools::getValue('passwd'))
				$cookie->passwd = $customer->passwd;
			
			if ($customer->update())
				Tools::redirect('my-account.php');
			$errors[] = Tools::displayError('impossible to update information');
		}
	}

	foreach ($_POST AS $k => $val)
		$_POST[$k] = Tools::safeOutput($val);
}
else
	$_POST = array_map('stripslashes', $customer->getFields());

if ($customer->birthday)
	$birthday = split('-', $customer->birthday);
else
	$birthday = array('-', '-', '-');

	// Years, months and days
	$smarty->assign('years', Tools::dateYears());
	$smarty->assign('sl_year', $birthday[0]);
	$smarty->assign('months', Tools::dateMonths());
	$smarty->assign('sl_month', $birthday[1]);
	$smarty->assign('days', Tools::dateDays());
	$smarty->assign('sl_day', $birthday[2]);

if (sizeof($errors))
	$smarty->assign('errors', $errors);

$smarty->display(_PS_THEME_DIR_.'identity.tpl');

include(dirname(__FILE__).'/footer.php');

?>