<?php
/**
  * Initialize Front-Office data
  * @category front-office
  *
  * @author prestashop <contact@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  *
  */

if (!isset($smarty))
	exit();

// Specials include
if(!is_dir(dirname(__FILE__).'/themes/'._THEME_NAME_))
	die('Error: Current theme unavailable. Please check your theme directory name and permissions.');
elseif (basename($_SERVER['PHP_SELF']) != 'disabled.php' AND !intval(Configuration::get('PS_SHOP_ENABLE')))
	$special_include = 'maintenance';

ob_start();
global $cart, $cookie, $_CONF, $link;

// get page name to display it in body id
$pathinfo = pathinfo(__FILE__);
$page_name = basename($_SERVER['PHP_SELF'], '.'.$pathinfo['extension']);

$cookie = new Cookie('ps');

if (isset($_GET['logout']))
{
	$cookie->logout();
	Tools::redirect(isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : NULL);
}
elseif (isset($_GET['mylogout']))
{
 	$cookie->mylogout();
	Tools::redirect(isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : NULL);
}

Tools::setCookieLanguage();
$iso = strtolower(Language::getIsoById((isset($cookie->id_lang)) ? intval($cookie->id_lang) : 1));
@include(_PS_TRANSLATIONS_DIR_.$iso.'/fields.php');
@include(_PS_TRANSLATIONS_DIR_.$iso.'/errors.php');
$_MODULES = array();

$currency = Tools::setCurrency();

if (isset($cookie->id_cart) AND is_numeric($cookie->id_cart))
{
	$cart = new Cart(intval($cookie->id_cart));
	$cart->id_lang = intval($cookie->id_lang);
	if ($cart->OrderExists())
		unset($cookie->id_cart, $cart);
	else
	{	
		if (isset($cookie->id_customer))
    		$cart->id_customer = intval($cookie->id_customer);
    	$cart->id_currency = intval($cookie->id_currency);
    	$cart->update();
    }
}

if (!isset($cart) OR !$cart->id)
{
	$cart = new Cart();
	$cart->id_lang = intval($cookie->id_lang);
    $cart->id_currency = intval($cookie->id_currency);
    if (isset($cookie->id_customer))
    	$cart->id_customer = intval($cookie->id_customer);
}
if (!$cart->nbProducts())
	$cart->id_carrier = null;

$ps_language = new Language(intval($cookie->id_lang));
setlocale(LC_TIME, strtolower($ps_language->iso_code).'_'.strtoupper($ps_language->iso_code).'@euro', 
strtolower($ps_language->iso_code).'_'.strtoupper($ps_language->iso_code), strtolower($ps_language->iso_code));
if (is_object($currency))
	$smarty->ps_currency = $currency;
if (is_object($ps_language))
	$smarty->ps_language = $ps_language;

$smarty->register_function('dateFormat', 'Tools::dateFormat');
$smarty->register_function('productPrice', 'Product::productPrice');
$smarty->register_function('convertPrice', 'Product::convertPrice');
$smarty->register_function('convertPriceWithoutDisplay', 'Product::productPriceWithoutDisplay');
$smarty->register_function('convertPriceWithCurrency', 'Product::convertPriceWithCurrency');
$smarty->register_function('displayWtPrice', 'Product::displayWtPrice');
$smarty->register_function('displayWtPriceWithCurrency', 'Product::displayWtPriceWithCurrency');

$smarty->assign(Tools::getMetaTags(intval($cookie->id_lang)));
$smarty->assign('request_uri', Tools::safeOutput(urldecode($_SERVER['REQUEST_URI'])));

// Breadcrumb
$navigationPipe = (Configuration::get('PS_NAVIGATION_PIPE') ? Configuration::get('PS_NAVIGATION_PIPE') : '>');
$smarty->assign('navigationPipe', $navigationPipe);

if (strstr($_SERVER['REQUEST_URI'], '&ac=') OR strstr($_SERVER['REQUEST_URI'], '?ac='))
	$smarty->assign('nobots', 1);

$smarty->assign(array(
'base_dir' => __PS_BASE_URI__,
'img_ps_dir' => _PS_IMG_,
'img_cat_dir' => _THEME_CAT_DIR_,
'img_lang_dir' => _THEME_LANG_DIR_,
'img_prod_dir' => _THEME_PROD_DIR_,
'img_manu_dir' => _THEME_MANU_DIR_,
'img_sup_dir' => _THEME_SUP_DIR_,
'img_ship_dir' => _THEME_SHIP_DIR_,
'img_dir' => _THEME_IMG_DIR_,
'css_dir' => _THEME_CSS_DIR_,
'js_dir' => _THEME_JS_DIR_,
'tpl_dir' => _PS_THEME_DIR_,
'lang_iso' => $ps_language->iso_code,
'come_from' => 'http://'.$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"],
'shop_name' => Configuration::get('PS_SHOP_NAME'),
'cart_qties' => $cart->nbProducts(),
'cart' => $cart,
'currencies' => Currency::getCurrencies(),
'id_currency_cookie' => intval($currency->id),
'currency' => $currency,
'languages' => Language::getLanguages(),
'logged' => $cookie->isLogged(),
'customerName' => (isset($cookie->logged) ? $cookie->customer_surname.' '.$cookie->customer_name : false),
'page_name' => $page_name,
));
