<?php
class ToolsInstall
{
	public static function checkDB ($srv, $login, $password, $name, $posted = true)
	{
		require_once(INSTALL_PATH.'/../classes/Validate.php');
		require_once(INSTALL_PATH.'/../classes/Db.php');
		require_once(INSTALL_PATH.'/../classes/MySQL.php');
		
		if($posted)
		{
			// Check POST data...
			$data_check = array(
				!isset($_POST['server']) OR empty($_POST['server']),
				!Validate::isMailName($_POST['server']),
				!isset($_POST['type']) OR empty($_POST['type']),
				!Validate::isMailName($_POST['type']),
				!isset($_POST['name']) OR empty($_POST['name']),
				!Validate::isMailName($_POST['name']),
				!isset($_POST['login']) OR empty($_POST['login']),
				!Validate::isMailName($_POST['login']),
				!isset($_POST['password']),
				!Validate::isMailName($_POST['password'])
			);
			foreach ($data_check AS $data)
				if ($data)
					return 8;
		}
		
		switch(MySQL::tryToConnect($srv, $login, $password, $name))
		{
			case 0:
				return true;
			break;
			
			case 1:
				return 25;
			break;
			
			case 2:
				return 24;
			break;
		}
	}
	
	public static function sendMail($smtpChecked, $smtpServer, $content, $subject, $type, $to, $from, $smtpLogin, $smtpPassword, $smtpPort, $smtpEncryption)
	{
		require_once INSTALL_PATH."/../tools/swift/Swift.php";
		require_once INSTALL_PATH."/../tools/swift/Swift/Connection/SMTP.php";
		require_once INSTALL_PATH."/../tools/swift/Swift/Connection/NativeMail.php";
		
		
		
		$swift = null;
		$result = null;
		try
		{
			
			if($smtpChecked)
			{
				
				$smtp = new Swift_Connection_SMTP($smtpServer, ($smtpPort == "secure") ? Swift_Connection_SMTP::PORT_SECURE : Swift_Connection_SMTP::PORT_DEFAULT, ($smtpEncryption == "off") ? Swift_Connection_SMTP::ENC_OFF : (($smtpEncryption == "tls") ? Swift_Connection_SMTP::ENC_TLS : Swift_Connection_SMTP::ENC_SSL));
				$smtp->setUsername($smtpLogin);
				$smtp->setpassword($smtpPassword);
				$smtp->setTimeout(5);
				$swift = new Swift($smtp);
			}
			else
			{
				$swift = new Swift(new Swift_Connection_NativeMail());
			}
			
			$message = new Swift_Message($subject, $content, $type);
			
			if ($swift->send($message, $to, $from))
			{
				$result = true;
			}
			else
			{
				$result = 999;
			}
			$swift->disconnect();
		}
		catch (Swift_Connection_Exception $e)
		{
		 $result = $e->getCode();
		}
		catch (Swift_Message_MimeException $e)
		{
		 $result = $e->getCode();
		}
		return $result;	
	}
	
	public static function getNotificationMail($shopName, $shopUrl, $shopLogo, $surname, $name, $password, $email)
	{
		$iso_code = $_POST['isoCodeLocalLanguage'];
		$pathTpl = INSTALL_PATH.'/../mails/en/employee_password.html';
		$pathTplLocal = INSTALL_PATH.'/../mails/'.$iso_code.'/employee_password.html';
		
		$content = ( file_exists($pathTplLocal) ) ? file_get_contents($pathTplLocal) : file_get_contents($pathTpl);
		$content = str_replace("{shop_name}", $shopName, $content);
		$content = str_replace("{shop_url}", $shopUrl, $content);
		$content = str_replace("{shop_logo}", $shopLogo, $content);
		$content = str_replace("{surname}", $surname, $content);
		$content = str_replace("{name}", $name, $content);
		$content = str_replace("{passwd}", $password, $content);
		$content = str_replace("{email}", $email, $content);
		return $content;
	}
	
	public static function getLangString($idLang)
	{
		switch ($idLang)
		{
			case "aa" : return "Afaraf (Afar)";
			case "ab" : return "Аҧсуа (Abkhazian)";
			case "ae" : return "avesta (Avestan)";
			case "af" : return "Afrikaans (Afrikaans)";
			case "ak" : return "Akan (Akan)";
			case "am" : return "አማርኛ (Amharic)";
			case "an" : return "Aragonés (Aragonese)";
			case "ar" : return "‫العربية (Arabic)";
			case "as" : return "অসমীয়া (Assamese)";
			case "av" : return "авар мацӀ; магӀарул мацӀ (Avaric)";
			case "ay" : return "aymar aru (Aymara)";
			case "az" : return "azərbaycan dili (Azerbaijani)";
			case "ba" : return "башҡорт теле (Bashkir)";
			case "be" : return "Беларуская (Belarusian)";
			case "bg" : return "български език (Bulgarian)";
			case "bh" : return "भोजपुरी (Bihari)";
			case "bi" : return "Bislama (Bislama)";
			case "bm" : return "bamanankan (Bambara)";
			case "bn" : return "বাংলা (Bengali)";
			case "bo" : return "བོད་ཡིག (Tibetan)";
			case "br" : return "brezhoneg (Breton)";
			case "bs" : return "bosanski jezik (Bosnian)";
			case "ca" : return "Català (Catalan)";
			case "ce" : return "нохчийн мотт (Chechen)";
			case "ch" : return "Chamoru (Chamorro)";
			case "co" : return "corsu; lingua corsa (Corsican)";
			case "cr" : return "ᓀᐦᐃᔭᐍᐏᐣ (Cree)";
			case "cs" : return "česky; čeština (Czech)";
			case "cu" : return " (Church Slavic)";
			case "cv" : return "чӑваш чӗлхи (Chuvash)";
			case "cy" : return "Cymraeg (Welsh)";
			case "da" : return "dansk (Danish)";
			case "de" : return "Deutsch (German)";
			case "dv" : return "‫ދިވެހި (Divehi)";
			case "dz" : return "རྫོང་ཁ (Dzongkha)";
			case "ee" : return "Ɛʋɛgbɛ (Ewe)";
			case "el" : return "Ελληνικά (Greek)";
			case "eo" : return "Esperanto (Esperanto)";
			case "es" : return "español; castellano (Spanish)";
			case "et" : return "Eesti keel (Estonian)";
			case "eu" : return "euskara (Basque)";
			case "fa" : return "‫فارسی (Persian)";
			case "ff" : return "Fulfulde (Fulah)";
			case "fi" : return "suomen kieli (Finnish)";
			case "fj" : return "vosa Vakaviti (Fijian)";
			case "fo" : return "Føroyskt (Faroese)";
			case "fy" : return "Frysk (Western Frisian)";
			case "ga" : return "Gaeilge (Irish)";
			case "gd" : return "Gàidhlig (Scottish Gaelic)";
			case "gl" : return "Galego (Galician)";
			case "gn" : return "Avañe'ẽ (Guaraní)";
			case "gu" : return "ગુજરાતી (Gujarati)";
			case "gv" : return "Ghaelg (Manx)";
			case "ha" : return "‫هَوُسَ (Hausa)";
			case "he" : return "‫עברית (Hebrew)";
			case "hi" : return "हिन्दी; हिंदी (Hindi)";
			case "ho" : return "Hiri Motu (Hiri Motu)";
			case "hr" : return "Hrvatski (Croatian)";
			case "ht" : return "Kreyòl ayisyen (Haitian)";
			case "hu" : return "Magyar (Hungarian)";
			case "hy" : return "Հայերեն (Armenian)";
			case "hz" : return "Otjiherero (Herero)";
			case "ia" : return "interlingua (Interlingua (International Auxiliary Language Association))";
			case "id" : return "Bahasa Indonesia (Indonesian)";
			case "ie" : return "Interlingue (Interlingue)";
			case "ig" : return "Igbo (Igbo)";
			case "ii" : return "ꆇꉙ (Sichuan Yi)";
			case "ik" : return "Iñupiaq; Iñupiatun (Inupiaq)";
			case "io" : return "Ido (Ido)";
			case "is" : return "Íslenska (Icelandic)";
			case "it" : return "Italiano (Italian)";
			case "iu" : return "ᐃᓄᒃᑎᑐᑦ (Inuktitut)";
			case "ja" : return "日本語 (にほんご／にっぽんご) (Japanese)";
			case "jv" : return "basa Jawa (Javanese)";
			case "ka" : return "ქართული (Georgian)";
			case "kg" : return "KiKongo (Kongo)";
			case "ki" : return "Gĩkũyũ (Kikuyu)";
			case "kj" : return "Kuanyama (Kwanyama)";
			case "kk" : return "Қазақ тілі (Kazakh)";
			case "kl" : return "kalaallisut; kalaallit oqaasii (Kalaallisut)";
			case "km" : return "ភាសាខ្មែរ (Khmer)";
			case "kn" : return "ಕನ್ನಡ (Kannada)";
			case "ko" : return "한국어 (韓國語); 조선말 (朝鮮語) (Korean)";
			case "kr" : return "Kanuri (Kanuri)";
			case "ks" : return "कश्मीरी; كشميري‎ (Kashmiri)";
			case "ku" : return "Kurdî; كوردی‎ (Kurdish)";
			case "kv" : return "коми кыв (Komi)";
			case "kw" : return "Kernewek (Cornish)";
			case "ky" : return "кыргыз тили (Kirghiz)";
			case "la" : return "latine; lingua latina (Latin)";
			case "lb" : return "Lëtzebuergesch (Luxembourgish)";
			case "lg" : return "Luganda (Ganda)";
			case "li" : return "Limburgs (Limburgish)";
			case "ln" : return "Lingála (Lingala)";
			case "lo" : return "ພາສາລາວ (Lao)";
			case "lt" : return "lietuvių kalba (Lithuanian)";
			case "lu" : return " (Luba-Katanga)";
			case "lv" : return "latviešu valoda (Latvian)";
			case "mg" : return "Malagasy fiteny (Malagasy)";
			case "mh" : return "Kajin M̧ajeļ (Marshallese)";
			case "mi" : return "te reo Māori (Māori)";
			case "mk /sl" : return "македонски јазик (Macedonian)";
			case "ml" : return "മലയാളം (Malayalam)";
			case "mn" : return "Монгол (Mongolian)";
			case "mo" : return "лимба молдовеняскэ (Moldavian)";
			case "mr" : return "मराठी (Marathi)";
			case "ms" : return "bahasa Melayu; بهاس ملايو‎ (Malay)";
			case "mt" : return "Malti (Maltese)";
			case "my" : return "ဗမာစာ (Burmese)";
			case "na" : return "Ekakairũ Naoero (Nauru)";
			case "nb" : return "Norsk bokmål (Norwegian Bokmål)";
			case "nd" : return "isiNdebele (North Ndebele)";
			case "ne" : return "नेपाली (Nepali)";
			case "ng" : return "Owambo (Ndonga)";
			case "nl" : return "Nederlands (Dutch)";
			case "nn" : return "Norsk nynorsk (Norwegian Nynorsk)";
			case "no" : return "Norsk (Norwegian)";
			case "nr" : return "Ndébélé (South Ndebele)";
			case "nv" : return "Diné bizaad; Dinékʼehǰí (Navajo)";
			case "ny" : return "chiCheŵa; chinyanja (Chichewa)";
			case "oc" : return "Occitan (Occitan)";
			case "oj" : return "ᐊᓂᔑᓈᐯᒧᐎᓐ (Ojibwa)";
			case "om" : return "Afaan Oromoo (Oromo)";
			case "or" : return "ଓଡ଼ିଆ (Oriya)";
			case "os" : return "Ирон æвзаг (Ossetian)";
			case "pa" : return "ਪੰਜਾਬੀ; پنجابی‎ (Panjabi)";
			case "pi" : return "पािऴ (Pāli)";
			case "pl" : return "polski (Polish)";
			case "ps" : return "‫پښتو (Pashto)";
			case "pt" : return "Português (Portuguese)";
			case "qu" : return "Runa Simi; Kichwa (Quechua)";
			case "rm" : return "rumantsch grischun (Raeto-Romance)";
			case "rn" : return "kiRundi (Kirundi)";
			case "ro" : return "română (Romanian)";
			case "ru" : return "русский язык (Russian)";
			case "rw" : return "Kinyarwanda (Kinyarwanda)";
			case "ry" : return "русинськый язык (Rusyn)";
			case "sa" : return "संस्कृतम् (Sanskrit)";
			case "sc" : return "sardu (Sardinian)";
			case "sd" : return "सिन्धी; ‫سنڌي، سندھی‎ (Sindhi)";
			case "se" : return "Davvisámegiella (Northern Sami)";
			case "sg" : return "yângâ tî sängö (Sango)";
			case "sh" : return "Srpskohrvatski/Српскохрватски (Serbo-Croatian)";
			case "si" : return "සිංහල (Sinhalese)";
			case "sk" : return "slovenčina (Slovak)";
			case "sl" : return "slovenščina (Slovenian)";
			case "sm" : return "gagana fa'a Samoa (Samoan)";
			case "sn" : return "chiShona (Shona)";
			case "so" : return "Soomaaliga; af Soomaali (Somali)";
			case "sq" : return "Shqip (Albanian)";
			case "sr" : return "српски језик (Serbian)";
			case "ss" : return "SiSwati (Swati)";
			case "st" : return "seSotho (Sotho)";
			case "su" : return "Basa Sunda (Sundanese)";
			case "sv" : return "Svenska (Swedish)";
			case "sw" : return "Kiswahili (Swahili)";
			case "ta" : return "தமிழ் (Tamil)";
			case "te" : return "తెలుగు (Telugu)";
			case "tg" : return "тоҷикӣ; toğikī; ‫تاجیکی‎ (Tajik)";
			case "th" : return "ไทย (Thai)";
			case "ti" : return "ትግርኛ (Tigrinya)";
			case "tk" : return "Türkmen; Түркмен (Turkmen)";
			case "tl" : return "Tagalog (Tagalog)";
			case "tn" : return "seTswana (Tswana)";
			case "to" : return "faka Tonga (Tonga)";
			case "tr" : return "Türkçe (Turkish)";
			case "ts" : return "xiTsonga (Tsonga)";
			case "tt" : return "татарча; tatarça; ‫تاتارچا‎ (Tatar)";
			case "tw" : return "Twi (Twi)";
			case "ty" : return "Reo Mā`ohi (Tahitian)";
			case "ug" : return "Uyƣurqə; ‫ئۇيغۇرچ ‎ (Uighur)";
			case "uk" : return "Українська (Ukrainian)";
			case "ur" : return "‫اردو (Urdu)";
			case "uz" : return "O'zbek; Ўзбек; أۇزبېك‎ (Uzbek)";
			case "ve" : return "tshiVenḓa (Venda)";
			case "vi" : return "Tiếng Việt (Vietnamese)";
			case "vo" : return "Volapük (Volapük)";
			case "wa" : return "Walon (Walloon)";
			case "wo" : return "Wollof (Wolof)";
			case "xh" : return "isiXhosa (Xhosa)";
			case "yi" : return "‫ייִדיש (Yiddish)";
			case "yo" : return "Yorùbá (Yoruba)";
			case "za" : return "Saɯ cueŋƅ; Saw cuengh (Zhuang)";
			case "zh" : return "中文, 汉语, 漢語 (Chinese)";
			case "zu" : return "isiZulu (Zulu)";
			
			case "en" : return "English (English)";
			case "fr" : return "Français (French)";
		}
	}
}
?>