INSERT INTO `PREFIX_hook` (`id_hook`, `name`, `title`, `description`, `position`) VALUES 
(1, 'payment', 'Payment', NULL, 1),
(2, 'newOrder', 'New orders', NULL, 0),
(3, 'paymentConfirm', 'Payment confirmation', NULL, 0),
(4, 'paymentReturn', 'Payment return', NULL, 0),
(5, 'updateQuantity', 'Quantity update', 'Quantity is updated only when the customer effectively <b>place</b> his order.', 0),
(6, 'rightColumn', 'Right column blocks', NULL, 1),
(7, 'leftColumn', 'Left column blocks', NULL, 1),
(8, 'home', 'Homepage content', NULL, 1),
(9, 'header', 'Header', 'Add blocks in the header', 1),
(10, 'cart', 'Cart creation and update', NULL, 0),
(11, 'authentication', 'Successful customer authentication', NULL, 0),
(12, 'addproduct', 'Product creation', NULL, 0),
(13, 'updateproduct', 'Product Update', NULL, 0),
(14, 'top', 'A hook which allow you to do things a the top of each pages.', NULL, 0),
(15, 'extra', 'Extra actions on the product page.', NULL, 0),
(16, 'deleteproduct', 'Product deletion', NULL, 0),
(17, 'productfooter', 'Product footer', 'Add new blocks under the product description', 1),
(18, 'invoice', 'Invoice', 'Add blocks to invoice (order)', 1),
(19, 'updateOrderStatus', 'Order''s status update event', 'Launch modules when the order''s status of an order change.', 0),
(20, 'adminOrder', 'Display in Back-Office, tab AdminOrder', 'Launch modules when the tab AdminOrder is displayed on back-office.', 0),
(21, 'footer', 'Footer', 'Add block in footer', 1),
(22, 'PDFInvoice', 'PDF Invoice', 'Allow the display of extra informations into the PDF invoice', 0);

INSERT INTO `PREFIX_configuration` (`name`, `value`, `date_add`, `date_upd`) VALUES
('PS_LANG_DEFAULT', '1', NOW(), NOW()),
('PS_CURRENCY_DEFAULT', '1', NOW(), NOW()),
('PS_COUNTRY_DEFAULT', '8', NOW(), NOW()),
('PS_REWRITING_SETTINGS', '0', NOW(), NOW()),
('PS_ORDER_OUT_OF_STOCK', '0', NOW(), NOW()),
('PS_LAST_QTIES', '3', NOW(), NOW()),
('PS_CART_REDIRECT', '1', NOW(), NOW()),
('PS_HELPBOX', '1', NOW(), NOW()),
('PS_CONDITIONS', '1', NOW(), NOW()),
('PS_RECYCLABLE_PACK', '1', NOW(), NOW()),
('PS_GIFT_WRAPPING', '1', NOW(), NOW()),
('PS_STOCK_MANAGEMENT', '1', NOW(), NOW()),
('PS_NAVIGATION_PIPE', '>', NOW(), NOW()),
('PS_PRODUCTS_PER_PAGE', '10', NOW(), NOW()),
('PS_PURCHASE_MINIMUM', '0', NOW(), NOW()),
('PS_PRODUCTS_ORDER_WAY', '0', NOW(), NOW()),
('PS_PRODUCTS_ORDER_BY', '0', NOW(), NOW()),
('PS_DISPLAY_QTIES', '1', NOW(), NOW()),
('PS_SHIPPING_HANDLING', '2', NOW(), NOW()),
('PS_SHIPPING_FREE_PRICE', '20000', NOW(), NOW()),
('PS_SHIPPING_FREE_WEIGHT', '20000', NOW(), NOW()),
('PS_SHIPPING_METHOD', '1', NOW(), NOW()),
('PS_TAX', '1', NOW(), NOW()),
('PS_SHOP_ENABLE', '1', NOW(), NOW());

INSERT INTO `PREFIX_lang` (`id_lang`, `name`, `active`, `iso_code`) VALUES
(1, 'English', 1, 'en'),
(2, 'Français', 1, 'fr');

INSERT INTO `PREFIX_category` VALUES
(1, 0, 0, 1, NOW(), NOW());
INSERT INTO `PREFIX_category_lang` VALUES
(1, 1, 'Home', '', '', NULL, NULL, NULL),
(1, 2, 'Accueil', '', '', NULL, NULL, NULL),
(1, 3, 'Home', '', '', NULL, NULL, NULL);

INSERT INTO `PREFIX_order_state` (`id_order_state`, `invoice`, `send_email`, `color`, `unremovable`, `logable`) VALUES
(1, 0, 1, 'lightblue', 1, 0),
(2, 1, 1, '#DDEEFF', 1, 1),
(3, 1, 1, '#FFDD99', 1, 1),
(4, 1, 1, '#EEDDFF', 1, 1),
(5, 1, 0, '#DDFFAA', 1, 1),
(6, 0, 1, '#DADADA', 1, 0),
(7, 1, 1, '#FFFFBB', 1, 0),
(8, 0, 1, '#FFDFDF', 1, 0),
(9, 1, 1, '#FFD3D3', 1, 0),
(10, 0, 1, 'lightblue', 1, 0);

INSERT INTO `PREFIX_order_state_lang` (`id_order_state`, `id_lang`, `name`, `template`) VALUES  
(1, 1, 'Awaiting cheque payment', 'cheque'),
(2, 1, 'Payment accepted', 'payment'),
(3, 1, 'Preparation in progress', 'preparation'),
(4, 1, 'Shipping', 'shipping'),
(5, 1, 'Delivered', ''),
(6, 1, 'Canceled', 'order_canceled'),
(7, 1, 'Refund', 'refund'),
(8, 1, 'Payment error', 'payment_error'),
(9, 1, 'Out of stock', 'outofstock'),
(10, 1, 'Awaiting bank wire payment', 'bankwire'),
(1, 2, 'En attente du paiement par chèque', 'cheque'),
(2, 2, 'Paiement accepté', 'payment'),
(3, 2, 'Préparation en cours', 'preparation'),
(4, 2, 'En cours de livraison', 'shipping'),
(5, 2, 'Livré', ''),
(6, 2, 'Annulé', 'order_canceled'),
(7, 2, 'Remboursé', 'refund'),
(8, 2, 'Erreur de paiement', 'payment_error'),
(9, 2, 'Produit(s) indisponibles', 'outofstock'),
(10, 2, 'En attente du paiement par virement bancaire', 'bankwire');

INSERT INTO `PREFIX_zone` (`id_zone`, `name`, `active`, `enabled`) VALUES	
(1, 'Europe', 1, 1),
(2, 'US', 1, 1);

INSERT INTO `PREFIX_country` (`id_country`, `id_zone`, `iso_code`, `active`) VALUES
(1, 1, 'DE', 1),
(2, 1, 'AT', 1),
(3, 1, 'BE', 1),
(4, 2, 'CA', 1),
(5, 3, 'CN', 1),
(6, 1, 'ES', 1),
(7, 1, 'FI', 1),
(8, 1, 'FR', 1),
(9, 1, 'GR', 1),
(10, 1, 'IT', 1),
(11, 3, 'JP', 1),
(12, 1, 'LU', 1),
(13, 1, 'NL', 1),
(14, 1, 'PL', 1),
(15, 1, 'PT', 1),
(16, 1, 'CZ', 1),
(17, 1, 'GB', 1),
(18, 1, 'SE', 1),
(19, 1, 'CH', 1),
(20, 1, 'DK', 1),
(21, 2, 'US', 1),
(22, 3, 'HK', 1),
(23, 1, 'NO', 1),
(24, 3, 'AU', 1),
(25, 3, 'SG', 1),
(26, 1, 'IE', 1),
(27, 3, 'NZ', 1),
(28, 3, 'KR', 1),
(29, 3, 'IL', 1),
(30, 1, 'NL', 1);

INSERT INTO `PREFIX_country_lang` (`id_country`, `id_lang`, `name`) VALUES
(1, 1, 'Germany'),
(1, 2, 'Allemagne'),
(2, 1, 'Austria'),
(2, 2, 'Autriche'),
(3, 1, 'Belgium'),
(3, 2, 'Belgique'),
(4, 1, 'Canada'),
(4, 2, 'Canada'),
(5, 1, 'China'),
(5, 2, 'Chine'),
(6, 1, 'Spain'),
(6, 2, 'Espagne'),
(7, 1, 'Finland'),
(7, 2, 'Finlande'),
(8, 1, 'France'),
(8, 2, 'France'),
(9, 1, 'Greece'),
(9, 2, 'Grèce'),
(10, 1, 'Italy'),
(10, 2, 'Italie'),
(11, 1, 'Japan'),
(11, 2, 'Japon'),
(12, 1, 'Luxemburg'),
(12, 2, 'Luxembourg'),
(13, 1, 'The Netherlands'),
(13, 2, 'Pays-bas'),
(14, 1, 'Poland'),
(14, 2, 'Pologne'),
(15, 1, 'Portugal'),
(15, 2, 'Portugal'),
(16, 1, 'Czech Republic'),
(16, 2, 'République Tchèque'),
(17, 1, 'United Kingdom'),
(17, 2, 'Royaume-Uni'),
(18, 1, 'Sweden'),
(18, 2, 'Suède'),
(19, 1, 'Switzerland'),
(19, 2, 'Suisse'),
(20, 1, 'Denmark'),
(20, 2, 'Danemark'),
(21, 1, 'USA'),
(21, 2, 'USA'),
(22, 1, 'HongKong'),
(22, 2, 'Hong-Kong'),
(23, 1, 'Norway'),
(23, 2, 'Norvège'),
(24, 1, 'Australia'),
(24, 2, 'Australie'),
(25, 1, 'Singapore'),
(25, 2, 'Singapour'),
(26, 1, 'Irelande'),
(26, 2, 'Eire'),
(27, 1, 'New Zealand'),
(27, 2, 'Nouvelle-Zélande'),
(28, 1, 'South Korea'),
(28, 2, 'Corée du Sud'),
(29, 1, 'Israel'),
(29, 2, 'Israël'),
(30, 1, 'Netherlands'),
(30, 2, 'Pays-Bas');

INSERT INTO `PREFIX_currency` (name, iso_code, sign, conversion_rate, format, deleted) VALUES
('Euro', 'EUR', '&euro;', 1, 2, 0), 
('Dollar', 'USD', '$', 1.47, 1, 0);

INSERT INTO `PREFIX_tax` (`id_tax`, `rate`) VALUES
(1, 19.6),
(2, 5.5);
INSERT INTO `PREFIX_tax_lang` (`id_tax`, `id_lang`, `name`) VALUES
(1, 1, 'VAT 19.6%'),
(1, 2, 'TVA 19.6%'),
(2, 1, 'VAT 5.5%'),
(2, 2, 'TVA 5.5%');
INSERT INTO `PREFIX_tax_zone` (`id_tax`, `id_zone`) VALUES
(1, 1),
(2, 1);
 
INSERT INTO `PREFIX_image_type` (`id_image_type`, `name`, `width`, `height`, `products`, `categories`) VALUES
(1, 'small', 45, 45, 1, 1),
(2, 'medium', 90, 90, 1, 1),
(3, 'large', 250, 250, 1, 1);

INSERT INTO `PREFIX_contact_lang` (`id_contact`, `id_lang`, `name`, `description`) VALUES
(1, 1, 'Webmaster', 'If a technical problem occurs on this website'),
(1, 2, 'Webmaster', 'Si un problème technique survient sur le site'),
(2, 1, 'Customer service', 'For any question about a product, an order'),
(2, 2, 'Service client', 'Pour toute question ou réclamation sur une commande');
		
INSERT INTO `PREFIX_discount_type` (`id_discount_type`) VALUES (1),(2),(3);
INSERT INTO `PREFIX_discount_type_lang` (`id_discount_type`, `id_lang`, `name`) VALUES
(1, 1, 'Discount on order (%)'),
(2, 1, 'Discount on order (amount)'),
(1, 2, 'Réduction sur la commande (%)'),
(2, 2, 'Réduction sur la commande (montant)'),
(3, 1, 'Free shipping'),
(3, 2, 'Frais de port gratuits');

INSERT INTO `PREFIX_access` (`id_access`, `id_profile`, `id_tab`, `view`, `add`, `edit`, `delete`) VALUES 
(1, 1, 1, 1, 1, 1, 1),
(2, 1, 2, 1, 1, 1, 1),
(3, 1, 3, 1, 1, 1, 1),
(4, 1, 4, 1, 1, 1, 1),
(5, 1, 5, 1, 1, 1, 1),
(6, 1, 6, 1, 1, 1, 1),
(7, 1, 7, 1, 1, 1, 1),
(8, 1, 8, 1, 1, 1, 1),
(9, 1, 9, 1, 1, 1, 1),
(10, 1, 10, 1, 1, 1, 1),
(11, 1, 11, 1, 1, 1, 1),
(12, 1, 12, 1, 1, 1, 1),
(13, 1, 13, 1, 1, 1, 1),
(14, 1, 14, 1, 1, 1, 1),
(15, 1, 15, 1, 1, 1, 1),
(16, 1, 16, 1, 1, 1, 1),
(17, 1, 17, 1, 1, 1, 1),
(18, 1, 18, 1, 1, 1, 1),
(19, 1, 19, 1, 1, 1, 1),
(20, 1, 20, 1, 1, 1, 1),
(21, 1, 21, 1, 1, 1, 1),
(22, 1, 22, 1, 1, 1, 1),
(23, 1, 23, 1, 1, 1, 1),
(24, 1, 24, 1, 1, 1, 1),
(26, 1, 26, 1, 1, 1, 1),
(27, 1, 27, 1, 1, 1, 1),
(28, 1, 28, 1, 1, 1, 1),
(29, 1, 29, 1, 1, 1, 1),
(30, 1, 30, 1, 1, 1, 1),
(31, 1, 31, 1, 1, 1, 1),
(32, 1, 32, 1, 1, 1, 1),
(33, 1, 33, 1, 1, 1, 1),
(34, 1, 34, 1, 1, 1, 1),
(35, 1, 35, 1, 1, 1, 1),
(36, 1, 36, 1, 1, 1, 1),
(37, 1, 37, 1, 1, 1, 1),
(38, 1, 38, 1, 1, 1, 1),
(39, 1, 39, 1, 1, 1, 1),
(40, 1, 40, 1, 1, 1, 1),
(41, 1, 41, 1, 1, 1, 1);

INSERT INTO `PREFIX_profile` (`id_profile`) VALUES (1);
INSERT INTO `PREFIX_profile_lang` (`id_profile`, `id_lang`, `name`) VALUES
(1, 1, 'Administrator'), 
(1, 2, 'Administrateur');

INSERT INTO `PREFIX_tab` (`id_tab`, `class_name`, `id_parent`, `position`) VALUES 
(1, 'AdminCatalog', 0, 1),
(2, 'AdminCustomers', 0, 2),
(3, 'AdminOrders', 0, 3),
(4, 'AdminPayment', 0, 4),
(5, 'AdminShipping', 0, 5),
(6, 'AdminStats', 0, 6),
(7, 'AdminModules', 0, 7),
(8, 'AdminPreferences', 0, 8),
(9, 'AdminTools', 0, 9),
(10, 'AdminManufacturers', 1, 1),
(34, 'AdminSuppliers', 1, 2),
(11, 'AdminAttributesGroups', 1, 3),
(36, 'AdminFeatures', 1, 4),
(12, 'AdminAddresses', 2, 1),
(13, 'AdminOrdersStates', 3, 1),
(14, 'AdminDiscounts', 4, 3),
(15, 'AdminCurrencies', 4, 1),
(16, 'AdminTaxes', 4, 2),
(17, 'AdminCarriers', 5, 1),
(18, 'AdminCountries', 5, 2),
(19, 'AdminZones', 5, 3),
(20, 'AdminRangePrice', 5, 4),
(21, 'AdminRangeWeight', 5, 5),
(22, 'AdminModulesPositions', 7, 1),
(39, 'AdminContact', 8, 1),
(38, 'AdminAppearance', 8, 2),
(27, 'AdminPPreferences', 8, 3),
(24, 'AdminEmails', 8, 4),
(26, 'AdminImages', 8, 5),
(23, 'AdminDb', 8, 6),
(28, 'AdminContacts', 9, 4),
(29, 'AdminEmployees', 9, 1),
(30, 'AdminProfiles', 9, 2),
(31, 'AdminAccess', 9, 3),
(32, 'AdminLanguages', 9, 5),
(33, 'AdminTranslations', 9, 6),
(35, 'AdminTabs', 9, 7),
(37, 'AdminQuickAccesses', 9, 8),
(40, 'AdminAliases', 9, 9),
(41, 'AdminImport', 9, 10);

INSERT INTO `PREFIX_tab_lang` (`id_lang`, `id_tab`, `name`) VALUES 
(1, 1, 'Catalog'),
(1, 2, 'Customers'),
(1, 3, 'Orders'),
(1, 4, 'Payment'),
(1, 5, 'Shipping'),
(1, 6, 'Stats'),
(1, 7, 'Modules'),
(1, 8, 'Preferences'),
(1, 9, 'Tools'),
(1, 10, 'Manufacturers'),
(1, 11, 'Attributes and groups'),
(1, 12, 'Addresses'),
(1, 13, 'Order statuses'),
(1, 14, 'Discounts'),
(1, 15, 'Currencies'),
(1, 16, 'Taxes'),
(1, 17, 'Carriers'),
(1, 18, 'Countries'),
(1, 19, 'Zones'),
(1, 20, 'Price ranges'),
(1, 21, 'Weight ranges'),
(1, 22, 'Positions'),
(1, 23, 'Database settings'),
(1, 24, 'Email settings'),
(1, 26, 'Image settings'),
(1, 27, 'Products settings'),
(1, 28, 'Contacts'),
(1, 29, 'Employees'),
(1, 30, 'Profiles'),
(1, 31, 'Permissions'),
(1, 32, 'Languages'),
(1, 33, 'Translations'),
(1, 34, 'Suppliers'),
(1, 35, 'Tabs'),
(1, 36, 'Features'),
(1, 37, 'Quick Accesses'),
(1, 38, 'Appearance'),
(1, 39, 'Contact'),
(1, 40, 'Aliases'),
(1, 41, 'Import'),
(2, 1, 'Catalogue'),
(2, 2, 'Clients'),
(2, 3, 'Commandes'),
(2, 4, 'Paiement'),
(2, 5, 'Transport'),
(2, 6, 'Stats'),
(2, 7, 'Modules'),
(2, 8, 'Préférences'),
(2, 9, 'Outils'),
(2, 10, 'Fabricants'),
(2, 11, 'Attributs et groupes'),
(2, 12, 'Adresses'),
(2, 13, 'Statuts des commandes'),
(2, 14, 'Bons de réduction'),
(2, 15, 'Devises'),
(2, 16, 'Taxes'),
(2, 17, 'Transporteurs'),
(2, 18, 'Pays'),
(2, 19, 'Zones'),
(2, 20, 'Tranches de prix'),
(2, 21, 'Tranches de poids'),
(2, 22, 'Positions'),
(2, 23, 'Base de données'),
(2, 24, 'Emails'),
(2, 26, 'Images'),
(2, 27, 'Produits'),
(2, 28, 'Contacts'),
(2, 29, 'Employés'),
(2, 30, 'Profils'),
(2, 31, 'Permissions'),
(2, 32, 'Langues'),
(2, 33, 'Traductions'),
(2, 34, 'Fournisseurs'),
(2, 35, 'Onglets'),
(2, 36, 'Caractéristiques'),
(2, 37, 'Accès rapide'),
(2, 38, 'Apparence'),
(2, 39, 'Coordonnées'),
(2, 40, 'Alias'),
(2, 41, 'Import');

INSERT INTO `PREFIX_quick_access` (`id_quick_access`, `link`) VALUES
(1, 'index.php'),
(2, '../'),
(3, 'index.php?tab=AdminCatalog&addcategory'),
(4, 'index.php?tab=AdminCatalog&addproduct'),
(5, 'index.php?tab=AdminDiscounts&adddiscount');

INSERT INTO `PREFIX_quick_access_lang` (`id_quick_access`, `id_lang`, `name`) VALUES
(1, 1, 'Home'),
(1, 2, 'Accueil'),
(2, 1, 'My Shop'),
(2, 2, 'Ma boutique'),
(3, 1, 'New category'),
(3, 2, 'Nouvelle catégorie'),
(4, 1, 'New product'),
(4, 2, 'Nouveau produit'),
(5, 1, 'New voucher'),
(5, 2, 'Nouveau bon de réduction');
