<?php
define('_PS_MAGIC_QUOTES_GPC_', get_magic_quotes_gpc());
define('_PS_MYSQL_REAL_ESCAPE_STRING_', function_exists('mysql_real_escape_string'));

include_once(INSTALL_PATH.'/classes/AddConfToFile.php');
include_once(INSTALL_PATH.'/../classes/Validate.php');
require_once(INSTALL_PATH.'/../classes/Db.php');
include_once(INSTALL_PATH.'/../classes/Tools.php');
require_once(INSTALL_PATH.'/../config/settings.inc.php');

function isFormValid() {
	global $error;
	$validInfos = true;
	foreach ($error as $anError) {
		if ($anError != "") $validInfos = false;
	}
	return $validInfos;
}

function flagCopy($isoCode, $id)
{
	if (!file_exists('../img/flags/'.$isoCode.'.png'))
		return true;
	if (!($source = imagecreatefrompng('../img/flags/'.$isoCode.'.png')))
		return true;
	imagejpeg($source, INSTALL_PATH.'/../img/l/'.$id.'.jpg');
	return true;
}

// Check each POST data...

$error = array();

if(!isset($_POST['infosShop']) OR empty($_POST['infosShop']))
	$error['infosShop'] = "0";
else
	$error['infosShop'] = "";

if(!isset($_POST['infosFirstname']) OR empty($_POST['infosFirstname']))
	$error['infosFirstname'] = "0";
else
	$error['infosFirstname'] = "";
	
if(!isset($_POST['infosName']) OR empty($_POST['infosName']))
	$error['infosName'] = "0";
else
	$error['infosName'] = "";
	
if(!Validate::isemail($_POST['infosEmail']))
	$error['infosEmail'] = "3";
else
	$error['infosEmail'] = "";
	
if(!isset($_POST['infosEmail']) OR empty($_POST['infosEmail']))
	$error['infosEmail'] = "0";

if(!isset($_POST['infosPassword'])
	OR empty($_POST['infosPassword'])
	OR !isset($_POST['infosPasswordRepeat'])
	OR empty($_POST['infosPasswordRepeat'])
	OR !Validate::isPasswd($_POST['infosPassword'])
	OR !Validate::isPasswd($_POST['infosPasswordRepeat']))
	$error['infosPassword'] = "0";
else
	$error['infosPassword'] = "";
	
if($error['infosPassword'] == "" && $_POST['infosPassword'] != $_POST['infosPasswordRepeat'])
	$error['infosPassword'] = "2";
	
if($error['infosPassword'] == "" && strlen($_POST['infosPassword']) < 8)
	$error['infosPassword'] = "12";

/////////////////////////////
// IF ALL IS OK DO THE NEXT//
/////////////////////////////


// set Languages
$error['infosLanguages'] = "";
if(isFormValid()){
	$idDefault = array_search($_POST['infosDL'][0], $_POST['infosWL'])+1;
	
	//prepare the requests
	require_once(INSTALL_PATH.'/classes/ToolsInstall.php');
	$sqlLanguages = array();
	$dbInstance = Db::getInstance();
	$sqlLanguages[] = "UPDATE `"._DB_PREFIX_."configuration` SET `value` = '".$idDefault."' WHERE `"._DB_PREFIX_."configuration`.`id_configuration` =1";
	$sqlLanguages[] = "TRUNCATE TABLE `"._DB_PREFIX_."lang`";
	
	foreach ($_POST['infosWL'] as $wl){
		$sqlLanguages[] = "INSERT INTO `"._DB_PREFIX_."lang` (`id_lang` ,`name` ,`active` ,`iso_code`)VALUES (NULL , '".ToolsInstall::getLangString($wl)."', '1', '".pSQL($wl)."')";
	}
	foreach($sqlLanguages as $query){
		if(!Db::getInstance()->Execute($query)){
			$error['infosLanguages'] = "11";
			//echo Db::getInstance()->getMsgError();
			//echo Db::getInstance()->getNumberError();
			//echo $query;
		}
	}

	// Flags copy
	if(!$languagesId = Db::getInstance()->ExecuteS('SELECT `id_lang`, `iso_code` FROM `'._DB_PREFIX_.'lang`'))
		$error['infosLanguages'] = '11';
	if (!isset($error['infosLanguages']) OR empty($error['infosLanguages']))
		foreach ($languagesId AS $language)
			if (!flagCopy($language['iso_code'], $language['id_lang']))
				$error['infosLanguages'] = '37';
	unset($dbInstance);
}

// Mail Notification
$error['infosNotification'] = "";
if (isFormValid()){
	if (isset($_POST['infosNotification']) && $_POST['infosNotification'] == 'on') {
		require_once INSTALL_PATH."/classes/ToolsInstall.php";
		$smtpChecked = (trim($_POST['infosMailMethod']) ==  'smtp');
		$smtpServer = $_POST['smtpSrv'];
		$subject = $_POST['infosShop']." - " . $_POST['mailSubject'];
		$type = "text/html";
		$to =  $_POST['infosEmail'];
		$from = "no-reply@".$_SERVER["HTTP_HOST"];
		$smtpLogin = $_POST['smtpLogin'];
		$smtpPassword = $_POST['smtpPassword'];
		$smtpPort = $_POST['smtpPort'];//'default','secure'
		$smtpEncryption = $_POST['smtpEnc'];//"tls","ssl","off"
		$content = ToolsInstall::getNotificationMail($_POST['infosShop'], INSTALLER__PS_BASE_URI_ABSOLUTE, INSTALLER__PS_BASE_URI_ABSOLUTE."img/logo.jpg", strtoupper($_POST['infosName']), $_POST['infosFirstname'], $_POST['infosPassword'], $_POST['infosEmail']);

		$result = @ToolsInstall::sendMail($smtpChecked, $smtpServer, $content, $subject, $type, $to, $from, $smtpLogin, $smtpPassword, $smtpPort, $smtpEncryption);
	}
}

//Insert configuration parameters into the database
$error['infosInsertSQL'] = "";
if (isFormValid()){
	$sqlParams = array();
	$dbInstance = Db::getInstance();
	$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_SHOP_NAME', '".pSQL($_POST['infosShop'])."', NOW(), NOW())";
	$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_SHOP_EMAIL', '".pSQL($_POST['infosEmail'])."', NOW(), NOW())";
	$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_METHOD', '".pSQL($_POST['infosMailMethod'] == "smtp" ? "2": "1")."', NOW(), NOW())";
	if (isset($_POST['infosMailMethod']) AND $_POST['infosMailMethod'] == "smtp"){
		$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_SERVER', '".pSQL($_POST['smtpSrv'])."', NOW(), NOW())";
		$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_USER', '".pSQL($_POST['smtpLogin'])."', NOW(), NOW())";
		$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_PASSWD', '".pSQL($_POST['smtpPassword'])."', NOW(), NOW())";
		$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_SMTP_ENCRYPTION', '".pSQL($_POST['smtpEnc'])."', NOW(), NOW())";
		$sqlParams[] = "INSERT INTO "._DB_PREFIX_."configuration (name, value, date_add, date_upd) VALUES ('PS_MAIL_SMTP_PORT', '".pSQL($_POST['smtpPort'])."', NOW(), NOW())";
	}
	$sqlParams[] = 'INSERT INTO '._DB_PREFIX_.'employee (id_employee, name, surname, email, passwd, active, id_profile) VALUES (NULL, \''.pSQL(strtoupper($_POST['infosName'])).'\', \''.pSQL($_POST['infosFirstname']).'\', \''.pSQL($_POST['infosEmail']).'\', \''.md5(pSQL(_COOKIE_KEY_.$_POST['infosPassword'])).'\', 1, 1)';
	$sqlParams[] = 'INSERT INTO '._DB_PREFIX_.'contact (id_contact, email) VALUES (NULL, \''.pSQL($_POST['infosEmail']).'\'), (NULL, \''.pSQL($_POST['infosEmail']).'\')';
	
	foreach($sqlParams as $query){
		if(!$dbInstance->Execute($query)){
			$error['infosInsertSQL'] = "11";
			//echo Db::getInstance()->getMsgError();
			//echo Db::getInstance()->getNumberError();
			//echo $query;
		}
	}
	unset($dbInstance);
}

//////////////////////////
// Building XML Response//
//////////////////////////

echo '<shopConfig>'."\n";
foreach ($error AS $key => $line)
	echo '<field id="'.$key.'" result="'.( $line != "" ? 'fail' : 'ok').'" error="'.$line.'" />'."\n";
echo '</shopConfig>';
?>
