<?php
$filePrefix = "PREFIX_";

function flagCopy($isoCode, $id)
{
	if (!file_exists('../img/flags/'.$isoCode.'.png'))
		return true;
	if (!($source = imagecreatefrompng('../img/flags/'.$isoCode.'.png')))
		return true;
	imagejpeg($source, INSTALL_PATH.'/../img/l/'.$id.'.jpg');
	return true;
}

//old version detection
$oldversion = false;
if(file_exists(SETTINGS_FILE)){
	require_once(INSTALL_PATH."/../config/settings.inc.php");
	$oldversion =_PS_VERSION_;
} else die('<action result="fail" error="30" />'."\n");
$versionCompare =  version_compare(INSTALL_VERSION, _PS_VERSION_);
if($versionCompare == "-1") die('<action result="fail" error="27" />'."\n");
if($versionCompare == 0) die('<action result="fail" error="28" />'."\n");
if($versionCompare === false ) die('<action result="fail" error="29" />'."\n");

//check DB access
require_once(INSTALL_PATH.'/classes/ToolsInstall.php');
$resultDB = ToolsInstall::checkDB(_DB_SERVER_, _DB_USER_, _DB_PASSWD_, _DB_NAME_, false);
if ($resultDB !== true)	die("<action result='fail' error='".$resultDB."'/>\n");

//custom sql file creation
$upgradeFiles = array();
if ($handle = opendir(INSTALL_PATH.'/sql/upgrade')) {
    while (false !== ($file = readdir($handle))) {
        if ($file != "." && $file != "..") {
            $upgradeFiles[] = str_replace(".sql", "", $file);
        }
    }
    closedir($handle);
}
if(empty($upgradeFiles)) die('<action result="fail" error="31" />'."\n");
asort($upgradeFiles);
$neededUpgradeFiles = array();
foreach ($upgradeFiles as $version)
{
	if(version_compare($version, _PS_VERSION_) == 1 && version_compare(INSTALL_VERSION, $version) != -1){
		$neededUpgradeFiles[] = $version;
	}
}
if(empty($neededUpgradeFiles)) die('<action result="fail" error="32" />'."\n");

$sqlContent = "";
foreach($neededUpgradeFiles as $version)
{
	$file = INSTALL_PATH."/sql/upgrade/$version.sql";
	if(!file_exists($file))	die('<action result="fail" error="33" />'."\n");
	if ( !$sqlContent .= file_get_contents( $file ) ) die('<action result="fail" error="33" />'."\n");
	$sqlContent .= "\n";
}
$sqlContent = str_replace($filePrefix, _DB_PREFIX_, $sqlContent);
$sqlContent = preg_split("/;\s*[\r\n]+/",$sqlContent);

//refresh conf file
require_once(INSTALL_PATH.'/classes/AddConfToFile.php');
$oldLevel = error_reporting(E_ALL);
$datas = array(
	array('_DB_SERVER_', _DB_SERVER_),
	array('_DB_TYPE_', _DB_TYPE_),
	array('_DB_NAME_', _DB_NAME_),
	array('_DB_USER_', _DB_USER_),
	array('_DB_PASSWD_', _DB_PASSWD_),
	array('_DB_PREFIX_', _DB_PREFIX_),
	array('__PS_BASE_URI__', __PS_BASE_URI__),
	array('_THEME_NAME_', _THEME_NAME_),
	array('_COOKIE_KEY_', _COOKIE_KEY_),
	array('_COOKIE_IV_', _COOKIE_IV_),
	array('_PS_CREATION_DATE_', defined("_PS_CREATION_DATE_") ? _PS_CREATION_DATE_ : date('Y-m-d')),
	array('_PS_VERSION_', INSTALL_VERSION)
);
error_reporting($oldLevel);
$confFile = new AddConfToFile(SETTINGS_FILE, 'w');
if ($confFile->error)
	die('<action result="fail" error="'.$confFile->error.'" />'."\n");
	
foreach ($datas AS $data){
	$confFile->writeInFile($data[0], $data[1]);
}
$confFile->writeEndTagPhp();

if ($confFile->error != false)
	die('<action result="fail" error="'.$confFile->error.'" />'."\n");

//sql file execution
$requests = '';
$warningExist = false;

foreach($sqlContent as $query)
{
	$query = trim($query);
	if(!empty($query))
	{
		if(!Db::getInstance()->Execute($query))
		{
			$warningExist = true;
			$requests .=
'	<request result="fail">
		<sqlQuery><![CDATA['.htmlentities($query).']]></sqlQuery>
		<sqlMsgError><![CDATA['.htmlentities(Db::getInstance()->getMsgError()).']]></sqlMsgError>
		<sqlNumberError><![CDATA['.htmlentities(Db::getInstance()->getNumberError()).']]></sqlNumberError>
	</request>'."\n";
		}
		else
		{
			$requests .=
'	<request result="ok">
		<sqlQuery><![CDATA['.htmlentities($query).']]></sqlQuery>
	</request>'."\n";
		}
	}
}

// Flags copy
if(!$languagesId = Db::getInstance()->ExecuteS('SELECT `id_lang`, `iso_code` FROM `'._DB_PREFIX_.'lang`'))
	$error['infosLanguages'] = '11';
if (!isset($error['infosLanguages']) OR empty($error['infosLanguages']))
	foreach ($languagesId AS $language)
		if (!flagCopy($language['iso_code'], $language['id_lang']))
			$error['infosLanguages'] = '37';

$result = $warningExist ? '<action result="fail" error="34">'."\n" : '<action result="ok" error="">'."\n";
$result .= $requests;
die($result.'</action>'."\n");

?>