var id_language = Number(1);

function str2url(str,encoding,ucfirst)
{
	str = str.toUpperCase();
	str = str.toLowerCase();
	
	str = str.replace(/[\u00E0\u00E1\u00E2\u00E3\u00E4\u00E5]/g,'a');
	str = str.replace(/[\u00E7]/g,'c');
	str = str.replace(/[\u00E8\u00E9\u00EA\u00EB]/g,'e');
	str = str.replace(/[\u00EC\u00ED\u00EE\u00EF]/g,'i');
	str = str.replace(/[\u00F2\u00F3\u00F4\u00F5\u00F6\u00F8]/g,'o');
	str = str.replace(/[\u00F9\u00FA\u00FB\u00FC]/g,'u');
	str = str.replace(/[\u00FD\u00FF]/g,'y');
	str = str.replace(/[\u00F1]/g,'n');
	str = str.replace(/[\u0153]/g,'oe');
	str = str.replace(/[\u00E6]/g,'ae');
	str = str.replace(/[\u00DF]/g,'ss');
	
	str = str.replace(/[^a-z0-9_\s\'\:\/\[\]-]/g,'');
	str = str.replace(/[\s\'\:\/\[\]-]+/g,' ');
	str = str.replace(/[ ]/g,'-');
	
	if (ucfirst == 1) {
		c = str.charAt(0);
		str = c.toUpperCase()+str.slice(1);
	}
	
	return str;
}

function copy2friendlyURL()
{
	getE('link_rewrite_' + id_language).value = str2url(getE('name_' + id_language).value.replace(/^[0-9]+\./, ''), 'UTF-8');
}

function updateCurrentText(field)
{
	getE('current_product').innerHTML = getE(field).value;
	getE('current_product2').innerHTML = getE(field).value;
}

function updateFriendlyURL()
{
	getE('link_rewrite_' + id_language).value = str2url(getE('link_rewrite_' + id_language).value,'UTF-8');
	getE('friendly-url').innerHTML = getE('link_rewrite_' + id_language).value;
}

function	showLanguages(id)
{
	getE('languages_' + id).style.display = 'block';
}

function	changeLanguage(field, fieldsString, id_language_new, iso_code)
{
	var fields = fieldsString.split('¤');
	for (var i = 0; i < fields.length; ++i)
	{
		getE(fields[i] + '_' + id_language).style.display = 'none';
		getE(fields[i] + '_' + id_language_new).style.display = 'block';
		getE('language_current_' + fields[i]).src = '../img/flags/' + iso_code + '.png';
	}
 	getE('languages_' + field).style.display = 'none';
	id_language = id_language_new;
}

function checkAll(pForm)
{
	for (i = 0, n = pForm.elements.length; i < n; i++)
	{
		var objName = pForm.elements[i].name;
		var objType = pForm.elements[i].type;
		if (objType = 'checkbox' && objName != 'checkme')
		{
			box = eval(pForm.elements[i]);
			box.checked = !box.checked;
		}
	}
}

function checkDelBoxes(pForm, boxName, parent)
{	
	for (i = 0; i < pForm.elements.length; i++)
		if (pForm.elements[i].name == boxName)
			pForm.elements[i].checked = parent;
}

function getE(name)
{
	if (document.getElementById)
		var elem = document.getElementById(name);
	else if (document.all)
		var elem = document.all[name];
	else if (document.layers)
		var elem = document.layers[name];
	return elem;
}

function changeFormParam(pForm, url, gid)
{
	pForm.action = url;
	pForm.elements["groupid"].value = gid;
}

function addAccessory()
{
	var div = getE('divAccessories');
	var input = getE('inputAccessories');
	var name = getE('nameAccessories');
	var select = getE('selectAccessories');
	
	if (select.value == '0')
		return;
	var reg = new RegExp('\-', 'g');
	var cut = select.value.split(reg);
	select.selectedIndex = 0;

	input.value += cut[0] + '-';
	name.value += cut[1] + '¤';
	div.innerHTML += cut[1] + ' <span onclick="delAccessory(' + cut[0] + ');" style="cursor: pointer;"><img src="../img/admin/delete.gif" /></span><br />';
}

function delAccessory(id)
{
	var div = getE('divAccessories');
	var input = getE('inputAccessories');
	var name = getE('nameAccessories');

	var reg = new RegExp('-', 'g');
	var inputCut = input.value.split(reg);
	var reg2 = new RegExp('¤', 'g');
	var nameCut = name.value.split(reg2);
	
	input.value = '';
	name.value = '';
	div.innerHTML = '';

	for (var i = 0; i < inputCut.length; ++i)
		if (inputCut[i] && inputCut[i] != id)
		{
			input.value += inputCut[i] + '-';
			name.value += nameCut[i] + '¤';
			div.innerHTML += nameCut[i] + ' <span onclick="delAccessory(' + inputCut[i] + ');" style="cursor: pointer;"><img src="../img/admin/delete.gif" /></span><br />';
		}
}

function dontChange(srcText)
{
	if (srcText == '')
		return false;
	for (var i in search_texts)
		if (srcText == search_texts[i])
			return false;
	return true;
}

function queryType()
{
	var search_type = getE('bo_search_type').value;
	var bo_query = getE('bo_query');

	if (search_type == 1)
	{
		if (!dontChange(bo_query.value))
			bo_query.value = search_texts[0];
	}
	else if (search_type == 2)
	{
		if (!dontChange(bo_query.value))
			bo_query.value = search_texts[1];
	}
	else if (search_type == 3)
	{
		if (!dontChange(bo_query.value))
			bo_query.value = search_texts[2];
	}
}

function formSubmit(e, button)
{
	var key;

	key = window.event ? window.event.keyCode : e.which;
	if (key == 13)
	{
		getE(button).focus();
		getE(button).click();
	}
}

function	noComma(elem)
{
 	getE(elem).value = getE(elem).value.replace(new RegExp(',', 'g'), '.');
}

/* Help boxes */
function addLoadEvent(func) {
  var oldonload = window.onload;
  if (typeof window.onload != 'function') {
    window.onload = func;
  } else {
    window.onload = function() {
      oldonload();
      func();
    }
  }
}

function helpboxParser(current) {
 	// While the span exists and we didn't find the right one
	for (var j = 0; j < current.parentNode.getElementsByTagName('span').length; j++) {

		// For each attribut
		for(var k = 0; k < current.parentNode.getElementsByTagName('span')[j].attributes.length; k++)
			// If it's the attribut "name" and its value is "help_box"
			if (current.parentNode.getElementsByTagName('span')[j].attributes[k].name === 'name' && current.parentNode.getElementsByTagName('span')[j].attributes[k].nodeValue === 'help_box') {
				// We finaly found it
				return j;
			}
	}
	return -1;
}

function prepareInputsForHints() {
	var inputs = document.getElementsByTagName('input');
	var found;
	
	// For each input
	for (var i=0; i<inputs.length; i++) {
		// on focus, show the hint
		inputs[i].onfocus = function () {
			var id = helpboxParser(this);
			if (id > -1)
				this.parentNode.getElementsByTagName('span')[id].style.display = 'inline';
		}
		// when the cursor moves away from the field, hide the hint
		inputs[i].onblur = function () {
		 	var id = helpboxParser(this);
		 	if (id > -1)
				this.parentNode.getElementsByTagName('span')[id].style.display = 'none';
		}
	}
}
if (helpboxes)
	addLoadEvent(prepareInputsForHints);

function changePic(id_product, id_image)
{
 	if (id_image == -1)
 	{
 		getE('pic').style.display = 'none';
 		return;
 	}
 	getE('pic').style.display = 'block';
	getE('pic').src = '../img/p/'+parseInt(id_product)+'-'+parseInt(id_image)+'.jpg';
}

/* Code generator for Affiliation and vourchers */
function gencode(size) 
{
	getE('code').value = '';
	var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	for (var i = 1; i <= size; ++i)
		getE('code').value += chars.charAt(Math.floor(Math.random() * chars.length));
}

function free_shipping()
{
	if (getE('id_discount_type').value == 3 && getE('discount_value').value == '')
		getE('discount_value').value = '0';
}

var newWin = null;

function closeWin ()
{
	if (newWin != null)
		if (!newWin.closed)
			newWin.close();
}

function openWin(url, title, width, height, top, left)
{
	var options;
	var sizes;
	
	closeWin();
	options = 'toolbar=0, location=0, directories=0, statfr=no, menubar=0, scrollbars=yes, resizable=yes';
	sizes = 'width='+width+', height='+height+', top='+top+', left='+left+'';
	newWin = window.open(url, title, options+', '+sizes);
	newWin.focus();
}

function	viewTemplates(id_select, id_lang, prefix, ext)
{
	var id_list = document.getElementById(id_select);
	var loc = id_list.options[id_list.selectedIndex].value;
	if (loc != 0)
		openWin (prefix+loc+ext, 'tpl_viewing', '520', '400', '50', '300');
	return ;
}

function validateImportation(mandatory)
{
    var type_value = [];
	var seted_value = [];
	var elem;
	var col = 'unknow';
	
    for (i = 1; getE('type_value['+i+']'); i++)
    {
        elem = getE('type_value['+i+']');
		if (seted_value[elem.options[elem.selectedIndex].value])
		{
			scroll(0,0);
			document.getElementById('error_duplicate_type').style.display = 'block';
			return false;
		}
		else if (elem.options[elem.selectedIndex].value != 'no')
			seted_value[elem.options[elem.selectedIndex].value] = true;
    }
	for (needed in mandatory)
		if (!seted_value[mandatory[needed]])
		{
			scroll(0,0);
			getE('required_column').style.display = 'block';
			for (i in elem.options)
				if (elem.options[i].value == mandatory[needed])
					col = elem.options[i].innerHTML;
			getE('missing_column').innerHTML = col;
			return false
		}
	getE('import_form').submit();
}