<?php

include(dirname(__FILE__).'/config/config.inc.php');
include(dirname(__FILE__).'/header.php');
$errors = array();

$nArray = array(10, 20, 50);
$p = abs(intval(Tools::getValue('p', 1)));
if ($p < 0) $p = 0;
$n = abs(intval(Tools::getValue('n', intval(Configuration::get('PS_PRODUCTS_PER_PAGE')))));
if (!$n) $n = $nArray[0];

if ($id_manufacturer = Tools::getValue('id_manufacturer'))
{
	$orderByValues = array(0 => 'name', 1 => 'price', 2 => 'date_add');
	$orderWayValues = array(0 => 'ASC', 1 => 'DESC');
	$orderBy = strtolower(Tools::getValue('orderby', 
	$orderByValues[intval(Configuration::get('PS_PRODUCTS_ORDER_BY'))]));
	$orderWay = strtoupper(Tools::getValue('orderway', 
	$orderWayValues[intval(Configuration::get('PS_PRODUCTS_ORDER_WAY'))]));
	
	if (!in_array($orderWay, array('DESC', 'ASC'))) $orderWay = 'ASC';
	
	$id_manufacturer = intval($id_manufacturer);
	$manufacturer = new Manufacturer($id_manufacturer);
	if (!Validate::isLoadedObject($manufacturer))
		$errors[] = Tools::displayError('manufacturer does not exist');
	else
	{
		$nbProducts = $manufacturer->getProducts($id_manufacturer, NULL, NULL, NULL, $orderBy, $orderWay, true);
		if ($p > ($nbProducts / $n))
			$p = ceil($nbProducts / $n);
		$smarty->assign('pages_nb', ceil($nbProducts / intval($n)));
		$cproducts = $manufacturer->getProducts($id_manufacturer, intval($cookie->id_lang), intval($p), intval($n), $orderBy, $orderWay);
		$smarty->assign('nb_products', $nbProducts);
		$smarty->assign('products', (isset($cproducts) AND $cproducts) ? $cproducts : NULL);
		$smarty->assign('manufacturer', $manufacturer);
	}
	$smarty->assign('p', intval($p));
	$smarty->assign('n', intval($n));
	$orderby = strval(Tools::getValue('orderby'));
	$orderway = strval(Tools::getValue('orderway'));
	$smarty->assign('nArray', $nArray);
	$smarty->assign('errors', $errors);
	$smarty->assign('path', Tools::safeOutput($manufacturer->name));
	$smarty->display(_PS_THEME_DIR_.'manufacturer.tpl');
}
else
{
	$manufacturersData = Manufacturer::getManufacturers(true);
	$manufacturers = array();
	if ($manufacturersData)
		foreach ($manufacturersData AS $manufacturer)
		{
			if (!file_exists(_PS_MANU_IMG_DIR_.'/'.$manufacturer['id_manufacturer'].'-medium.jpg'))
				$manufacturer['image'] = Language::getIsoById($cookie->id_lang).'-default';
			else
				$manufacturer['image'] = $manufacturer['id_manufacturer'];
			$manufacturers[] = $manufacturer;
		}
	$nbManufacturers = ($manufacturers ? count($manufacturers) : 0);

	$smarty->assign('pages_nb', ceil($nbManufacturers / intval($n)));
	$smarty->assign('nbManufacturers', $nbManufacturers);
	$smarty->assign('manufacturers', $manufacturers);
	$smarty->display(_PS_THEME_DIR_.'manufacturer-list.tpl');
}

include(dirname(__FILE__).'/footer.php');

?>