<?php

class BlockBestSellers extends Module
{
	private $_html = '';
	private $_directory;
	private $_filename;
	private $_filename_http;
	private $_postErrors = array();

	function __construct()
    {
        $this->name = 'blockbestsellers';
        $this->tab = 'Blocks';
        $this->version = '1.1';

        parent::__construct();

        /* The parent construct is required for translations */
				$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Block best sellers');
        $this->description = $this->l('Add a block with the best sellers');
    }

    public function install()
    {
        if (!parent::install() OR
			!$this->registerHook('rightColumn') OR
			!$this->registerHook('newOrder') OR
			!$this->registerHook('updateOrderStatus') OR
			!ProductSale::fillProductSales())
				return false;
			return true;
    }


    function hookRightColumn($params)
    {
		global $smarty;
		$currency = new Currency(intval($params['cookie']->id_currency));
		$bestsellers = ProductSale::getBestSalesLight(intval($params['cookie']->id_lang), 0, 5);

		$best_sellers = array();
		if (!empty($bestsellers))
		{
			foreach ($bestsellers AS $bestseller)
			{
				$bestseller['price'] = Tools::displayPrice(Product::getPriceStatic(intval($bestseller['id_product'])), $currency);
				$best_sellers[] = $bestseller;
			}
		}

		$smarty->assign('best_sellers', $best_sellers);
		return $this->display(__FILE__, 'blockbestsellers.tpl');
	}
	
	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
	
	function hookNewOrder($params)
	{
		foreach ($params['cart']->getProducts() as $product)
			if ($params['orderStatus']->logable)
				ProductSale::addProductSale($product['id_product'], $product['quantity']);
	}

	public function hookUpdateOrderStatus($params)
	{
		if (!Validate::isLoadedObject($params['newOrderStatus']))
			die (Tools::displayError('plop1'));
		$oldOrderStatus = OrderHistory::getLastOrderState(intval($params['id_order']));
		if ($oldOrderStatus AND !Validate::isLoadedObject($oldOrderStatus))
			die (Tools::displayError());

		$cart = Cart::getCartByOrderId($params['id_order']);
		if (!Validate::isLoadedObject($cart))
			return false;

		foreach ($cart->getProducts() as $product)
			/* If becoming logable => adding sale */
			if ($params['newOrderStatus']->logable AND (!$oldOrderStatus OR !$oldOrderStatus->logable))
				ProductSale::addProductSale($product['id_product'], $product['quantity']);
			/* If becoming unlogable => removing sale */
			elseif (!$params['newOrderStatus']->logable AND ($oldOrderStatus AND $oldOrderStatus->logable))
				ProductSale::removeProductSale($product['id_product'], $product['quantity']);
		return true;
	}
}

?>
