<?php

class BlockCart extends Module
{
    private $_html = '';
    private $_directory;
    private $_filename;
    private $_filename_http;
    private $_postErrors = array();

    function __construct()
    {
        $this->name = 'blockcart';
        $this->tab = 'Blocks';
        $this->version = '1.0';

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Block cart');
        $this->description = $this->l('Add a block with the customer cart');
    }

    function install()
    {
        parent::install();
        $this->registerHook('rightColumn');
    }

	function hookRightColumn($params)
    {
		global $smarty;

		$currency = new Currency($params['cart']->id_currency);

		$smarty->assign(array(
			'products'=> $params['cart']->getProducts(),
			'discounts' => $params['cart']->getDiscounts(),
			'shipping_cost' => Tools::displayPrice($params['cart']->getOrderTotal(true, 5), $currency),
			'total' => Tools::displayPrice($params['cart']->getOrderTotal(), $currency),
			'id_carrier' => $params['cart']->id_carrier
		));

		return $this->display(__FILE__, 'blockcart.tpl');
	}
	
	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
}


?>
