<?php

class BlockCategories extends Module
{
    function __construct()
    {
        $this->name = 'blockcategories';
        $this->tab = 'Blocks';
        $this->version = 1.0;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Block categories');
        $this->description = $this->l('Add a block with products categories');
    }

    function install()
    {
        parent::install();
        $this->registerHook('leftColumn');
    }
   
    function hookLeftColumn($params)
    {
		global $smarty, $link;
		
		$smarty->assign(array(
			'categories' => Category::getHomeCategories(intval($params['cookie']->id_lang), true),
			'link' => $link
		));
		return $this->display(__FILE__, 'blockcategories.tpl');
	}
	
	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}
}

?>