<?php

class BlockNewProducts extends Module
{
    private $_html = '';
    private $_directory;
    private $_filename;
    private $_filename_http;
    private $_postErrors = array();

    function __construct()
    {
        $this->name = 'blocknewproducts';
        $this->tab = 'Blocks';
        $this->version = 0.9;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Block new products');
        $this->description = $this->l('Add a block with new products added');
    }

    function install()
    {
        if (parent::install() == false 
			OR $this->registerHook('rightColumn') == false
			OR Configuration::updateValue('NEW_PRODUCTS_NBR', 5) == false)
			return false;
		return true;
    }

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitBlockNewProducts'))
		{
			if (!$productNbr = Tools::getValue('productNbr') OR empty($productNbr))
				$output .= '<div class="alert error">'.$this->l('You should fill the "products displayed" field').'</div>';
			elseif (intval($productNbr) == 0)
				$output .= '<div class="alert error">'.$this->l('Invalid number.').'</div>';
			else
				Configuration::updateValue('NEW_PRODUCTS_NBR', intval($productNbr));
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Products displayed').'</label>
				<div class="margin-form">
					<input type="text" name="productNbr" value="'.Configuration::get('NEW_PRODUCTS_NBR').'" />
					<p class="clear">'.$this->l('Set the number of products displayed on this block').'</p>
				</div>
				<center><input type="submit" name="submitBlockNewProducts" value="'.$this->l('Save').'" class="button" /></center>			
			</fieldset>
		</form>';
		return $output;
	}

    function hookRightColumn($params)
    {
		global $smarty;
		$currency = new Currency(intval($params['cookie']->id_currency));
		$newProducts = Product::getNewProducts(intval($params['cookie']->id_lang), 0, Configuration::get('NEW_PRODUCTS_NBR'));

		$new_products = array();
		if ($newProducts)
			foreach ($newProducts AS $newProduct)
			{
				$newProduct['price'] = Tools::displayPrice(Product::getPriceStatic(intval($newProduct['id_product'])), $currency);
				$new_products[] = $newProduct;
			}

		$smarty->assign('new_products', $new_products);
		return $this->display(__FILE__, 'blocknewproducts.tpl');
	}
	
	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
}


?>
