<?php

class Blocknewsletter extends Module
{
 	function __construct()
 	{
 	 	$this->name = 'blocknewsletter';
 	 	$this->tab = 'Blocks';

	 	parent::__construct();

	 	/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
 	 	$this->displayName = $this->l('Block newsletter');
 	 	$this->description = $this->l('Adds a block with newsletter registration');
		
		$this->error = false;
		$this->valid = false;
 	}
 	
 	function install()
 	{
 	 	if (parent::install() == false OR $this->registerHook('leftColumn') == false)
 	 		return false;
 	 	return Db::getInstance()->Execute('CREATE TABLE '._DB_PREFIX_.'newsletter (`id` int(6) NOT NULL AUTO_INCREMENT, `email` varchar(255) NOT NULL, PRIMARY KEY(`id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8');
 	}
 	
 	function uninstall()
 	{
 	 	if (!parent::uninstall())
 	 		return false;
 	 	return Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'newsletter');
 	}

 	private function isNewsletterRegistered($customerEmail)
 	{
 	 	if (Db::getInstance()->getRow('SELECT `email` FROM '._DB_PREFIX_.'newsletter WHERE `email`=\''.pSQL($customerEmail).'\''))
 	 		return 1;
		if (!$registered = Db::getInstance()->getRow('SELECT `newsletter` FROM '._DB_PREFIX_.'customer WHERE `email`=\''.pSQL($customerEmail).'\''))
			return -1;
		if ($registered['newsletter'] == '1')
			return 2;
		return 0;
 	}
 	
 	private function newsletterRegistration()
 	{
	 	if (!Validate::isEmail($_POST['email']))
			return $this->error = $this->l('Invalid email');
	 	/* Unsubscription */
	 	elseif ($_POST['action'] == '1')
	 	{
 		 	$registerStatus = $this->isNewsletterRegistered($_POST['email']);
	 	 	if ($registerStatus < 1)
	 	 		return $this->error = $this->l('Email no registered');
	 	 	/* If the user ins't a customer */
	 	 	elseif ($registerStatus == 1)
	 	 	{
			  	if (!Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'newsletter WHERE `email`=\''.$_POST['email'].'\''))
	 	 			return $this->error = $this->l('Error during unsubscription');
	 	 		return $this->valid = $this->l('Unsubscription succeed');
	 	 	}
	 	 	/* If the user is a customer */
	 	 	elseif ($registerStatus == 2)
	 		{
	 	 		if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'customer SET `newsletter`=0 WHERE `email`=\''.pSQL($_POST['email']).'\''))
	 	 			return $this->error = $this->l('Error during unsubscription');
	 	 		return $this->valid = $this->l('Unsubscription succeed');
	 	 	}
		}
	 	/* Subscription */
	 	elseif ($_POST['action'] == '0')
	 	{
	 	 	$registerStatus = $this->isNewsletterRegistered($_POST['email']);
			if ($registerStatus > 0)
				return $this->error = $this->l('Email already registered');
			/* If the user ins't a customer */
			elseif ($registerStatus == -1)
			{
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'newsletter VALUES (\'\', \''.pSQL($_POST['email']).'\')'))
					return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription succeed');
			}
			/* If the user is a customer */
			elseif ($registerStatus == 0)
			{
			 	if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'customer SET `newsletter`=1 WHERE `email`=\''.pSQL($_POST['email']).'\''))
	 	 			return $this->error = $this->l('Error during subscription');
				return $this->valid = $this->l('Subscription succeed');
			}
			else
				exit('ok');
		}
 	}
	
	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}
 	
 	function hookLeftColumn($params)
 	{
		global $smarty;

		if (Tools::isSubmit('submitNewsletter'))
		{
			$this->newsletterRegistration();
			if ($this->error)
			{
				$smarty->assign('color', 'red');
				$smarty->assign('msg', $this->error);
				$smarty->assign('value', $_POST['email']);
				$smarty->assign('action', $_POST['action']);
			}
			elseif ($this->valid)
			{
				$smarty->assign('color', 'green');
				$smarty->assign('msg', $this->valid);
			}
		}
 	 	return $this->display(__FILE__, 'blocknewsletter.tpl');
 	}

	public function externalNewsletter(/*$params*/)
	{
		return $this->hookLeftColumn($params);
	}
}

?>