<?php

/**
  * Block Payment Logo
  * @category admin
  *
  * @author Joël Gaujard <joel.gaujard@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.1
  *
  */

class BlockPaymentLogo extends Module
{
	function __construct()
	{
		$this->name = 'blockpaymentlogo';
		$this->tab = 'Blocks';
		$this->version = 0.1;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Block payment logo');
		$this->description = $this->l('Adds a block to display all payment logo');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('leftColumn'))
			return false;
		return true;
	}

	/**
	* Returns module content
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookLeftColumn($params)
	{
		return $this->display(__FILE__, 'blockpaymentlogo.tpl');
	}

}
