<?php

/**
  * Block User Information
  * @category admin
  *
  * @author Joël Gaujard <joel.gaujard@prestashop.com>
  * @copyright PrestaShop
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 0.1
  *
  */

class BlockUserInfo extends Module
{
	function __construct()
	{
		$this->name = 'blockuserinfo';
		$this->tab = 'Blocks';
		$this->version = 0.1;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Block user information');
		$this->description = $this->l('Adds a block to display information about the customer');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('header'))
			return false;
		return true;
	}

	/**
	* Returns module content for header
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookHeader($params)
	{
		global $smarty, $cookie, $cart;
		$smarty->assign(array(
			'cart' => $cart,
			'cart_qties' => $cart->nbProducts(),
			'logged' => $cookie->isLogged(),
			'customerName' => (isset($cookie->logged) ? $cookie->customer_surname.' '.$cookie->customer_name : false)
		));
		return $this->display(__FILE__, 'blockuserinfo.tpl');
	}

}
