<?php

class Cheque extends PaymentModule
{
	private $_html = '';
	private $_postErrors = array();
	
	public  $chequeName;
	public  $address;

	function __construct()
	{
		$this->name = 'cheque';
		$this->tab = 'Payment';
		$this->version = 2.1;

		$config = Configuration::getMultiple(array('CHEQUE_NAME', 'CHEQUE_ADDRESS', 'CHEQUE_CURRENCIES'));
		if (isset($config['CHEQUE_NAME']))
			$this->chequeName = $config['CHEQUE_NAME'];
		if (isset($config['CHEQUE_ADDRESS']))
			$this->address = $config['CHEQUE_ADDRESS'];
		if (isset($config['CHEQUE_CURRENCIES']))
			$this->currencies = $config['CHEQUE_CURRENCIES'];
		parent::__construct();

		/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Cheque');
		$this->description = $this->l('Module accepting payments by cheque');
		if (!isset($this->address) OR !isset($this->address))
			$this->warning = $this->l('Name and address must be configured in order to use this module correctly');
		if (!Configuration::get('CHEQUE_CURRENCIES'))
		{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				$authorized_currencies[] = $currency['id_currency'];
			Configuration::updateValue('CHEQUE_CURRENCIES', implode(',', $authorized_currencies));
		}
	}

	function install()
	{
		parent::install();
		$this->registerHook('payment');
		$this->registerHook('paymentReturn');
		$currencies = Currency::getCurrencies();
		$authorized_currencies = array();
		foreach ($currencies as $currency)
			$authorized_currencies[] = $currency['id_currency'];
		Configuration::updateValue('CHEQUE_CURRENCIES', implode(',', $authorized_currencies));
}

	function uninstall()
	{
		Configuration::deleteByName('CHEQUE_NAME');
		Configuration::deleteByName('CHEQUE_ADDRESS');
		Configuration::deleteByName('CHEQUE_CURRENCIES');
		parent::uninstall();
	}

	private function _postValidation()
	{
		if (isset($_POST['btnSubmit']))
		{
			if (empty($_POST['name']))
				$this->_postErrors[] = $this->l('name is required.');
			elseif (empty($_POST['address']))
				$this->_postErrors[] = $this->l('address is required.');
		}
		elseif (isset($_POST['currenciesSubmit']))
		{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				if (isset($_POST['currency_'.$currency['id_currency']]) AND $_POST['currency_'.$currency['id_currency']])
					$authorized_currencies[] = $currency['id_currency'];
			if (!count($authorized_currencies))
				$this->_postErrors[] = $this->l('at least one currency is required.');
		}
	}

	private function _postProcess()
	{
		if (isset($_POST['btnSubmit']))
		{
			Configuration::updateValue('CHEQUE_NAME', $_POST['name']);
			Configuration::updateValue('CHEQUE_ADDRESS', $_POST['address']);
		}
		elseif (isset($_POST['currenciesSubmit']))
		{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				if (isset($_POST['currency_'.$currency['id_currency']]) AND $_POST['currency_'.$currency['id_currency']])
					$authorized_currencies[] = $currency['id_currency'];
			Configuration::updateValue('CHEQUE_CURRENCIES', implode(',', $authorized_currencies));
		}
		$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('Settings updated').'</div>';
	}

	private function _displayCheque()
	{
		$this->_html .= '<img src="../modules/cheque/cheque.jpg" style="float:left; margin-right:15px;"><b>'.$this->l('This module allows you to accept payments by cheques.').'</b><br /><br />
		'.$this->l('If the client chooses this payment mode, the order will change its status into a \'Waiting for payment\' status.').'<br />
		'.$this->l('So you need to confirm manually your order as soon as you receive this cheque.').'<br /><br /><br />';
	}

	private function _displayForm()
	{
		$this->_html .=
		'<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
			<legend><img src="../img/admin/contact.gif" />'.$this->l('Contact details').'</legend>
				<table border="0" width="500" cellpadding="0" cellspacing="0" id="form">
					<tr><td colspan="2">'.$this->l('Please specify the name and the address to which customers must write and send their cheque').'.<br /><br /></td></tr>
					<tr><td width="130" style="height: 35px;">'.$this->l('Name').'</td><td><input type="text" name="name" value="'.Tools::getValue('name', $this->chequeName).'" style="width: 300px;" /></td></tr>
					<tr>
						<td width="130" style="vertical-align: top;">'.$this->l('Address').'</td>
						<td><textarea name="address" rows="3" cols="53">'.Tools::getValue('address', $this->address).'</textarea></td>
					</tr>
					<tr><td colspan="2" align="center"><br /><input class="button" name="btnSubmit" value="'.$this->l('Update settings').'" type="submit" /></td></tr>
				</table>
			</fieldset>
		</form>
		<br /><br />
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
			<legend><img src="../img/t/15.gif" />'.$this->l('Authorized currencies').'</legend>
				<table border="0" width="500" cellpadding="0" cellspacing="0" id="form">
					<tr><td colspan="2">'.$this->l('Currencies authorized for cheque payment. Customers will be able to write cheque using theses currencies').'.<br /><br /></td></tr>
					<tr>
						<td width="130" style="height: 35px; vertical-align:top">'.$this->l('Currencies').'</td>
						<td>';
						$currencies = Currency::getCurrencies();
						$authorized_currencies = array_flip(explode(',', Configuration::get('CHEQUE_CURRENCIES')));
						foreach ($currencies as $currency)
							$this->_html .= '<label style="float:none; "><input type="checkbox" value="true" name="currency_'.$currency['id_currency'].'"'.(isset($authorized_currencies[$currency['id_currency']]) ? ' checked="checked"' : '').' />&nbsp;<span style="font-weight:bold;">'.$currency['name'].'</span> ('.$currency['sign'].')</label><br />';
			$this->_html .='
						</td>
					</tr>
					<tr><td colspan="2" align="center"><br /><input class="button" name="currenciesSubmit" value="'.$this->l('Update settings').'" type="submit" /></td></tr>
				</table>
			</fieldset>
		</form>';
	}

	function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
	
		if (!empty($_POST))
		{
			$this->_postValidation();
			if (!count($this->_postErrors))
				$this->_postProcess();
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= '<div class="alert error">'. $err .'</div>';
		}
		else
			$this->_html .= '<br />';
	
		$this->_displayCheque();
		$this->_displayForm();
	
		return $this->_html;
	}

	function execPayment($cart)
	{
		global $cookie, $smarty;

		$currencies = Currency::getCurrencies();
		$authorized_currencies = array_flip(explode(',', $this->currencies));
		$currencies_used = array();
		foreach ($currencies as $key => $currency)
			if (isset($authorized_currencies[$currency['id_currency']]))
				$currencies_used[] = $currencies[$key];
		$smarty->assign(array(
			'currency_default' => new Currency(Configuration::get('PS_CURRENCY_DEFAULT')),
			'currencies' => $currencies_used,
			'total' => number_format($cart->getOrderTotal(true, 3), 2, '.', ''),
			'isoCode' => Language::getIsoById(intval($cookie->id_lang)),
			'chequeName' => $this->chequeName,
			'chequeAddress' => nl2br2($this->address),
			'this_path' => $this->_path
		));

		return $this->display(__FILE__, 'payment_execution.tpl');
	}

	function hookPayment($params)
	{
		global $smarty;

		$smarty->assign('this_path', $this->_path);
		return $this->display(__FILE__, 'payment.tpl');
	}

	function hookPaymentReturn($params)
	{
		global $smarty;
		$state = $params['objOrder']->getCurrentState();
		if ($state == _PS_OS_CHEQUE_ OR $state == _PS_OS_OUTOFSTOCK_)
			$smarty->assign(array(
				'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false, false),
				'chequeName' => $this->chequeName,
				'chequeAddress' => nl2br2($this->address),
				'status' => 'ok',
				'id_order' => $params['objOrder']->id
			));
		else
			$smarty->assign('status', 'failed');
		return $this->display(__FILE__, 'payment_return.tpl');
	}

}

?>