<?php


class GAnalytics extends Module
{	
	function __construct()
	{
	 	$this->name = 'ganalytics';
	 	$this->tab = 'Stats';
	 	$this->version = '1.0';
        $this->displayName = 'Google Analytics';
		
	 	parent::__construct();
		
		$this->page = basename(__FILE__, '.php');
		if (!Configuration::get('GANALYTICS_ID'))
			$this->warning = $this->l('You have not yet set your google analytics ID');
        $this->description = $this->l('Integrate the google analytics script into your shop');
	}
	
    function install()
    {
        parent::install();
        $this->registerHook('header');
    }
	
	function uninstall()
	{
		Configuration::deleteByName('GANALYTICS_ID');
		parent::uninstall();
	}
	
	public function getContent()
	{
		$output = '<h2>Google Analytics</h2>';
		if (Tools::isSubmit('submitGAnalytics') AND ($gai = Tools::getValue('ganalytics_id')))
		{
			Configuration::updateValue('GANALYTICS_ID', $gai);
			$output .= '
			<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend>'.$this->l('Settings').'</legend>
				<label>'.$this->l('Your identifier').'</label>
				<div class="margin-form">
					<input type="text" name="ganalytics_id" value="'.Tools::getValue('ganalytics_id', Configuration::get('GANALYTICS_ID')).'" />
					<p class="clear">'.$this->l('Example:').' UA-1234567-1</p>
				</div>
				<center><input type="submit" name="submitGAnalytics" value="'.$this->l('Update ID').'" class="button" /></center>			
			</fieldset>
		</form>';
		return $output;
	}
	
	function hookHeader($params)
	{
		$output = '
		<script src="http://www.google-analytics.com/urchin.js" type="text/javascript"></script>
		<script type="text/javascript">
			_uacct = "'.Configuration::get('GANALYTICS_ID').'";
			urchinTracker();
		</script>';
		return $output;
	}
}
?>