<?php

class MailAlerts extends Module
{
 	private $_html = '';
    private $_postErrors = array();
    private $_postSucess;    
 	private $_data;
 	
 	private $_mails;
 	private $_alertNewOrder;
 	private $_alertUpdateQuantity;
	private $_files = array();
 	
 	const __MA_MAIL_DELIMITOR__ = ',';
	
 	
	public function __construct()
	{
		$this->name = 'mailalerts';
        $this->tab = 'Tools';
		$this->_version = 1.0;
					 
		$this->_mails =  Configuration::get('MA_MAILS');
		$this->_alertNewOrder = intval(Configuration::get('MA_NEW_ORDER'));
		$this->_alertUpdateQuantity = intval(Configuration::get('MA_UPDATE_QUANTITY'));
		
		$this->_files = array(
			'name' => array('new_order', 'productoutofstock'),
			'ext' => array(
				0 => 'html',
				1 => 'txt'
			)
		);
		
	 	parent::__construct();
	 	
	 	/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
	 	$this->displayName = $this->l('Mail alerts');
		$this->description = $this->l('Sends mails for new orders and stock notifications');
	}
   
   	public function install()
   	{
   	 	parent::install();
   	 	$this->registerHook('NewOrder');
   	 	$this->registerHook('UpdateQuantity');

		Configuration::updateValue('MA_NEW_ORDER', 1);
		Configuration::updateValue('MA_UPDATE_QUANTITY', 1);
		Configuration::updateValue('MA_MAILS', Configuration::get('PS_SHOP_EMAIL'));
		
		// Copy templates from install dir to mails dir
		$src_dir = dirname(__FILE__).'/templates/';
		$dest_dir = _PS_MAIL_DIR_;
		foreach ($this->_files['name'] as $name)
			foreach ($this->_files['ext'] as $ext) {
				$languages = Language::getLanguages();
				foreach ($languages as $language)
				{
					$src = $src_dir.$name.'_'.$language['iso_code'].'.'.$ext;
					$dest = $dest_dir.$language['iso_code'].'/'.$name.'.'.$ext;
					if (file_exists($src) AND !copy($src, $dest))
						die(Tools::displayError('Error: cannot copy templates mail file !<br />-> Source: '.$src.'<br /><- Dest: '.$dest));
				}
			}
	}
	
	public function uninstall()
	{
		Configuration::deleteByName('MA_MAILS');
		Configuration::deleteByName('MA_NEW_ORDER');
		Configuration::deleteByName('MA_UPDATE_QUANTITY');
		
		// Delete mails templates
		$dir = _PS_MAIL_DIR_;
		foreach ($this->_files['name'] as $name)
			foreach ($this->_files['ext'] as $ext) {
				$languages = Language::getLanguages();
				foreach ($languages as $language)
				{
					$src = $dir.$language['iso_code'].'/'.$name.'.'.$ext;
					if (file_exists($src) AND !unlink($src))
						die(Tools::displayError('Error: cannot delete templates mail file !<br />-> '.$src));
				}
			}
		parent::uninstall();
	}

    public function hookNewOrder($params)
    {
		if (!$this->_alertNewOrder OR empty($this->_mails))
			return;

		$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
		
		// Getting differents vars
		$configuration = Configuration::getMultiple(array('PS_SHOP_EMAIL', 'PS_MAIL_METHOD', 'PS_MAIL_SERVER', 'PS_MAIL_USER', 'PS_MAIL_PASSWD', 'PS_SHOP_NAME'));
		$order = $params['order'];
		$customer = $params['customer'];
		$delivery = new Address(intval($order->id_address_invoice));
		$invoice = new Address(intval($order->id_address_delivery));
		$order_date_text = Tools::displayDate($order->date_add, intval($id_lang));
		$carrier = new Carrier(intval($order->id_carrier));
     	$products = $params['cart']->getProducts();
		$productsList = '';
		foreach ($products as $product)
		{
			$productsList .= '<tr>';
			$productsList .= '<td>'.$product['quantity'].'</td>';
			$productsList .= '<td>'.$product['name'].'</td>';
			$productsList .= '<td align="right">'.$product['price'].'</td>';
			$productsList .= '</tr>';
		}
		$discounts = $params['cart']->getDiscounts();
		$discountsList = '';
     	foreach ($discounts as $discount)
		{
			$discountsList .= '<tr>';
			$discountsList .= '<td>'.$discount['name'].'</td>';
			$discountsList .= '<td>'.$discount['description'].'</td>';
			$discountsList .= '<td align="right">'.$discount['value'].'</td>';
			$discountsList .= '</tr>';
		}
		if (empty($discountsList))
			$discountsList = '<tr><td colspan="3" align="center">'.$this->l('No discount').'</td></tr>';
     	$currency = $params['currency'];
     	$orderState = $order->getCurrentStateFull(intval($id_lang));
		$to = split(',', $this->_mails);

		// Filling-in vars for mail
		$template = 'new_order';
		$subject = $this->l('New order');
		$templateVars = array(
		'{surname}' => $customer->surname,
		'{name}' => $customer->name,
		'{email}' => $customer->email,
		'{delivery_surname}' => $delivery->surname,
		'{delivery_name}' => $delivery->name,
		'{delivery_address1}' => $delivery->address1,
		'{delivery_address2}' => $delivery->address2,
		'{delivery_city}' => $delivery->city,
		'{delivery_postal_code}' => $delivery->postcode,
		'{delivery_country}' => $delivery->country,
		'{invoice_surname}' => $invoice->surname,
		'{invoice_name}' => $invoice->name,
		'{invoice_address2}' => $invoice->address2,
		'{invoice_address1}' => $invoice->address1,
		'{invoice_city}' => $invoice->city,
		'{invoice_postal_code}' => $invoice->postcode,
		'{invoice_country}' => $invoice->country,
		'{order_name}' => sprintf("%06d", $order->id),
		'{shop_name}' => Configuration::get('PS_SHOP_NAME'),
		'{date}' => $order_date_text,
		'{carrier}' => $carrier->name,
		'{payment}' => $order->payment,
		'{state}' => $orderState['name'],
		'{products}' => $productsList,
		'{discounts}' => $discountsList,
		'{total_paid}' => $order->total_paid,
		'{total_products}' => $order->getTotalProductsWithTaxes(),
		'{total_discounts}' => $order->total_discounts,
		'{total_shipping}' => $order->total_shipping,
		'{currency}' => $currency->sign);
		$from = $configuration['PS_SHOP_EMAIL'];
		$fromName = $configuration['PS_SHOP_NAME'];
		
		// Sending mail
		Mail::Send($id_lang, $template, $subject, $templateVars, $to, NULL, $from, $fromName, NULL);
	}

	public function hookUpdateQuantity($params)
	{
		$qty = intval($params['product']['quantity_attribute'] ? $params['product']['quantity_attribute'] : $params['product']['stock_quantity']) - intval($params['product']['quantity']);
		if ($qty <= intval(Configuration::get('PS_LAST_QTIES')))
		{
			if (!$this->_alertUpdateQuantity OR empty($this->_mails))
				return ;
			$id_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
			
			// Filling-in vars for mail
			$template = 'productoutofstock';
			$subject = $this->l('Product out of stock');
			$templateVars = array(
			'{last_qty}' => intval(Configuration::get('PS_LAST_QTIES')),
			'{qty}' => $qty,
			'{product}' => strval($params['product']['name']));
			$to = split(',', $this->_mails);
			$from = strval(Configuration::get('PS_SHOP_EMAIL'));
			$fromName = strval(Configuration::get('PS_SHOP_NAME'));
			
			// Sending mail
			Mail::Send($id_lang, $template, $subject, $templateVars, $to, NULL, $from, $fromName, NULL);
		}
	}

	public function getContent()
	{
	  	$this->_html = '<h2>'.$this->displayName.'</h2><br/>';

        if (!empty($_POST))
        {
		    $this->_postValidation();
	        if (!count($this->_postErrors))
	           $this->_postProcess();
	        else
	            foreach ($this->_postErrors AS $err)
	                $this->_html .= '<div class="errmsg">'.$err.'</div>';
        }
       	$this->_displayForm();
        return $this->_html;
	}
    
    private function _displayForm()
    {
        if (!isset($_POST['btnSubmit']))
        {
            if ($this->_mails)
            {
             	$_POST['mails'] = str_replace(self::__MA_MAIL_DELIMITOR__, "\n", $this->_mails);
            	$_POST['alert_new_order'] = $this->_alertNewOrder;
            	$_POST['alert_update_quantity'] = $this->_alertUpdateQuantity;
			}
        }

        $button_txt = $this->l('Update settings');
        $this->_html .=
		'<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" /> '.$this->l('Settings').'</legend>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
		<table id="form" cellspacing="5">
				<tr><td colspan="2"><h4><u>'.$this->l('Alerts reception').'</u></h4></td></tr>
				 <tr>
					<td>'.$this->l('New order notification ?').'</td>
					<td><input type="checkbox" value="1" name="alert_new_order" '.( (isset($_POST['alert_new_order']) AND $_POST['alert_new_order'] == '1') ? 'checked' : '').'></td>
					
				</tr>
				<tr>
					<td>'.$this->l('Stock notification ?').'</td>
					<td><input type="checkbox" value="1" name="alert_update_quantity" '.( (isset($_POST['alert_update_quantity']) AND $_POST['alert_update_quantity'] == '1') ? 'checked' : '').'></td>
				</tr>
				<tr><td colspan="2"><h4><u>'.$this->l('E-mails').'</u></h4></td></tr>
				<tr><td style="vertical-align: top;">
				<span>One e-mail per line<br />'.$this->l('Ex: bob@example.com').'</span></a></td>
				<td>
					<textarea name="mails" rows="10" cols="30">'.(isset($_POST['mails']) ? $_POST['mails'] : '').'</textarea>
				</td></tr>
				
                <tr>
					<td colspan="2" align="center"><input name="btnSubmit" value="'.$button_txt.'" type="submit" /></td>				
				</tr>
            </table>
        </form></fieldset>';
    }

	private function _postProcess()
	{
		$this->_alertNewOrder = isset($_POST['alert_new_order']) ? 1 : 0;
		$this->_alertUpdateQuantity = isset($_POST['alert_update_quantity']) ? 1 : 0;
		
		Configuration::updateValue('MA_NEW_ORDER', isset($_POST['alert_new_order']) ? 1 : 0);
		Configuration::updateValue('MA_UPDATE_QUANTITY', isset($_POST['alert_update_quantity']) ? 1 : 0);
        
        $mails = explode("\n", $_POST['mails']);
        $this->_mails = '';
		foreach ($mails as $mail)
			$this->_mails .= trim($mail).self::__MA_MAIL_DELIMITOR__;
		$this->_mails = trim($this->_mails, ',');
		Configuration::updateValue('MA_MAILS', $this->_mails);
        $this->_html .= '<div class="validmsg">'.$this->l('Settings updated').'</div>';
	}

	private function _postValidation()
	{
		if (!isset($_POST['mails']) OR empty($_POST['mails']))
			$this->_postErrors[] = $this->l('No e-mails specified');
		else
		{
			$mails = explode("\n", $_POST['mails']);
			foreach ($mails as $mail)
			{
				$mail = trim($mail);
          		if (!empty($mail) AND !Validate::isEmail($mail))
					$this->_postErrors[]  = $this->l('Unvalid e-mail: ').$mail.'.';
			}
		}
	}
}
?>